/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.collections;

import java.util.Arrays;

public class IntMaxHeap {
    private int size;
    private int[] values;

    public IntMaxHeap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.values = new int[initialCapacity == 0 ? 1 : initialCapacity];
    }

    public void add(int v) {
        this.ensureCapacity(this.size + 1);
        this.addWithoutCheckingCapacity(v);
    }

    private void addWithoutCheckingCapacity(int v) {
        int q;
        int u;
        int p = this.size++;
        this.values[p] = v;
        while (p > 0 && (u = this.values[q = p - 1 >> 1]) < v) {
            this.values[p] = u;
            this.values[q] = v;
            p = q;
        }
    }

    public void add(int ... v) {
        if (v == null) {
            throw new IllegalArgumentException("the input array cannot be null");
        }
        this.ensureCapacity(v.length + this.size);
        for (int i : v) {
            this.addWithoutCheckingCapacity(i);
        }
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(newSize, 10 + this.values.length << 1));
        }
    }

    public int peek() {
        if (this.size == 0) {
            throw new IllegalStateException("the heap is empty");
        }
        return this.values[0];
    }

    public int remove() {
        if (this.size == 0) {
            throw new IllegalArgumentException("the heap is empty");
        }
        int result = this.values[0];
        this.removeUpdate();
        return result;
    }

    private void removeUpdate() {
        if (--this.size == 0) {
            return;
        }
        int v = this.values[this.size];
        int p = 0;
        this.values[0] = v;
        int limit = this.size >> 1;
        while (p < limit) {
            int rv;
            int r = p + 1 << 1;
            int l = r - 1;
            int u = v;
            int q = p;
            int lv = this.values[l];
            if (lv > u) {
                u = lv;
                q = l;
            }
            if (r < this.size && (rv = this.values[r]) > u) {
                u = rv;
                q = r;
            }
            if (p == q) break;
            this.values[p] = u;
            this.values[q] = v;
            p = q;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }
}

