/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.collections;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class IndexedSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final ArrayList<E> elements;
    private transient List<E> unmodifiableElementsListView;
    private final Object2IntMap<E> indexByElement;

    public IndexedSet(int initialCapacity) {
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new Object2IntOpenHashMap(initialCapacity);
    }

    public IndexedSet(Collection<E> values) {
        if (values == null) {
            throw new IllegalArgumentException("input values cannot be null");
        }
        int initialCapacity = values.size();
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new Object2IntOpenHashMap(initialCapacity);
        int nextIndex = 0;
        for (E value : values) {
            if (value == null) {
                throw new IllegalArgumentException("null element not allowed: index == " + nextIndex);
            }
            if (this.indexByElement.containsKey(value)) continue;
            this.indexByElement.put(value, nextIndex++);
            this.elements.add(value);
        }
    }

    public IndexedSet(E ... values) {
        if (values == null) {
            throw new IllegalArgumentException("input values cannot be null");
        }
        int initialCapacity = values.length;
        this.elements = new ArrayList(initialCapacity);
        this.indexByElement = new Object2IntOpenHashMap(initialCapacity);
        int nextIndex = 0;
        for (E value : values) {
            if (value == null) {
                throw new IllegalArgumentException("null element not allowed: index == " + nextIndex);
            }
            if (this.indexByElement.containsKey(value)) continue;
            this.indexByElement.put(value, nextIndex++);
            this.elements.add(value);
        }
    }

    public List<E> asList() {
        if (this.unmodifiableElementsListView == null) {
            this.unmodifiableElementsListView = Collections.unmodifiableList(this.elements);
        }
        return this.unmodifiableElementsListView;
    }

    protected void checkIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("the index cannot be negative: " + index);
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("the index is equal or larger than the list length: " + index + " >= " + this.size());
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && this.indexByElement.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new IllegalArgumentException("the input argument cannot be null");
        }
        if (this.contains(o)) {
            return false;
        }
        int nextIndex = this.size();
        this.elements.add(o);
        this.indexByElement.put(o, nextIndex);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexByElement.removeInt(o);
        if (index == -1) {
            return false;
        }
        this.elements.remove(index);
        this.indexByElement.remove(o);
        ListIterator<E> it = this.elements.listIterator(index);
        int nextIndex = index;
        while (it.hasNext()) {
            this.indexByElement.put(it.next(), nextIndex++);
        }
        return true;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.indexByElement.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof IndexedSet)) {
            return false;
        }
        IndexedSet other = (IndexedSet)o;
        return this.equals(other);
    }

    public boolean equals(IndexedSet<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        ArrayList<E> otherElements = other.elements;
        int elementCount = this.elements.size();
        if (otherElements.size() != elementCount) {
            return false;
        }
        for (int i = 0; i < elementCount; ++i) {
            if (this.elements.get(i).equals(otherElements.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (E element : this.elements) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public E get(int index) {
        this.checkIndex(index);
        return this.elements.get(index);
    }

    public int indexOf(E o) {
        if (o == null) {
            throw new IllegalArgumentException("the query object cannot be null");
        }
        return this.indexByElement.containsKey(o) ? this.indexByElement.getInt(o) : -1;
    }
}

