/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.table;

import java.util.Arrays;
import org.broadinstitute.gatk.utils.codecs.table.TableCodec;
import org.broadinstitute.gatk.utils.codecs.table.TableFeature;
import org.broadinstitute.gatk.utils.refdata.ReferenceDependentFeatureCodec;

public class BedTableCodec
extends TableCodec
implements ReferenceDependentFeatureCodec {
    @Override
    public TableFeature decode(String line) {
        if (line.startsWith("HEADER") || line.startsWith("#") || line.startsWith("track")) {
            return null;
        }
        String[] split = line.split("\\s+");
        if (split.length < 1) {
            throw new IllegalArgumentException("TableCodec line = " + line + " doesn't appear to be a valid table format");
        }
        return new TableFeature(this.genomeLocParser.createGenomeLoc(split[0], Integer.parseInt(split[1]) - 1, Integer.parseInt(split[2])), Arrays.asList(split), this.header);
    }
}

