/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.samread;

import htsjdk.tribble.Feature;

public class SAMReadFeature
implements Feature {
    private final String readName;
    private final int flags;
    private final String contig;
    private final int alignmentStart;
    private final int alignmentEnd;
    private final int mapQ;
    private final String cigarString;
    private final String mateContig;
    private final int mateAlignmentStart;
    private final int insertSize;
    private final byte[] bases;
    private final byte[] qualities;

    SAMReadFeature(String readName, int flags, String contig, int alignmentStart, int alignmentEnd, int mapQ, String cigarString, String mateContig, int mateAlignmentStart, int insertSize, byte[] bases, byte[] qualities) {
        this.readName = readName;
        this.flags = flags;
        this.contig = contig;
        this.alignmentStart = alignmentStart;
        this.alignmentEnd = alignmentEnd;
        this.mapQ = mapQ;
        this.cigarString = cigarString;
        this.mateContig = mateContig;
        this.mateAlignmentStart = mateAlignmentStart;
        this.insertSize = insertSize;
        this.bases = bases;
        this.qualities = qualities;
    }

    public String getReadName() {
        return this.readName;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getReferenceName() {
        return this.contig;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public String getChr() {
        return this.getContig();
    }

    @Override
    public String getContig() {
        return this.getReferenceName();
    }

    @Override
    public int getStart() {
        return this.getAlignmentStart();
    }

    @Override
    public int getEnd() {
        return this.getAlignmentEnd();
    }

    public int getMappingQuality() {
        return this.mapQ;
    }

    public String getCigarString() {
        return this.cigarString;
    }

    public String getMateReferenceName() {
        return this.mateContig;
    }

    public int getMateAlignmentStart() {
        return this.mateAlignmentStart;
    }

    public int getInferredInsertSize() {
        return this.insertSize;
    }

    public byte[] getReadBases() {
        return this.bases;
    }

    public byte[] getReadQualities() {
        return this.qualities;
    }
}

