/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.sampileup;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.util.ParsingUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.gatk.utils.codecs.sampileup.SAMPileupFeature;

public class SAMPileupCodec
extends AsciiFeatureCodec<SAMPileupFeature> {
    private static final int basicTokenCount = 6;
    private static final int consensusSNPTokenCount = 10;
    private static final int consensusIndelTokenCount = 13;
    private static final char fldDelim = '\t';
    private static final String baseA = "A";
    private static final String baseC = "C";
    private static final String baseG = "G";
    private static final String baseT = "T";
    private static final String emptyStr = "";
    protected static final String FILE_EXT = "samp";

    public SAMPileupCodec() {
        super(SAMPileupFeature.class);
    }

    @Override
    public SAMPileupFeature decode(String line) {
        String[] tokens = new String[14];
        int count = ParsingUtils.split(line, tokens, '\t');
        SAMPileupFeature feature = new SAMPileupFeature();
        feature.setChr(tokens[0]);
        feature.setStart(Integer.parseInt(tokens[1]));
        if (tokens[2].length() != 1) {
            throw new CodecLineParsingException("The SAM pileup line had unexpected base " + tokens[2] + " on line = " + line);
        }
        feature.setRef(tokens[2].charAt(0));
        switch (count) {
            case 6: {
                String bases = tokens[4];
                String quals = tokens[5];
                if (feature.getRef() == '*') {
                    throw new CodecLineParsingException("Found an indel on line = " + line + " but it shouldn't happen in simple pileup format");
                }
                this.parseBasesAndQuals(feature, bases, quals);
                feature.setRefBases(tokens[2].toUpperCase());
                feature.setEnd(feature.getStart());
                break;
            }
            case 10: {
                String observedString = tokens[3].toUpperCase();
                feature.setFWDAlleles(new ArrayList<String>(2));
                feature.setConsensusConfidence(Double.parseDouble(tokens[4]));
                feature.setVariantConfidence(Double.parseDouble(tokens[5]));
                String bases = tokens[8];
                String quals = tokens[9];
                if (feature.getRef() == '*') {
                    throw new CodecLineParsingException("Line parsing of " + line + " says we have a SNP or non-variant but the ref base is '*', which indicates an indel");
                }
                this.parseBasesAndQuals(feature, bases, quals);
                if (observedString.length() != 1) {
                    throw new CodecLineParsingException("Line parsing of " + line + " says we have a SNP or non-variant but the genotype token is not a single letter: " + observedString);
                }
                feature.setRefBases(tokens[2].toUpperCase());
                feature.setEnd(feature.getStart());
                char ch = observedString.charAt(0);
                switch (ch) {
                    case 'A': {
                        feature.getFWDAlleles().add(baseA);
                        feature.getFWDAlleles().add(baseA);
                        break;
                    }
                    case 'C': {
                        feature.getFWDAlleles().add(baseC);
                        feature.getFWDAlleles().add(baseC);
                        break;
                    }
                    case 'G': {
                        feature.getFWDAlleles().add(baseG);
                        feature.getFWDAlleles().add(baseG);
                        break;
                    }
                    case 'T': {
                        feature.getFWDAlleles().add(baseT);
                        feature.getFWDAlleles().add(baseT);
                        break;
                    }
                    case 'M': {
                        feature.getFWDAlleles().add(baseA);
                        feature.getFWDAlleles().add(baseC);
                        break;
                    }
                    case 'R': {
                        feature.getFWDAlleles().add(baseA);
                        feature.getFWDAlleles().add(baseG);
                        break;
                    }
                    case 'W': {
                        feature.getFWDAlleles().add(baseA);
                        feature.getFWDAlleles().add(baseT);
                        break;
                    }
                    case 'S': {
                        feature.getFWDAlleles().add(baseC);
                        feature.getFWDAlleles().add(baseG);
                        break;
                    }
                    case 'Y': {
                        feature.getFWDAlleles().add(baseC);
                        feature.getFWDAlleles().add(baseT);
                        break;
                    }
                    case 'K': {
                        feature.getFWDAlleles().add(baseG);
                        feature.getFWDAlleles().add(baseT);
                    }
                }
                if (feature.getFWDAlleles().get(0).charAt(0) == feature.getRef() && feature.getFWDAlleles().get(1).charAt(0) == feature.getRef()) {
                    feature.setVariantType(SAMPileupFeature.VariantType.NONE);
                    break;
                }
                feature.setVariantType(SAMPileupFeature.VariantType.SNP);
                if (feature.getFWDAlleles().get(0).charAt(0) == feature.getRef() || feature.getFWDAlleles().get(1).charAt(0) == feature.getRef() || feature.getFWDAlleles().get(0).equals(feature.getFWDAlleles().get(1))) {
                    feature.setNumNonRef(1);
                    break;
                }
                feature.setNumNonRef(2);
                break;
            }
            case 13: {
                String observedString = tokens[3].toUpperCase();
                feature.setFWDAlleles(new ArrayList<String>(2));
                feature.setConsensusConfidence(Double.parseDouble(tokens[4]));
                feature.setVariantConfidence(Double.parseDouble(tokens[5]));
                if (feature.getRef() != '*') {
                    throw new CodecLineParsingException("Line parsing of " + line + " says we have an indel but the ref base is not '*'");
                }
                this.parseIndels(observedString, feature);
                if (feature.isDeletion()) {
                    feature.setEnd(feature.getStart() + feature.length() - 1);
                    break;
                }
                feature.setEnd(feature.getStart());
                break;
            }
            default: {
                throw new CodecLineParsingException("The SAM pileup line didn't have the expected number of tokens (expected = 6 (basic pileup), 10 (consensus pileup for a SNP or non-variant site) or 13 (consensus pileup for an indel); saw = " + count + " on line = " + line + ")");
            }
        }
        return feature;
    }

    @Override
    public boolean canDecode(String path) {
        return path.endsWith(".samp");
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    private void parseIndels(String genotype, SAMPileupFeature feature) {
        String[] obs = genotype.split("/");
        boolean hasRefAllele = false;
        for (int i = 0; i < obs.length; ++i) {
            if (obs[i].length() == 1 && obs[i].charAt(0) == '*') {
                hasRefAllele = true;
                feature.getFWDAlleles().add(emptyStr);
                continue;
            }
            String varBases = obs[i].toUpperCase();
            switch (obs[i].charAt(0)) {
                case '+': {
                    if (!feature.isReference() && !feature.isInsertion()) {
                        feature.setVariantType(SAMPileupFeature.VariantType.INDEL);
                    } else {
                        feature.setVariantType(SAMPileupFeature.VariantType.INSERTION);
                    }
                    feature.setRefBases(emptyStr);
                    break;
                }
                case '-': {
                    if (!feature.isReference() && !feature.isDeletion()) {
                        feature.setVariantType(SAMPileupFeature.VariantType.INDEL);
                    } else {
                        feature.setVariantType(SAMPileupFeature.VariantType.DELETION);
                    }
                    feature.setRefBases(varBases);
                    break;
                }
                default: {
                    throw new CodecLineParsingException("Can not interpret observed indel allele record: " + genotype);
                }
            }
            feature.getFWDAlleles().add(varBases);
            feature.setLength(obs[i].length() - 1);
        }
        if (hasRefAllele) {
            if (feature.isReference()) {
                feature.setNumNonRef(0);
                feature.setRefBases(emptyStr);
            } else {
                feature.setNumNonRef(1);
            }
        } else if (feature.getFWDAlleles().get(0).equals(feature.getFWDAlleles().get(1))) {
            feature.setNumNonRef(1);
        } else {
            feature.setNumNonRef(2);
        }
    }

    private void parseBasesAndQuals(SAMPileupFeature feature, String bases, String quals) {
        StringBuilder baseBuilder = new StringBuilder();
        StringBuilder qualBuilder = new StringBuilder();
        boolean done = false;
        int j = 0;
        block7: for (int i = 0; i < bases.length() && !done; ++i) {
            char c = bases.charAt(i);
            switch (c) {
                case ',': 
                case '.': {
                    baseBuilder.append(feature.getRef());
                    qualBuilder.append(quals.charAt(j++));
                    continue block7;
                }
                case '$': {
                    continue block7;
                }
                case '*': {
                    ++j;
                    continue block7;
                }
                case '^': {
                    ++i;
                    continue block7;
                }
                case '+': 
                case '-': {
                    Pattern regex = Pattern.compile("([0-9]+).*");
                    String rest = bases.substring(i + 1);
                    Matcher match = regex.matcher(rest);
                    if (!match.matches()) {
                        if (feature.getRef() != '*') {
                            throw new CodecLineParsingException("Bad pileup format: " + bases + " at position " + i);
                        }
                        done = true;
                        continue block7;
                    }
                    String g = match.group(1);
                    int l = Integer.parseInt(g);
                    i += l + g.length();
                    continue block7;
                }
                default: {
                    baseBuilder.append(c);
                    qualBuilder.append(quals.charAt(j++));
                }
            }
        }
        feature.setPileupBases(baseBuilder.toString());
        feature.setPileupQuals(qualBuilder.toString());
    }
}

