/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.hapmap;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.readers.LineIterator;
import java.io.IOException;
import java.util.Arrays;
import org.broadinstitute.gatk.utils.codecs.hapmap.RawHapMapFeature;

public class RawHapMapCodec
extends AsciiFeatureCodec<RawHapMapFeature> {
    private static final int minimumFeatureCount = 11;
    private String headerLine;
    protected static final String FILE_EXT = "hapmap";

    public RawHapMapCodec() {
        super(RawHapMapFeature.class);
    }

    @Override
    public RawHapMapFeature decode(String line) {
        String[] array = line.split("\\s+");
        if (array.length < 11) {
            throw new IllegalArgumentException("Unable to parse line " + line + ", the length of split features is less than the minimum of " + 11);
        }
        return new RawHapMapFeature(array[0], array[1].split("/"), array[2], Long.valueOf(array[3]), Strand.toStrand(array[4]), array[5], array[6], array[7], array[8], array[9], array[10], Arrays.copyOfRange(array, 11, array.length), this.headerLine);
    }

    @Override
    public boolean canDecode(String path) {
        return path.endsWith(".hapmap");
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        this.headerLine = (String)lineIterator.next();
        return this.headerLine;
    }

    @Override
    public FeatureCodecHeader readHeader(LineIterator lineIterator) throws IOException {
        String header = (String)this.readActualHeader(lineIterator);
        return new FeatureCodecHeader(header, header.length() + 1);
    }
}

