/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.classloader;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;

public class PluginManager<PluginType> {
    private static final Reflections defaultReflections;
    protected final String pluginCategory;
    protected final String pluginSuffix;
    private final SortedMap<String, Class<? extends PluginType>> pluginsByName;
    private final List<Class<? extends PluginType>> plugins;
    private final List<Class<? extends PluginType>> interfaces;

    public PluginManager(Class pluginType) {
        this(pluginType, pluginType.getSimpleName().toLowerCase(), pluginType.getSimpleName(), null);
    }

    public PluginManager(Class pluginType, List<URL> classpath) {
        this(pluginType, pluginType.getSimpleName().toLowerCase(), pluginType.getSimpleName(), classpath);
    }

    public PluginManager(Class pluginType, String pluginCategory, String pluginSuffix) {
        this(pluginType, pluginCategory, pluginSuffix, null);
    }

    public PluginManager(Class pluginType, String pluginCategory, String pluginSuffix, List<URL> classpath) {
        Reflections reflections;
        this.pluginCategory = pluginCategory;
        this.pluginSuffix = pluginSuffix;
        this.plugins = new ArrayList<Class<? extends PluginType>>();
        this.interfaces = new ArrayList<Class<? extends PluginType>>();
        if (classpath == null) {
            reflections = defaultReflections;
        } else {
            PluginManager.addClasspath(classpath);
            reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(classpath).setScanners(new Scanner[]{new SubTypesScanner()}));
        }
        Set allTypes = reflections.getSubTypesOf(pluginType);
        for (Class clazz : allTypes) {
            if (JVMUtils.isAnonymous(clazz)) continue;
            if (JVMUtils.isConcrete(clazz)) {
                this.plugins.add(clazz);
                continue;
            }
            this.interfaces.add(clazz);
        }
        this.pluginsByName = new TreeMap<String, Class<? extends PluginType>>();
        for (Class clazz : this.plugins) {
            String pluginName = this.getName(clazz);
            this.pluginsByName.put(pluginName, clazz);
        }
        this.sortPlugins(this.plugins);
        this.sortPlugins(this.interfaces);
    }

    private void sortPlugins(List<Class<? extends PluginType>> unsortedPlugins) {
        Collections.sort(unsortedPlugins, new ComparePluginsByName());
    }

    private static void addClasspath(List<URL> urls) {
        Set<URL> existing = JVMUtils.getClasspathURLs();
        for (URL url : urls) {
            if (existing.contains(url)) continue;
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)ClassLoader.getSystemClassLoader(), url);
            }
            catch (Exception e) {
                throw new ReviewedGATKException("Error adding url to the current classloader.", e);
            }
        }
    }

    public Map<String, Class<? extends PluginType>> getPluginsByName() {
        return Collections.unmodifiableMap(this.pluginsByName);
    }

    public boolean exists(String pluginName) {
        return this.pluginsByName.containsKey(pluginName);
    }

    public boolean exists(Class<? extends PluginType> plugin) {
        return this.pluginsByName.containsValue(plugin);
    }

    public List<Class<? extends PluginType>> getPlugins() {
        return this.plugins;
    }

    public List<Class<? extends PluginType>> getInterfaces() {
        return this.interfaces;
    }

    public List<Class<? extends PluginType>> getPluginsImplementing(Class<?> type) {
        ArrayList<Class<PluginType>> implementing = new ArrayList<Class<PluginType>>();
        for (Class<PluginType> plugin : this.getPlugins()) {
            if (!type.isAssignableFrom(plugin)) continue;
            implementing.add(plugin);
        }
        return implementing;
    }

    public PluginType createByName(String pluginName) {
        Class plugin = (Class)this.pluginsByName.get(pluginName);
        if (plugin == null) {
            String errorMessage = this.formatErrorMessage(this.pluginCategory, pluginName);
            throw this.createMalformedArgumentException(errorMessage);
        }
        try {
            return (PluginType)plugin.newInstance();
        }
        catch (Exception e) {
            throw new DynamicClassResolutionException(plugin, e);
        }
    }

    public PluginType createByType(Class<? extends PluginType> pluginType) {
        Logger logger = Logger.getLogger(PluginManager.class);
        logger.setLevel(Level.ERROR);
        try {
            Constructor<PluginType> noArgsConstructor = pluginType.getDeclaredConstructor(null);
            noArgsConstructor.setAccessible(true);
            return noArgsConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Couldn't initialize the plugin. Typically this is because of wrong global class variable initializations.");
            throw new DynamicClassResolutionException(pluginType, e);
        }
    }

    public List<PluginType> createAllTypes() {
        ArrayList<PluginType> instances = new ArrayList<PluginType>();
        for (Class<PluginType> c : this.getPlugins()) {
            instances.add(this.createByType(c));
        }
        return instances;
    }

    public String getName(Class pluginType) {
        String pluginName = "";
        if (pluginName.length() == 0) {
            pluginName = pluginType.getSimpleName();
            if (this.pluginSuffix != null && pluginName.endsWith(this.pluginSuffix)) {
                pluginName = pluginName.substring(0, pluginName.lastIndexOf(this.pluginSuffix));
            }
        }
        return pluginName;
    }

    protected String formatErrorMessage(String pluginCategory, String pluginName) {
        return String.format("Could not find %s with name: %s", pluginCategory, pluginName);
    }

    protected UserException createMalformedArgumentException(String errorMessage) {
        throw new UserException.CommandLineException(errorMessage);
    }

    static {
        URL cwd;
        Reflections.log = null;
        LinkedHashSet<URL> classPathUrls = new LinkedHashSet<URL>();
        try {
            cwd = new File("").getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        for (URL url : JVMUtils.getClasspathURLs()) {
            if (url.equals(cwd)) continue;
            classPathUrls.add(url);
        }
        defaultReflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(classPathUrls).setScanners(new Scanner[]{new SubTypesScanner()}));
    }

    private final class ComparePluginsByName
    implements Comparator<Class<? extends PluginType>> {
        private ComparePluginsByName() {
        }

        @Override
        public int compare(Class<? extends PluginType> aClass, Class<? extends PluginType> aClass1) {
            String pluginName1 = PluginManager.this.getName(aClass);
            String pluginName2 = PluginManager.this.getName(aClass1);
            return pluginName1.compareTo(pluginName2);
        }
    }
}

