/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.cancer;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayList;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.contexts.AlignmentContext;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMUtils;
import org.broadinstitute.gatk.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class TestingReadUtils {
    public static final AlignmentContext generateAlignmentContext(int totalReads, int targetReads, SAMFileHeader header, GenomeLocParser parser, String firstReadGroup, String secondReadGroup) {
        int i;
        ArrayList<GATKSAMRecord> reads = new ArrayList<GATKSAMRecord>();
        for (int i2 = 0; i2 < totalReads - targetReads; ++i2) {
            reads.add(TestingReadUtils.addReadGroup(ArtificialSAMUtils.createArtificialRead(header, "Read" + i2, 0, 1, 50), firstReadGroup));
        }
        byte[] bases = new byte[50];
        byte[] quals = new byte[50];
        for (i = 0; i < 50; ++i) {
            bases[i] = 84;
            quals[i] = 30;
        }
        for (i = totalReads - targetReads; i < totalReads; ++i) {
            reads.add(TestingReadUtils.addReadGroup(ArtificialSAMUtils.createArtificialRead(header, "Read" + i, 0, 1, bases, quals), secondReadGroup));
        }
        GenomeLoc loc = parser.createGenomeLoc(header.getSequenceDictionary().getSequence(0).getSequenceName(), 1, 1);
        ReadBackedPileupImpl rbp = new ReadBackedPileupImpl(loc, reads, 0);
        return new AlignmentContext(loc, rbp);
    }

    public static final GATKSAMRecord addReadGroup(GATKSAMRecord rec, String readGroupName) {
        GATKSAMReadGroupRecord rgRec = new GATKSAMReadGroupRecord(readGroupName);
        rgRec.setSample("sample");
        rec.setReadGroup(rgRec);
        return rec;
    }
}

