/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.baq;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public class BAQ {
    private static final Logger logger = Logger.getLogger(BAQ.class);
    private static final boolean DEBUG = false;
    public static final String BAQ_TAG = "BQ";
    private static double[] qual2prob = new double[256];
    public static final double DEFAULT_GOP = 40.0;
    public double cd = -1.0;
    private double ce = 0.1;
    private int cb = 7;
    private boolean includeClippedBases = false;
    private byte minBaseQual = (byte)4;
    private static final double EM = 0.33333333333;
    private static final double EI = 0.25;
    private double[][][] EPSILONS = new double[256][256][94];

    private double convertFromPhredScale(double x) {
        return Math.pow(10.0, -x / 10.0);
    }

    public byte getMinBaseQual() {
        return this.minBaseQual;
    }

    public double getGapOpenProb() {
        return this.cd;
    }

    public double getGapExtensionProb() {
        return this.ce;
    }

    public int getBandWidth() {
        return this.cb;
    }

    public BAQ() {
        this(40.0);
    }

    public BAQ(double gapOpenPenalty) {
        this.cd = this.convertFromPhredScale(gapOpenPenalty);
        this.initializeCachedData();
    }

    public BAQ(double d, double e, int b, byte minBaseQual, boolean includeClippedBases) {
        this.cd = d;
        this.ce = e;
        this.cb = b;
        this.minBaseQual = minBaseQual;
        this.includeClippedBases = includeClippedBases;
        this.initializeCachedData();
    }

    private void initializeCachedData() {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int q = 0; q <= 93; ++q) {
                    this.EPSILONS[i][j][q] = 1.0;
                }
            }
        }
        for (char b1 : "ACGTacgt".toCharArray()) {
            for (char b2 : "ACGTacgt".toCharArray()) {
                for (int q = 0; q <= 93; ++q) {
                    double e;
                    double qual = qual2prob[(int)(q < this.minBaseQual ? this.minBaseQual : q)];
                    this.EPSILONS[(byte)b1][(byte)b2][q] = e = Character.toLowerCase(b1) == Character.toLowerCase(b2) ? 1.0 - qual : qual * 0.33333333333;
                }
            }
        }
    }

    protected double calcEpsilon(byte ref, byte read, byte qualB) {
        return this.EPSILONS[ref][read][qualB];
    }

    public int hmm_glocal(byte[] ref, byte[] query, int qstart, int l_query, byte[] _iqual, int[] state, byte[] q) {
        int v01;
        int v10;
        int v11;
        int u;
        double e;
        int i;
        int k;
        double sI;
        int bw;
        if (ref == null) {
            throw new ReviewedGATKException("BUG: ref sequence is null");
        }
        if (query == null) {
            throw new ReviewedGATKException("BUG: query sequence is null");
        }
        if (_iqual == null) {
            throw new ReviewedGATKException("BUG: query quality vector is null");
        }
        if (query.length != _iqual.length) {
            throw new ReviewedGATKException("BUG: read sequence length != qual length");
        }
        if (l_query < 1) {
            throw new ReviewedGATKException("BUG: length of query sequence < 0: " + l_query);
        }
        if (qstart < 0) {
            throw new ReviewedGATKException("BUG: query sequence start < 0: " + qstart);
        }
        int l_ref = ref.length;
        int n = bw = l_ref > l_query ? l_ref : l_query;
        if (this.cb < Math.abs(l_ref - l_query)) {
            bw = Math.abs(l_ref - l_query) + 3;
        }
        if (bw > this.cb) {
            bw = this.cb;
        }
        if (bw < Math.abs(l_ref - l_query)) {
            bw = Math.abs(l_ref - l_query);
        }
        int bw2 = bw * 2 + 1;
        double[][] f = new double[l_query + 1][bw2 * 3 + 6];
        double[][] b = new double[l_query + 1][bw2 * 3 + 6];
        double[] s = new double[l_query + 2];
        double sM = sI = 1.0 / (double)(2 * l_query + 2);
        double bM = (1.0 - this.cd) / (double)l_ref;
        double bI = this.cd / (double)l_ref;
        double[] m = new double[9];
        m[0] = (1.0 - this.cd - this.cd) * (1.0 - sM);
        m[1] = m[2] = this.cd * (1.0 - sM);
        m[3] = (1.0 - this.ce) * (1.0 - sI);
        m[4] = this.ce * (1.0 - sI);
        m[5] = 0.0;
        m[6] = 1.0 - this.ce;
        m[7] = 0.0;
        m[8] = this.ce;
        s[0] = 1.0;
        f[0][BAQ.set_u((int)bw, (int)0, (int)0)] = 1.0;
        double[] fi = f[1];
        int beg = 1;
        int end = l_ref < bw + 1 ? l_ref : bw + 1;
        double sum = 0.0;
        for (k = beg; k <= end; ++k) {
            double e2 = this.calcEpsilon(ref[k - 1], query[qstart], _iqual[qstart]);
            int u2 = BAQ.set_u(bw, 1, k);
            fi[u2 + 0] = e2 * bM;
            fi[u2 + 1] = 0.25 * bI;
            sum += fi[u2] + fi[u2 + 1];
        }
        s[1] = sum;
        int _beg = BAQ.set_u(bw, 1, beg);
        int _end = BAQ.set_u(bw, 1, end);
        _end += 2;
        k = _beg;
        while (k <= _end) {
            int n2 = k++;
            fi[n2] = fi[n2] / sum;
        }
        for (i = 2; i <= l_query; ++i) {
            fi = f[i];
            double[] fi1 = f[i - 1];
            int beg2 = 1;
            int end2 = l_ref;
            byte qyi = query[qstart + i - 1];
            int x = i - bw;
            beg2 = beg2 > x ? beg2 : x;
            x = i + bw;
            end2 = end2 < x ? end2 : x;
            double sum2 = 0.0;
            for (k = beg2; k <= end2; ++k) {
                e = this.calcEpsilon(ref[k - 1], qyi, _iqual[qstart + i - 1]);
                u = BAQ.set_u(bw, i, k);
                v11 = BAQ.set_u(bw, i - 1, k - 1);
                v10 = BAQ.set_u(bw, i - 1, k);
                v01 = BAQ.set_u(bw, i, k - 1);
                fi[u + 0] = e * (m[0] * fi1[v11 + 0] + m[3] * fi1[v11 + 1] + m[6] * fi1[v11 + 2]);
                fi[u + 1] = 0.25 * (m[1] * fi1[v10 + 0] + m[4] * fi1[v10 + 1]);
                fi[u + 2] = m[2] * fi[v01 + 0] + m[8] * fi[v01 + 2];
                sum2 += fi[u] + fi[u + 1] + fi[u + 2];
            }
            s[i] = sum2;
            int _beg2 = BAQ.set_u(bw, i, beg2);
            int _end2 = BAQ.set_u(bw, i, end2);
            _end2 += 2;
            k = _beg2;
            sum2 = 1.0 / sum2;
            while (k <= _end2) {
                int n3 = k++;
                fi[n3] = fi[n3] * sum2;
            }
        }
        double sum3 = 0.0;
        for (k = 1; k <= l_ref; ++k) {
            int u3 = BAQ.set_u(bw, l_query, k);
            if (u3 < 3 || u3 >= bw2 * 3 + 3) continue;
            sum3 += f[l_query][u3 + 0] * sM + f[l_query][u3 + 1] * sI;
        }
        s[l_query + 1] = sum3;
        for (k = 1; k <= l_ref; ++k) {
            int u4 = BAQ.set_u(bw, l_query, k);
            double[] bi = b[l_query];
            if (u4 < 3 || u4 >= bw2 * 3 + 3) continue;
            bi[u4 + 0] = sM / s[l_query] / s[l_query + 1];
            bi[u4 + 1] = sI / s[l_query] / s[l_query + 1];
        }
        for (i = l_query - 1; i >= 1; --i) {
            int beg3 = 1;
            int end3 = l_ref;
            double[] bi = b[i];
            double[] bi1 = b[i + 1];
            double y = i > 1 ? 1.0 : 0.0;
            byte qyi1 = query[qstart + i];
            int x = i - bw;
            beg3 = beg3 > x ? beg3 : x;
            x = i + bw;
            for (k = end3 = end3 < x ? end3 : x; k >= beg3; --k) {
                u = BAQ.set_u(bw, i, k);
                v11 = BAQ.set_u(bw, i + 1, k + 1);
                v10 = BAQ.set_u(bw, i + 1, k);
                v01 = BAQ.set_u(bw, i, k + 1);
                e = (k >= l_ref ? 0.0 : this.calcEpsilon(ref[k], qyi1, _iqual[qstart + i])) * bi1[v11];
                bi[u + 0] = e * m[0] + 0.25 * m[1] * bi1[v10 + 1] + m[2] * bi[v01 + 2];
                bi[u + 1] = e * m[3] + 0.25 * m[4] * bi1[v10 + 1];
                bi[u + 2] = (e * m[6] + m[8] * bi[v01 + 2]) * y;
            }
            int _beg3 = BAQ.set_u(bw, i, beg3);
            int _end3 = BAQ.set_u(bw, i, end3);
            _end3 += 2;
            k = _beg3;
            y = 1.0 / s[i];
            while (k <= _end3) {
                int n4 = k++;
                bi[n4] = bi[n4] * y;
            }
        }
        int beg4 = 1;
        int end4 = l_ref < bw + 1 ? l_ref : bw + 1;
        double sum4 = 0.0;
        for (k = end4; k >= beg4; --k) {
            int u5 = BAQ.set_u(bw, 1, k);
            double e3 = this.calcEpsilon(ref[k - 1], query[qstart], _iqual[qstart]);
            if (u5 < 3 || u5 >= bw2 * 3 + 3) continue;
            sum4 += e3 * b[1][u5 + 0] * bM + 0.25 * b[1][u5 + 1] * bI;
        }
        double d = sum4 / s[0];
        b[0][BAQ.set_u((int)bw, (int)0, (int)0)] = d;
        double pb = d;
        for (i = 1; i <= l_query; ++i) {
            double sum5 = 0.0;
            double max = 0.0;
            double[] fi2 = f[i];
            double[] bi = b[i];
            int beg5 = 1;
            int end5 = l_ref;
            int max_k = -1;
            int x = i - bw;
            beg5 = beg5 > x ? beg5 : x;
            x = i + bw;
            end5 = end5 < x ? end5 : x;
            for (k = beg5; k <= end5; ++k) {
                int u6 = BAQ.set_u(bw, i, k);
                double z = fi2[u6 + 0] * bi[u6 + 0];
                sum5 += z;
                if (z > max) {
                    max = z;
                    max_k = k - 1 << 2 | 0;
                }
                z = fi2[u6 + 1] * bi[u6 + 1];
                sum5 += z;
                if (!(z > max)) continue;
                max = z;
                max_k = k - 1 << 2 | 1;
            }
            max /= sum5;
            sum5 *= s[i];
            if (state != null) {
                state[qstart + i - 1] = max_k;
            }
            if (q == null) continue;
            k = (int)(-4.343 * Math.log(1.0 - max) + 0.499);
            q[qstart + i - 1] = (byte)(k > 100 ? 99 : (k < this.minBaseQual ? (int)this.minBaseQual : k));
        }
        return 0;
    }

    public static boolean stateIsIndel(int state) {
        return (state & 3) != 0;
    }

    public static int stateAlignedPosition(int state) {
        return state >> 2;
    }

    private static int set_u(int b, int i, int k) {
        int x = i - b;
        x = x > 0 ? x : 0;
        return (k + 1 - x) * 3;
    }

    public static byte[] getBAQTag(SAMRecord read) {
        String s = read.getStringAttribute(BAQ_TAG);
        return s != null ? s.getBytes() : null;
    }

    public static String encodeBQTag(SAMRecord read, byte[] baq) {
        byte[] bqTag = new byte[baq.length];
        for (int i = 0; i < bqTag.length; ++i) {
            byte baq_i;
            int bq = read.getBaseQualities()[i] + 64;
            int tag = bq - (baq_i = baq[i]);
            if (tag < 0) {
                throw new ReviewedGATKException("BAQ tag calculation error.  BAQ value above base quality at " + read);
            }
            if (tag > 127) {
                throw new UserException.MisencodedBAM(read, "we encountered an extremely high quality score (" + read.getBaseQualities()[i] + ") with BAQ correction factor of " + baq_i);
            }
            bqTag[i] = (byte)tag;
        }
        return new String(bqTag);
    }

    public static void addBAQTag(SAMRecord read, byte[] baq) {
        read.setAttribute(BAQ_TAG, (Object)BAQ.encodeBQTag(read, baq));
    }

    public static boolean hasBAQTag(SAMRecord read) {
        return read.getStringAttribute(BAQ_TAG) != null;
    }

    public static byte[] calcBAQFromTag(SAMRecord read, boolean overwriteOriginalQuals, boolean useRawQualsIfNoBAQTag) {
        byte[] rawQuals;
        byte[] newQuals = rawQuals = read.getBaseQualities();
        byte[] baq = BAQ.getBAQTag(read);
        if (baq != null) {
            newQuals = overwriteOriginalQuals ? rawQuals : new byte[rawQuals.length];
            for (int i = 0; i < rawQuals.length; ++i) {
                byte rawQual = rawQuals[i];
                int baq_delta = baq[i] - 64;
                int newval = rawQual - baq_delta;
                if (newval < 0) {
                    throw new UserException.MalformedBAM(read, "BAQ tag error: the BAQ value is larger than the base quality");
                }
                newQuals[i] = (byte)newval;
            }
        } else if (!useRawQualsIfNoBAQTag) {
            throw new IllegalStateException("Required BAQ tag to be present, but none was on read " + read.getReadName());
        }
        return newQuals;
    }

    public static byte calcBAQFromTag(SAMRecord read, int offset, boolean useRawQualsIfNoBAQTag) {
        byte rawQual;
        byte newQual = rawQual = read.getBaseQualities()[offset];
        byte[] baq = BAQ.getBAQTag(read);
        if (baq != null) {
            int baq_delta = baq[offset] - 64;
            int newval = rawQual - baq_delta;
            if (newval < 0) {
                throw new UserException.MalformedBAM(read, "BAQ tag error: the BAQ value is larger than the base quality");
            }
            newQual = (byte)newval;
        } else if (!useRawQualsIfNoBAQTag) {
            throw new IllegalStateException("Required BAQ tag to be present, but none was on read " + read.getReadName());
        }
        return newQual;
    }

    public BAQCalculationResult calcBAQFromHMM(SAMRecord read, ReferenceSequenceFile refReader) {
        int offset = this.getBandWidth() / 2;
        long readStart = this.includeClippedBases ? (long)read.getUnclippedStart() : (long)read.getAlignmentStart();
        long start = Math.max(readStart - (long)offset - (long)ReadUtils.getFirstInsertionOffset(read), 1L);
        long stop = (this.includeClippedBases ? read.getUnclippedEnd() : read.getAlignmentEnd()) + offset + ReadUtils.getLastInsertionOffset(read);
        if (stop > (long)refReader.getSequenceDictionary().getSequence(read.getReferenceName()).getSequenceLength()) {
            return null;
        }
        ReferenceSequence refSeq = refReader.getSubsequenceAt(read.getReferenceName(), start, stop);
        return this.calcBAQFromHMM(read, refSeq.getBases(), (int)(start - readStart));
    }

    public BAQCalculationResult calcBAQFromHMM(byte[] ref, byte[] query, byte[] quals, int queryStart, int queryEnd) {
        if (queryStart < 0) {
            throw new ReviewedGATKException("BUG: queryStart < 0: " + queryStart);
        }
        if (queryEnd < 0) {
            throw new ReviewedGATKException("BUG: queryEnd < 0: " + queryEnd);
        }
        if (queryEnd < queryStart) {
            throw new ReviewedGATKException("BUG: queryStart < queryEnd : " + queryStart + " end =" + queryEnd);
        }
        BAQCalculationResult baqResult = new BAQCalculationResult(query, quals, ref);
        int queryLen = queryEnd - queryStart;
        this.hmm_glocal(baqResult.refBases, baqResult.readBases, queryStart, queryLen, baqResult.rawQuals, baqResult.state, baqResult.bq);
        return baqResult;
    }

    private final Pair<Integer, Integer> calculateQueryRange(SAMRecord read) {
        int queryStart = -1;
        int queryStop = -1;
        int readI = 0;
        block5: for (CigarElement elt : read.getCigar().getCigarElements()) {
            switch (elt.getOperator()) {
                case N: {
                    return null;
                }
                case H: 
                case P: 
                case D: {
                    continue block5;
                }
                case I: 
                case S: 
                case M: 
                case EQ: 
                case X: {
                    int prev = readI;
                    readI += elt.getLength();
                    if (!this.includeClippedBases && elt.getOperator() == CigarOperator.S) continue block5;
                    if (queryStart == -1) {
                        queryStart = prev;
                    }
                    queryStop = readI;
                    continue block5;
                }
            }
            throw new ReviewedGATKException("BUG: Unexpected CIGAR element " + elt + " in read " + read.getReadName());
        }
        if (queryStop == queryStart) {
            return null;
        }
        return new Pair<Integer, Integer>(queryStart, queryStop);
    }

    public BAQCalculationResult calcBAQFromHMM(SAMRecord read, byte[] ref, int refOffset) {
        Pair<Integer, Integer> queryRange = this.calculateQueryRange(read);
        if (queryRange == null) {
            return null;
        }
        int queryStart = queryRange.getFirst();
        int queryEnd = queryRange.getSecond();
        BAQCalculationResult baqResult = this.calcBAQFromHMM(ref, read.getReadBases(), read.getBaseQualities(), queryStart, queryEnd);
        int readI = 0;
        int refI = 0;
        block8: for (CigarElement elt : read.getCigar().getCigarElements()) {
            int l = elt.getLength();
            switch (elt.getOperator()) {
                case N: {
                    return null;
                }
                case H: 
                case P: {
                    continue block8;
                }
                case S: {
                    refI += l;
                }
                case I: {
                    int i;
                    for (i = readI; i < readI + l; ++i) {
                        baqResult.bq[i] = baqResult.rawQuals[i];
                    }
                    readI += l;
                    continue block8;
                }
                case D: {
                    refI += l;
                    continue block8;
                }
                case M: 
                case EQ: 
                case X: {
                    int i;
                    for (i = readI; i < readI + l; ++i) {
                        int expectedPos = refI - refOffset + (i - readI);
                        baqResult.bq[i] = this.capBaseByBAQ(baqResult.rawQuals[i], baqResult.bq[i], baqResult.state[i], expectedPos);
                    }
                    readI += l;
                    refI += l;
                    continue block8;
                }
            }
            throw new ReviewedGATKException("BUG: Unexpected CIGAR element " + elt + " in read " + read.getReadName());
        }
        if (readI != read.getReadLength()) {
            System.arraycopy(baqResult.rawQuals, 0, baqResult.bq, 0, baqResult.bq.length);
        }
        return baqResult;
    }

    public byte capBaseByBAQ(byte oq, byte bq, int state, int expectedPos) {
        boolean isIndel = BAQ.stateIsIndel(state);
        int pos = BAQ.stateAlignedPosition(state);
        byte b = isIndel || pos != expectedPos ? this.minBaseQual : (bq < oq ? bq : oq);
        return b;
    }

    public byte[] baqRead(SAMRecord read, ReferenceSequenceFile refReader, CalculationMode calculationType, QualityMode qmode) {
        byte[] BAQQuals;
        block7: {
            block8: {
                boolean readHasBAQTag;
                block9: {
                    BAQQuals = read.getBaseQualities();
                    if (calculationType == CalculationMode.OFF || this.excludeReadFromBAQ(read)) break block7;
                    readHasBAQTag = BAQ.hasBAQTag(read);
                    if (calculationType != CalculationMode.RECALCULATE && readHasBAQTag) break block8;
                    BAQCalculationResult hmmResult = this.calcBAQFromHMM(read, refReader);
                    if (hmmResult == null) break block9;
                    switch (qmode) {
                        case ADD_TAG: {
                            BAQ.addBAQTag(read, hmmResult.bq);
                            break block7;
                        }
                        case OVERWRITE_QUALS: {
                            System.arraycopy(hmmResult.bq, 0, read.getBaseQualities(), 0, hmmResult.bq.length);
                            break block7;
                        }
                        case DONT_MODIFY: {
                            BAQQuals = hmmResult.bq;
                            break block7;
                        }
                        default: {
                            throw new ReviewedGATKException("BUG: unexpected qmode " + (Object)((Object)qmode));
                        }
                    }
                }
                if (readHasBAQTag) {
                    read.setAttribute(BAQ_TAG, null);
                }
                break block7;
            }
            if (qmode == QualityMode.OVERWRITE_QUALS) {
                BAQ.calcBAQFromTag(read, true, false);
            }
        }
        return BAQQuals;
    }

    public boolean excludeReadFromBAQ(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getReadFailsVendorQualityCheckFlag() || read.getDuplicateReadFlag();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BAQ.qual2prob[i] = Math.pow(10.0, (double)(-i) / 10.0);
        }
    }

    public static class BAQCalculationResult {
        public byte[] refBases;
        public byte[] rawQuals;
        public byte[] readBases;
        public byte[] bq;
        public int[] state;

        public BAQCalculationResult(SAMRecord read, byte[] ref) {
            this(read.getBaseQualities(), read.getReadBases(), ref);
        }

        public BAQCalculationResult(byte[] bases, byte[] quals, byte[] ref) {
            this.rawQuals = quals;
            this.readBases = bases;
            this.bq = new byte[this.rawQuals.length];
            this.state = new int[this.rawQuals.length];
            this.refBases = ref;
        }
    }

    public static enum QualityMode {
        ADD_TAG,
        OVERWRITE_QUALS,
        DONT_MODIFY;

    }

    public static enum CalculationMode {
        OFF,
        CALCULATE_AS_NECESSARY,
        RECALCULATE;

    }
}

