/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public class Utils {
    private static final long GATK_RANDOM_SEED = 47382911L;
    private static Random randomGenerator = new Random(47382911L);
    private static final int TEXT_WARNING_WIDTH = 68;
    private static final String TEXT_WARNING_PREFIX = "* ";
    private static final String TEXT_WARNING_BORDER = Utils.dupString('*', "* ".length() + 68);
    private static final char ESCAPE_CHAR = '\u001b';
    public static final String TEXT_BLINK = "\u001b[5m";
    public static final String TEXT_RESET = "\u001b[m";
    private static Logger logger = Logger.getLogger(Utils.class);
    public static final float JAVA_DEFAULT_HASH_LOAD_FACTOR = 0.75f;

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public static void resetRandomGenerator() {
        randomGenerator.setSeed(47382911L);
    }

    public static void resetRandomGenerator(long seed) {
        randomGenerator.setSeed(seed);
    }

    public static boolean xor(boolean x, boolean y) {
        return x != y;
    }

    public static boolean invertLogic(boolean logic, boolean invert) {
        return logic ^ invert;
    }

    public static int optimumHashSize(int maxElements) {
        return (int)((float)maxElements / 0.75f) + 2;
    }

    public static boolean equals(Object lhs, Object rhs) {
        return lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
    }

    public static <T> List<T> cons(T elt, List<T> l) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.add(elt);
        if (l != null) {
            l2.addAll(l);
        }
        return l2;
    }

    public static void warnUser(String msg) {
        Utils.warnUser(logger, msg);
    }

    public static void warnUser(Logger logger, String msg) {
        for (String line : Utils.warnUserLines(msg)) {
            logger.warn(line);
        }
    }

    public static List<String> warnUserLines(String msg) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(String.format(TEXT_WARNING_BORDER, new Object[0]));
        results.add(String.format("* WARNING:", new Object[0]));
        results.add(String.format(TEXT_WARNING_PREFIX, new Object[0]));
        Utils.prettyPrintWarningMessage(results, msg);
        results.add(String.format(TEXT_WARNING_BORDER, new Object[0]));
        return results;
    }

    private static void prettyPrintWarningMessage(List<String> results, String message) {
        for (String line : message.split("\\r?\\n")) {
            StringBuilder builder = new StringBuilder(line);
            while (builder.length() > 68) {
                int space = Utils.getLastSpace(builder, 68);
                if (space <= 0) {
                    space = 68;
                }
                results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder.substring(0, space)));
                builder.delete(0, space + 1);
            }
            results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder));
        }
    }

    private static int getLastSpace(CharSequence message, int width) {
        int length = message.length();
        int stopPos = width;
        int lastSpace = -1;
        boolean inEscape = false;
        for (int currPos = 0; currPos < stopPos && currPos < length; ++currPos) {
            char c = message.charAt(currPos);
            if (c == '\u001b') {
                ++stopPos;
                inEscape = true;
                continue;
            }
            if (inEscape) {
                ++stopPos;
                if (!Character.isLetter(c)) continue;
                inEscape = false;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            lastSpace = currPos;
        }
        return lastSpace;
    }

    public static <L, R> String joinMap(String keyValueSeperator, String recordSeperator, Map<L, R> map) {
        if (map.size() < 1) {
            return null;
        }
        String[] joinedKeyValues = new String[map.size()];
        int index = 0;
        for (L key : map.keySet()) {
            joinedKeyValues[index++] = String.format("%s%s%s", key.toString(), keyValueSeperator, map.get(key).toString());
        }
        return Utils.join(recordSeperator, joinedKeyValues);
    }

    public static ArrayList<String> split(String str, String delimiter) {
        return Utils.split(str, delimiter, 10);
    }

    public static ArrayList<String> split(String str, String delimiter, int expectedNumTokens) {
        ArrayList<String> result = new ArrayList<String>(expectedNumTokens);
        int delimiterIdx = -1;
        do {
            int tokenStartIdx;
            String token = (delimiterIdx = str.indexOf(delimiter, tokenStartIdx = delimiterIdx + 1)) != -1 ? str.substring(tokenStartIdx, delimiterIdx) : str.substring(tokenStartIdx);
            result.add(token);
        } while (delimiterIdx != -1);
        return result;
    }

    public static String join(String separator, String[] strings) {
        return Utils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i = start + 1; i < end; ++i) {
            ret.append(separator);
            ret.append(strings[i]);
        }
        return ret.toString();
    }

    public static String join(String separator, int[] ints) {
        if (ints == null || ints.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(ints[0]);
        for (int i = 1; i < ints.length; ++i) {
            ret.append(separator);
            ret.append(ints[i]);
        }
        return ret.toString();
    }

    public static <T> List<T> append(List<T> left, T ... elts) {
        LinkedList<T> l = new LinkedList<T>(left);
        l.addAll(Arrays.asList(elts));
        return l;
    }

    public static String join(String separator, double[] doubles) {
        if (doubles == null || doubles.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(doubles[0]);
        for (int i = 1; i < doubles.length; ++i) {
            ret.append(separator);
            ret.append(doubles[i]);
        }
        return ret.toString();
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static List<Integer> asList(final int ... values) {
        if (values == null) {
            throw new IllegalArgumentException("the input array cannot be null");
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return values[index];
            }

            @Override
            public int size() {
                return values.length;
            }
        };
    }

    public static List<Double> asList(final double ... values) {
        if (values == null) {
            throw new IllegalArgumentException("the input array cannot be null");
        }
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return values[index];
            }

            @Override
            public int size() {
                return values.length;
            }
        };
    }

    public static <T> String join(String separator, T ... objects) {
        return Utils.join(separator, Arrays.asList(objects));
    }

    public static String dupString(String s, int nCopies) {
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException("Bad s " + s);
        }
        if (nCopies < 0) {
            throw new IllegalArgumentException("nCopies must be >= 0 but got " + nCopies);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < nCopies; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static String dupString(char c, int nCopies) {
        char[] chars = new char[nCopies];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static byte[] dupBytes(byte b, int nCopies) {
        byte[] bytes = new byte[nCopies];
        Arrays.fill(bytes, b);
        return bytes;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static String[] escapeExpressions(String args) {
        if (args.indexOf(39) != -1) {
            return Utils.escapeExpressions(args, "'");
        }
        if (args.indexOf(34) != -1) {
            return Utils.escapeExpressions(args, "\"");
        }
        return args.trim().split(" +");
    }

    private static String[] escapeExpressions(String args, String delimiter) {
        String arg;
        String[] command = new String[]{};
        String[] split = args.split(delimiter);
        for (int i = 0; i < split.length - 1; i += 2) {
            arg = split[i].trim();
            if (arg.length() > 0) {
                command = Utils.concatArrays(command, arg.split(" +"));
            }
            command = Utils.concatArrays(command, new String[]{split[i + 1]});
        }
        arg = split[split.length - 1].trim();
        if (split.length % 2 == 1 && arg.length() > 0) {
            command = Utils.concatArrays(command, arg.split(" +"));
        }
        return command;
    }

    public static String[] concatArrays(String[] A, String[] B) {
        String[] C = new String[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public static byte[] concat(byte[] ... allBytes) {
        int size = 0;
        for (byte[] bytes : allBytes) {
            size += bytes.length;
        }
        byte[] c = new byte[size];
        int offset = 0;
        for (byte[] bytes : allBytes) {
            System.arraycopy(bytes, 0, c, offset, bytes.length);
            offset += bytes.length;
        }
        return c;
    }

    public static String[] appendArray(String[] A, String ... B) {
        return Utils.concatArrays(A, B);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c) {
        return Utils.sorted(c, false);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c, boolean reverse) {
        ArrayList<T> l = new ArrayList<T>(c);
        Collections.sort(l);
        if (reverse) {
            Collections.reverse(l);
        }
        return l;
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c) {
        return Utils.sorted(c, false);
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c, boolean reverse) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        if (reverse) {
            Collections.reverse(t);
        }
        ArrayList<V> l = new ArrayList<V>();
        for (Comparable k : t) {
            l.add(c.get(k));
        }
        return l;
    }

    public static byte[] reverse(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = bases[bases.length - i - 1];
        }
        return rcbases;
    }

    public static <T> List<T> reverse(List<T> l) {
        ArrayList<T> newL = new ArrayList<T>(l);
        Collections.reverse(newL);
        return newL;
    }

    public static int[] reverse(int[] bases) {
        int[] rcbases = new int[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = bases[bases.length - i - 1];
        }
        return rcbases;
    }

    public static String reverse(String bases) {
        return new String(Utils.reverse(bases.getBytes()));
    }

    public static boolean isFlagSet(int value, int flag) {
        return (value & flag) == flag;
    }

    public static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return "unresolvable";
        }
    }

    public static byte[] arrayFromArrayWithLength(byte[] array, int length) {
        byte[] output = new byte[length];
        for (int j = 0; j < length; ++j) {
            output[j] = array[j % array.length];
        }
        return output;
    }

    public static void fillArrayWithByte(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(Collection<T>[] options) {
        int nStates = 1;
        for (Collection<T> states : options) {
            nStates *= states.size();
        }
        return nStates;
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(List<List<T>> options) {
        if (options.isEmpty()) {
            return 0;
        }
        int nStates = 1;
        for (Collection collection : options) {
            nStates *= collection.size();
        }
        return nStates;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block4: {
            block3: {
                combinations = new ArrayList<List<T>>();
                if (n != 1) break block3;
                for (T o : objects) {
                    combinations.add(Collections.singletonList(o));
                }
                break block4;
            }
            if (n <= 1) break block4;
            List<List<T>> sub = Utils.makePermutations(objects, n - 1, withReplacement);
            for (List<T> subI : sub) {
                for (T a : objects) {
                    if (!withReplacement && subI.contains(a)) continue;
                    combinations.add(Utils.cons(a, subI));
                }
            }
        }
        return combinations;
    }

    public static String formattedNoveltyRate(int known, int all) {
        return Utils.formattedPercent(all - known, all);
    }

    public static String formattedPercent(long x, long total) {
        return total == 0L ? "NA" : String.format("%.2f", 100.0 * (double)x / (double)total);
    }

    public static String formattedRatio(long num, long denom) {
        return denom == 0L ? "NA" : String.format("%.2f", (double)num / (1.0 * (double)denom));
    }

    public static <T> boolean addAll(Collection<T> dest, T ... elements) {
        boolean result = false;
        for (T e : elements) {
            result = dest.add(e) | result;
        }
        return result;
    }

    public static <T> Map<T, T> makeIdentityFunctionMap(Collection<T> values) {
        HashMap<T, T> map = new HashMap<T, T>(values.size());
        for (T value : values) {
            map.put(value, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<List<T>> groupList(List<T> list, int groupSize) {
        if (groupSize < 1) {
            throw new IllegalArgumentException("groupSize >= 1");
        }
        LinkedList<List<T>> subLists = new LinkedList<List<T>>();
        int n = list.size();
        for (int i = 0; i < n; i += groupSize) {
            subLists.add(list.subList(i, Math.min(i + groupSize, n)));
        }
        return subLists;
    }

    public static String calcMD5(String s) {
        return Utils.calcMD5(s.getBytes());
    }

    @Ensures(value={"result != null", "result.length() == 32"})
    public static String calcMD5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        try {
            byte[] thedigest = MessageDigest.getInstance("MD5").digest(bytes);
            BigInteger bigInt = new BigInteger(1, thedigest);
            String md5String = bigInt.toString(16);
            while (md5String.length() < 32) {
                md5String = "0" + md5String;
            }
            return md5String;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 digest algorithm not present");
        }
    }

    public static boolean endsWith(byte[] big, byte[] suffix) {
        if (big == null) {
            throw new IllegalArgumentException("big cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("suffix cannot be null");
        }
        return new String(big).endsWith(new String(suffix));
    }

    public static int longestCommonPrefix(byte[] seq1, byte[] seq2, int maxLength) {
        if (seq1 == null) {
            throw new IllegalArgumentException("seq1 is null");
        }
        if (seq2 == null) {
            throw new IllegalArgumentException("seq2 is null");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0 " + maxLength);
        }
        int end = Math.min(seq1.length, Math.min(seq2.length, maxLength));
        for (int i = 0; i < end; ++i) {
            if (seq1[i] == seq2[i]) continue;
            return i;
        }
        return end;
    }

    public static int longestCommonSuffix(byte[] seq1, byte[] seq2, int maxLength) {
        if (seq1 == null) {
            throw new IllegalArgumentException("seq1 is null");
        }
        if (seq2 == null) {
            throw new IllegalArgumentException("seq2 is null");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0 " + maxLength);
        }
        int end = Math.min(seq1.length, Math.min(seq2.length, maxLength));
        for (int i = 0; i < end; ++i) {
            if (seq1[seq1.length - i - 1] == seq2[seq2.length - i - 1]) continue;
            return i;
        }
        return end;
    }

    public static byte[] trimArray(byte[] seq, int trimFromFront, int trimFromBack) {
        if (trimFromFront + trimFromBack > seq.length) {
            throw new IllegalArgumentException("trimming total is larger than the original array");
        }
        return trimFromFront == 0 && trimFromBack == 0 ? seq : Arrays.copyOfRange(seq, trimFromFront, seq.length - trimFromBack);
    }

    public static List<Integer> listFromPrimitives(int[] ar) {
        ArrayList<Integer> lst = new ArrayList<Integer>(ar.length);
        for (int d : ar) {
            lst.add(d);
        }
        return lst;
    }

    public static boolean equalRange(byte[] left, int leftOffset, byte[] right, int rightOffset, int length) {
        if (left == null) {
            throw new IllegalArgumentException("left cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right cannot be null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("the length cannot be negative");
        }
        if (leftOffset < 0) {
            throw new IllegalArgumentException("left offset cannot be negative");
        }
        if (leftOffset + length > left.length) {
            throw new IllegalArgumentException("length goes beyond end of left array");
        }
        if (rightOffset < 0) {
            throw new IllegalArgumentException("right offset cannot be negative");
        }
        if (rightOffset + length > right.length) {
            throw new IllegalArgumentException("length goes beyond end of right array");
        }
        for (int i = 0; i < length; ++i) {
            if (left[leftOffset + i] == right[rightOffset + i]) continue;
            return false;
        }
        return true;
    }

    public static <T> T skimArray(T original, boolean[] remove) {
        return Utils.skimArray(original, 0, null, 0, remove, 0);
    }

    public static <T> T skimArray(T source, int sourceOffset, T dest, int destOffset, boolean[] remove, int removeOffset) {
        if (source == null) {
            throw new IllegalArgumentException("the source array cannot be null");
        }
        Class<?> sourceClazz = source.getClass();
        if (!sourceClazz.isArray()) {
            throw new IllegalArgumentException("the source array is not in fact an array instance");
        }
        int length = Array.getLength(source) - sourceOffset;
        if (length < 0) {
            throw new IllegalArgumentException("the source offset goes beyond the source array length");
        }
        return Utils.skimArray(source, sourceOffset, dest, destOffset, remove, removeOffset, length);
    }

    public static <T> T skimArray(T source, int sourceOffset, T dest, int destOffset, boolean[] remove, int removeOffset, int length) {
        if (source == null) {
            throw new IllegalArgumentException("the source array cannot be null");
        }
        if (remove == null) {
            throw new IllegalArgumentException("the remove array cannot be null");
        }
        if (sourceOffset < 0) {
            throw new IllegalArgumentException("the source array offset cannot be negative");
        }
        if (destOffset < 0) {
            throw new IllegalArgumentException("the destination array offset cannot be negative");
        }
        if (removeOffset < 0) {
            throw new IllegalArgumentException("the remove array offset cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("the length provided cannot be negative");
        }
        int removeLength = Math.min(remove.length - removeOffset, length);
        if (removeLength < 0) {
            throw new IllegalArgumentException("the remove offset provided falls beyond the remove array end");
        }
        Class<?> sourceClazz = source.getClass();
        if (!sourceClazz.isArray()) {
            throw new IllegalArgumentException("the source array is not in fact an array instance");
        }
        Class<T> destClazz = Utils.skimArrayDetermineDestArrayClass(dest, sourceClazz);
        int sourceLength = Array.getLength(source);
        if (sourceLength < length + sourceOffset) {
            throw new IllegalArgumentException("the source array is too small considering length and offset");
        }
        int removeCount = 0;
        int removeEnd = removeLength + removeOffset;
        for (int i = removeOffset; i < removeEnd; ++i) {
            if (!remove[i]) continue;
            ++removeCount;
        }
        int newLength = length - removeCount;
        T result = Utils.skimArrayBuildResultArray(dest, destOffset, destClazz, newLength);
        if (removeCount == 0) {
            System.arraycopy(source, sourceOffset, result, destOffset, length);
        } else if (length > 0) {
            int copyLength;
            int nextOriginalIndex = 0;
            int nextRemoveIndex = removeOffset;
            for (int nextNewIndex = 0; nextOriginalIndex < length && nextNewIndex < newLength; nextNewIndex += copyLength) {
                while (nextRemoveIndex < removeEnd && remove[nextRemoveIndex++]) {
                    ++nextOriginalIndex;
                }
                int copyStart = nextOriginalIndex;
                while (!(++nextOriginalIndex >= length || nextRemoveIndex < removeEnd && remove[nextRemoveIndex])) {
                    ++nextRemoveIndex;
                }
                int copyEnd = nextOriginalIndex;
                copyLength = copyEnd - copyStart;
                System.arraycopy(source, sourceOffset + copyStart, result, destOffset + nextNewIndex, copyLength);
            }
        }
        return result;
    }

    private static <T> T skimArrayBuildResultArray(T dest, int destOffset, Class<T> destClazz, int newLength) {
        Object result;
        if (dest == null) {
            result = Array.newInstance(destClazz.getComponentType(), newLength + destOffset);
        } else if (Array.getLength(dest) < newLength + destOffset) {
            result = Array.newInstance(destClazz.getComponentType(), newLength + destOffset);
            if (destOffset > 0) {
                System.arraycopy(dest, 0, result, 0, destOffset);
            }
        } else {
            result = dest;
        }
        return (T)result;
    }

    private static <T> Class<T> skimArrayDetermineDestArrayClass(T dest, Class<T> sourceClazz) {
        Class<Object> destClazz;
        if (dest == null) {
            destClazz = sourceClazz;
        } else {
            destClazz = dest.getClass();
            if (destClazz != sourceClazz) {
                if (!destClazz.isArray()) {
                    throw new IllegalArgumentException("the destination array class must be an array");
                }
                if (sourceClazz.getComponentType().isAssignableFrom(destClazz.getComponentType())) {
                    throw new IllegalArgumentException("the provided destination array class cannot contain values from the source due to type incompatibility");
                }
            }
        }
        return destClazz;
    }

    public static <T> T deepCloneArray(T array) {
        if (array == null) {
            throw new IllegalArgumentException("");
        }
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("the input is not an array");
        }
        int dimension = Utils.calculateArrayDimensions(clazz);
        return Utils.deepCloneArrayUnchecked(array, clazz, dimension);
    }

    private static int calculateArrayDimensions(Class<?> clazz) {
        if (clazz.isArray()) {
            return Utils.calculateArrayDimensions(clazz.getComponentType()) + 1;
        }
        return 0;
    }

    private static <T> T deepCloneArrayUnchecked(T array, Class<T> clazz, int dimension) {
        int length = Array.getLength(array);
        Class<?> componentClass = clazz.getComponentType();
        Object result = Array.newInstance(componentClass, length);
        if (dimension <= 1) {
            System.arraycopy(array, 0, result, 0, length);
            return (T)result;
        }
        int dimensionMinus1 = dimension - 1;
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, Utils.deepCloneArrayUnchecked(Array.get(array, i), componentClass, dimensionMinus1));
        }
        return (T)result;
    }

    public static <T> T nonNull(T object) {
        return Utils.nonNull(object, "Null object is not allowed here.");
    }

    public static <T> T nonNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T> T nonNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalArgumentException(message.get());
        }
        return object;
    }

    public static void validateArg(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateArg(boolean condition, Supplier<String> msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg.get());
        }
    }
}

