/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class PathUtils {
    private static Logger logger = Logger.getLogger(PathUtils.class);

    private PathUtils() {
    }

    public static List<String> findFilesInPath(File basePath, String relativePrefix, String extension, boolean recursive) {
        File[] contents;
        ArrayList<String> filesInPath = new ArrayList<String>();
        OrFilenameFilter filter = new OrFilenameFilter(new DirectoryFilter(), new ExtensionFilter(extension));
        for (File content : contents = basePath.listFiles(filter)) {
            String relativeFileName;
            String string = relativeFileName = relativePrefix.trim().length() != 0 ? relativePrefix + File.separator + content.getName() : content.getName();
            if (relativeFileName.endsWith(extension)) {
                filesInPath.add(relativeFileName);
                continue;
            }
            if (!content.isDirectory() || !recursive) continue;
            filesInPath.addAll(PathUtils.findFilesInPath(content, relativeFileName, extension, recursive));
        }
        return filesInPath;
    }

    public static void refreshVolume(File file) {
        File dir = file.isDirectory() ? file : file.getParentFile();
        for (int sleepCount = 0; sleepCount < 3 && dir.listFiles() == null; ++sleepCount) {
            try {
                Thread.sleep((sleepCount + 1) * 3000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (dir.listFiles() == null) {
            throw new ReviewedGATKException("The volume '" + dir.getAbsolutePath() + "' could not be accessed.");
        }
    }

    public static File findMostRecentGATKVersion(File gatkReleaseDir, String releaseVersionNumber) {
        String versionString = "GenomeAnalysisTK-" + releaseVersionNumber;
        ArrayList<File> gatkJars = new ArrayList<File>();
        for (String path : gatkReleaseDir.list(new isGATKVersion(versionString))) {
            gatkJars.add(new File(gatkReleaseDir.getAbsolutePath() + "/" + path + "/GenomeAnalysisTK.jar"));
        }
        if (gatkJars.isEmpty()) {
            return null;
        }
        Collections.sort(gatkJars, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        File last = (File)gatkJars.get(0);
        logger.debug(String.format("findMostRecentGATKVersion: Found %d jars for %s, keeping last one %s", gatkJars.size(), releaseVersionNumber, last));
        return last;
    }

    private static final class isGATKVersion
    implements FilenameFilter {
        private final String versionString;

        private isGATKVersion(String versionString) {
            this.versionString = versionString;
        }

        @Override
        public boolean accept(File file, String s) {
            return s.contains(this.versionString);
        }
    }

    public static class OrFilenameFilter
    implements FilenameFilter {
        private FilenameFilter lhs = null;
        private FilenameFilter rhs = null;

        public OrFilenameFilter(FilenameFilter lhs, FilenameFilter rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean accept(File f, String s) {
            return this.lhs.accept(f, s) || this.rhs.accept(f, s);
        }
    }

    public static class DirectoryFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File f, String s) {
            return new File(f, s).isDirectory();
        }
    }

    public static class ExtensionFilter
    implements FilenameFilter {
        private String extensionName = null;

        public ExtensionFilter(String extensionName) {
            this.extensionName = extensionName;
        }

        @Override
        public boolean accept(File f, String s) {
            return s.endsWith("." + this.extensionName);
        }
    }
}

