/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.util.Collections;
import org.apache.commons.math3.special.Gamma;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.Utils;

public class Dirichlet {
    final double[] alpha;

    public Dirichlet(double ... alpha) {
        Utils.nonNull(alpha);
        Utils.validateArg(alpha.length >= 1, "Dirichlet parameters must have at least one element");
        Utils.validateArg(MathUtils.allMatch(alpha, x -> x >= 0.0), "Dirichlet parameters may not be negative");
        Utils.validateArg(MathUtils.allMatch(alpha, Double::isFinite), "Dirichlet parameters must be finite");
        this.alpha = (double[])alpha.clone();
    }

    public static Dirichlet symmetricDirichlet(int numStates, double concentration) {
        Utils.validateArg(numStates > 0, "Must have at leat one state");
        Utils.validateArg(concentration > 0.0, "concentration must be positive");
        return new Dirichlet(Collections.nCopies(numStates, concentration / (double)numStates).stream().mapToDouble(x -> x).toArray());
    }

    public double[] effectiveMultinomialWeights() {
        double digammaOfSum = Gamma.digamma(MathUtils.sum(this.alpha));
        return MathUtils.applyToArray(this.alpha, a -> Math.exp(Gamma.digamma(a) - digammaOfSum));
    }

    public double[] effectiveLog10MultinomialWeights() {
        double digammaOfSum = Gamma.digamma(MathUtils.sum(this.alpha));
        return MathUtils.applyToArray(this.alpha, a -> (Gamma.digamma(a) - digammaOfSum) * MathUtils.LOG10_OF_E);
    }

    public double[] meanWeights() {
        double sum = MathUtils.sum(this.alpha);
        return MathUtils.applyToArray(this.alpha, x -> x / sum);
    }

    public double[] log10MeanWeights() {
        double sum = MathUtils.sum(this.alpha);
        return MathUtils.applyToArray(this.alpha, x -> Math.log10(x / sum));
    }

    public int size() {
        return this.alpha.length;
    }
}

