/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.rows;

import java.io.IOException;
import lukfor.tables.Table;
import lukfor.tables.columns.types.DoubleColumn;

public class Row {
    private Table table;
    private int index;

    public Row(Table table, int index) {
        this.table = table;
        this.index = index;
    }

    public void updateView(Table table, int index) {
        this.table = table;
        this.index = index;
    }

    public void fill(Row row) throws IOException {
        String[] stringArray = row.table.getColumns().getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            this.set(column, row.getObject(column));
            ++n2;
        }
    }

    public Object getObject(String column) throws IOException {
        return this.table.get(this.index, column);
    }

    public String getString(String column) throws IOException {
        return (String)this.getObject(column);
    }

    public int getInteger(String column) throws IOException {
        return (Integer)this.getObject(column);
    }

    public double getDouble(String column) throws IOException {
        return (Double)this.getObject(column);
    }

    public Object getObject(int column) throws IOException {
        return this.table.get(this.index, column);
    }

    public String getString(int column) throws IOException {
        return (String)this.getObject(column);
    }

    public int getInteger(int column) throws IOException {
        return (Integer)this.getObject(column);
    }

    public double getDouble(int column) throws IOException {
        return (Double)this.getObject(column);
    }

    public void set(String column, Object value) {
        this.table.getColumn(column).set(this.index, value);
    }

    public void set(int column, Object value) {
        this.table.getColumn(column).set(this.index, value);
    }

    public void setString(String column, Object value) {
        if (value != null) {
            if (value instanceof Double) {
                value = DoubleColumn.FORMAT.format(value);
            }
            this.table.getColumn(column).set(this.index, value.toString());
        } else {
            this.table.getColumn(column).set(this.index, null);
        }
    }

    public boolean hasMissings() {
        int i = 0;
        while (i < this.table.getColumns().getSize()) {
            if (this.table.get(this.index, i) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getHashCode() {
        int result = 1;
        int i = 0;
        while (i < this.table.getColumns().getSize()) {
            Object element = this.table.get(this.index, i);
            result = 31 * result + (element == null ? 0 : element.hashCode());
            ++i;
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }
}

