/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.ColumnFactory;
import lukfor.tables.columns.ColumnType;
import lukfor.tables.columns.IBuildValueFunction;
import lukfor.tables.columns.filters.ColumnNameFilter;
import lukfor.tables.columns.filters.ColumnNameRegExFilter;
import lukfor.tables.columns.filters.IColumnFilter;
import lukfor.tables.rows.IRowProcessor;
import lukfor.tables.rows.Row;

public class ColumnOperations {
    private Table table;
    private List<AbstractColumn> columns = new Vector<AbstractColumn>();
    private Map<String, AbstractColumn> columnsIndex = new HashMap<String, AbstractColumn>();

    public ColumnOperations(Table table) {
        this.table = table;
        this.columns = table.storage;
        for (AbstractColumn column : this.columns) {
            this.columnsIndex.put(column.getName(), column);
        }
    }

    public AbstractColumn get(String name) {
        AbstractColumn column = this.columnsIndex.get(name);
        if (column != null) {
            return column;
        }
        throw new RuntimeException("Column '" + name + "' not found.");
    }

    public AbstractColumn get(int index) {
        if (index >= 0 && index < this.columns.size()) {
            return this.columns.get(index);
        }
        throw new RuntimeException("Column index " + index + " is out of bounds.");
    }

    public void rename(String oldName, String newName) throws IOException {
        this.table.assertsColumnExists(oldName);
        if (this.columnsIndex.get(newName) != null) {
            throw new IOException("Duplicate column '" + newName + ".");
        }
        AbstractColumn column = this.get(oldName);
        column.setName(newName);
        this.columnsIndex.remove(oldName);
        this.columnsIndex.put(newName, column);
    }

    public AbstractColumn append(AbstractColumn column) throws IOException {
        this.append(column, new IBuildValueFunction(){

            @Override
            public Object buildValue(Row row) throws IOException {
                return null;
            }
        });
        return column;
    }

    public AbstractColumn append(final AbstractColumn column, final IBuildValueFunction builder) throws IOException {
        if (this.columnsIndex.get(column.getName()) != null) {
            throw new IOException("Duplicate column '" + column + ".");
        }
        this.columns.add(column);
        this.columnsIndex.put(column.getName(), column);
        if (builder != null) {
            this.table.forEachRow(new IRowProcessor(){

                @Override
                public void process(Row row) throws IOException {
                    Object value = builder.buildValue(row);
                    if (value != null && !column.accepts(value)) {
                        throw new IOException("Wrong class: " + value.getClass());
                    }
                    column.add(value);
                }
            });
        }
        return column;
    }

    public void setType(String column, ColumnType type) throws IOException {
        this.table.assertsColumnExists(column);
        AbstractColumn oldColumn = this.get(column);
        this.setType(oldColumn, type);
    }

    public void setType(AbstractColumn column, ColumnType type) throws IOException {
        AbstractColumn newColumn = ColumnFactory.createColumn(column.getName(), type);
        newColumn.copyDataFrom(column);
        int index = this.columns.indexOf(column);
        this.columns.set(index, newColumn);
        this.columnsIndex.put(column.getName(), newColumn);
    }

    public String[] getNames() {
        String[] names = new String[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            names[i] = this.columns.get(i).getName();
            ++i;
        }
        return names;
    }

    public String[] getTypes() {
        String[] types = new String[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            types[i] = this.columns.get(i).getType().toString();
            ++i;
        }
        return types;
    }

    public void drop(String ... names) throws IOException {
        this.drop(new ColumnNameFilter(names));
    }

    public void dropByRegEx(String regex) throws IOException {
        ColumnNameRegExFilter filter = new ColumnNameRegExFilter(regex);
        this.drop(filter);
    }

    public void drop(IColumnFilter filter) throws IOException {
        Vector<AbstractColumn> removedColumns = new Vector<AbstractColumn>();
        for (AbstractColumn column : this.columns) {
            if (!filter.accepts(column)) continue;
            removedColumns.add(column);
        }
        this.columns.removeAll(removedColumns);
        for (AbstractColumn removedColumn : removedColumns) {
            this.columnsIndex.remove(removedColumn.getName());
        }
    }

    public void select(String ... names) throws IOException {
        this.select(new ColumnNameFilter(names));
    }

    public void selectByRegEx(String regex) throws IOException {
        this.select(new ColumnNameRegExFilter(regex));
    }

    public void select(IColumnFilter filter) throws IOException {
        Vector<AbstractColumn> removedColumns = new Vector<AbstractColumn>();
        for (AbstractColumn column : this.columns) {
            if (filter.accepts(column)) continue;
            removedColumns.add(column);
        }
        this.columns.removeAll(removedColumns);
        for (AbstractColumn removedColumn : removedColumns) {
            this.columnsIndex.remove(removedColumn.getName());
        }
    }

    public int getSize() {
        return this.columns.size();
    }

    public void clear() {
        this.columns.clear();
        this.columnsIndex.clear();
    }
}

