/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.tasks;

import java.util.concurrent.Callable;
import lukfor.progress.renderer.IProgressRenderer;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.TaskStatus;
import lukfor.progress.tasks.monitors.TaskMonitor;

public class Task
implements Callable<TaskStatus> {
    private IProgressRenderer renderer;
    private ITaskRunnable task;
    private TaskStatus status;
    private TaskMonitor monitor;

    public Task(ITaskRunnable task, IProgressRenderer renderer) {
        this.task = task;
        this.status = new TaskStatus(task);
        this.monitor = new TaskMonitor();
        this.renderer = renderer;
        this.renderer.addTaskMonitor(this.monitor);
    }

    @Override
    public TaskStatus call() throws InterruptedException {
        this.status = new TaskStatus(this.task);
        if (this.monitor.isCanceled()) {
            this.status.setDone(true);
            this.status.setSuccess(false);
            return this.status;
        }
        try {
            this.monitor.start();
            this.task.run(this.monitor);
            if (!this.monitor.isDone()) {
                this.monitor.done();
            }
            this.status.setDone(true);
            this.status.setSuccess(true);
        }
        catch (Exception e) {
            if (!this.monitor.isDone()) {
                this.monitor.failed(e);
            }
            this.status.setDone(true);
            this.status.setSuccess(false);
            this.status.setThrowable(e);
        }
        return this.status;
    }

    public IProgressRenderer getRenderer() {
        return this.renderer;
    }

    public TaskStatus getStatus() {
        return this.status;
    }
}

