/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.renderer.labels;

import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.monitors.TaskMonitor;

public class UnitLabel
implements IProgressIndicator {
    private String unit;
    private float factor;
    public static String FORMAT = " %.2f %s/%.2f %s";
    public static String FORMAT_UNKNOWN = " %.2f %s";
    public static UnitLabel FILE_SIZE_GB = new UnitLabel("GB", 1.0737418E9f);
    public static UnitLabel FILE_SIZE_MB = new UnitLabel("MB", 1048576.0f);
    public static UnitLabel FILE_SIZE_KB = new UnitLabel("KB", 1024.0f);

    public UnitLabel(String unit, float factor) {
        this.unit = unit;
        this.factor = factor;
    }

    @Override
    public void render(TaskMonitor monitor, StringBuilder buffer) {
        float worked = (float)monitor.getWorked() / this.factor;
        if (monitor.getTotal() != -1L) {
            float total = (float)monitor.getTotal() / this.factor;
            String label = String.format(FORMAT, Float.valueOf(worked), this.unit, Float.valueOf(total), this.unit);
            buffer.append(label);
        } else {
            String label = String.format(FORMAT_UNKNOWN, Float.valueOf(worked), this.unit);
            buffer.append(label);
        }
    }
}

