/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.renderer;

import lukfor.progress.renderer.AbstractProgressRenderer;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.monitors.TaskMonitor;

public class AnimatedProgressRenderer
extends AbstractProgressRenderer {
    private int lines = 0;
    public static final String ANSI_CSI = "\u001b[";

    @Override
    public synchronized void begin(TaskMonitor monitor) {
    }

    @Override
    public synchronized void render() {
        StringBuilder content = this.buildAnsiString();
        String string = content.toString();
        if (this.lines > 0) {
            this.target.print(ANSI_CSI + this.lines + "A");
        }
        this.target.print("\r");
        this.target.println(string);
        this.lines = AnimatedProgressRenderer.countLines(string);
    }

    @Override
    public synchronized void finish(TaskMonitor monitor) {
        super.finish(monitor);
        this.render();
    }

    public StringBuilder buildAnsiString() {
        StringBuilder buffer = new StringBuilder();
        for (TaskMonitor monitor : this.monitors) {
            if (!monitor.isRunning() && !monitor.isDone()) continue;
            if (monitor != this.monitors.get(0)) {
                buffer.append("\n");
            }
            if (this.components == null || this.components.length <= 0) continue;
            for (IProgressIndicator component : this.components) {
                if (component == null) continue;
                component.render(monitor, buffer);
            }
        }
        return buffer;
    }

    private static int countLines(String str) {
        String[] lines = str.split("\r\n|\r|\n");
        return lines.length;
    }
}

