/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.renderer;

import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.renderer.IProgressRenderer;
import lukfor.progress.renderer.bars.DefaultProgressBar;
import lukfor.progress.renderer.labels.DefaultLabel;
import lukfor.progress.renderer.labels.TimeLabel;
import lukfor.progress.tasks.TaskFailureStrategy;
import lukfor.progress.tasks.monitors.TaskMonitor;

public abstract class AbstractProgressRenderer
implements IProgressRenderer {
    protected List<TaskMonitor> monitors = new Vector<TaskMonitor>();
    protected PrintStream target = System.out;
    protected TaskFailureStrategy taskFailureStrategy;
    protected IProgressIndicator[] components = new IProgressIndicator[]{new TimeLabel(), new DefaultProgressBar(), new DefaultLabel()};

    @Override
    public void setTarget(PrintStream target) {
        this.target = target;
    }

    public PrintStream getTarget() {
        return this.target;
    }

    @Override
    public void setTaskFailureStrategy(TaskFailureStrategy taskFailureStrategy) {
        this.taskFailureStrategy = taskFailureStrategy;
    }

    @Override
    public void addTaskMonitor(TaskMonitor monitor) {
        this.monitors.add(monitor);
        monitor.setRenderer(this);
    }

    public List<TaskMonitor> getTaskMonitors() {
        return this.monitors;
    }

    public void setComponents(IProgressIndicator ... components) {
        this.components = components;
    }

    public IProgressIndicator[] getComponents() {
        return this.components;
    }

    @Override
    public boolean isRunning() {
        for (TaskMonitor monitor : this.monitors) {
            if (monitor.isDone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finish(TaskMonitor monitor) {
        if (!monitor.isSuccess() && !monitor.isCanceled() && this.taskFailureStrategy == TaskFailureStrategy.CANCEL_TASKS) {
            for (TaskMonitor _monitor : this.monitors) {
                if (monitor == _monitor) continue;
                _monitor.setCanceled(true);
            }
        }
    }
}

