/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.executors;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lukfor.progress.executors.ITaskExecutor;
import lukfor.progress.tasks.Task;

public class DefaultTaskExecutor
implements ITaskExecutor {
    public static final int DEFAULT_THREADS = 1;
    private int threads = 1;
    private ExecutorService executor;

    public DefaultTaskExecutor() {
        this(1);
    }

    public DefaultTaskExecutor(int threads) {
        this.threads = threads;
    }

    @Override
    public void setThreads(int threads) {
        this.threads = threads;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public void waitForAll() {
    }

    @Override
    public void run(Task ... tasks) {
        Vector<Task> taskList = new Vector<Task>();
        for (Task task : tasks) {
            taskList.add(task);
        }
        this.run(taskList);
    }

    @Override
    public void run(List<? extends Task> tasks) {
        this.executor = Executors.newFixedThreadPool(this.threads);
        List results = null;
        try {
            results = this.executor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            System.out.println("OKOK");
            e.printStackTrace();
        }
        this.executor.shutdown();
    }
}

