/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.validate;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.common.WorkflowContext;
import genepi.hadoop.common.WorkflowStep;
import genepi.hadoop.importer.IImporter;
import genepi.hadoop.importer.ImporterFactory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.fastq.FastqReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class InputValidation
extends WorkflowStep {
    protected static final Log log = LogFactory.getLog(InputValidation.class);
    StringBuffer text = new StringBuffer();
    int amountBams;
    int amountSE;
    int amountPE;
    String msgType;
    String msgType1;
    int amountFiles = 0;
    Set<String> platforms = new HashSet<String>();

    @Override
    public boolean run(WorkflowContext context) {
        String type = context.get("inType");
        String input = context.get("input");
        String source = context.get("submissionSource");
        context.incCounter("jobs.submission." + source, 1);
        context.submitCounter("jobs.submission." + source);
        if (!this.importFiles(context)) {
            context.endTask("Upload failed ", 1);
            return false;
        }
        context.beginTask("Analyze files ");
        input = context.get("input");
        int fileSize = Integer.valueOf(context.get("fileSize"));
        if (this.calcFileSize(input) > (long)fileSize) {
            context.endTask("Please contact sebastian.schoenherr@i-med.ac.at to discuss this large analysis.", 1);
            return false;
        }
        String detectedType = this.inputDectection(input);
        switch (type) {
            case "se": {
                this.msgType = "single-end file(s)";
                break;
            }
            case "pe": {
                this.msgType = "paired-end file(s)";
                break;
            }
            case "bam": {
                this.msgType = "BAM file(s)";
            }
        }
        switch (detectedType) {
            case "se": {
                this.msgType1 = "single-end file(s)";
                break;
            }
            case "pe": {
                this.msgType1 = "paired-end file(s)";
                break;
            }
            case "bam": {
                this.msgType1 = "BAM file(s)";
                break;
            }
            default: {
                this.msgType1 = "Unsupported";
            }
        }
        if (!type.equals(detectedType)) {
            context.endTask("Please check your input data type. You selected " + this.msgType + " but mtDNA-Server detected:" + this.msgType1, 1);
            return false;
        }
        switch (detectedType) {
            case "se": {
                context.incCounter("FASTQ_SE", this.amountSE);
                this.amountFiles = this.amountSE;
                break;
            }
            case "pe": {
                context.incCounter("FASTQ_PE", this.amountPE);
                this.amountFiles = this.amountPE;
                break;
            }
            case "bam": {
                context.incCounter("BAM", this.amountBams);
                this.amountFiles = this.amountBams;
            }
        }
        if (this.amountFiles == 0) {
            context.endTask("No files to process!", 1);
            return false;
        }
        if (this.amountFiles > 100) {
            context.endTask("Please contact sebastian.schoenherr@i-med.ac.at to discuss this large analysis.", 1);
            return false;
        }
        StringBuffer text = new StringBuffer();
        text.append("Validation succeeded! <br>");
        text.append("<b>Parameters:</b> <br>");
        text.append("Detected file type: " + this.msgType + "<br>");
        if (this.platforms.size() > 0) {
            text.append("Detected platforms: " + this.platforms + "<br>");
        }
        text.append("Amount files: " + this.amountFiles + "<br>");
        context.endTask(text.toString(), 0);
        return true;
    }

    private long calcFileSize(String folder) {
        try {
            FileStatus[] fileList;
            long size = 0L;
            FileSystem fileSystem = FileSystem.get((Configuration)HdfsUtil.getConfiguration());
            FileStatus[] fileStatusArray = fileList = fileSystem.listStatus(new Path(folder));
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                size += file.getLen();
                ++n2;
            }
            return size / 1024L / 1024L;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return -1L;
        }
    }

    private String inputDectection(String input) {
        String outType = "unsupported file format";
        this.amountBams = 0;
        this.amountSE = 0;
        this.amountPE = 0;
        int invalid = 0;
        FileStatus[] fileList = null;
        FileSystem fileSystem = null;
        HashMap<String, List<String>> mapPairs = new HashMap<String, List<String>>();
        try {
            fileSystem = FileSystem.get((Configuration)HdfsUtil.getConfiguration());
            fileList = fileSystem.listStatus(new Path(input));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        FileStatus[] fileStatusArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus file = fileStatusArray[n2];
            System.out.println("file is " + file.getPath());
            try {
                FSDataInputStream in = fileSystem.open(file.getPath());
                SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)in));
                SAMFileHeader header = reader.getFileHeader();
                ++this.amountBams;
                in.close();
                reader.close();
            }
            catch (Exception e) {
                try {
                    FSDataInputStream in = fileSystem.open(file.getPath());
                    if (file.getPath().getName().endsWith(".gz")) {
                        GZIPInputStream gzis = new GZIPInputStream((InputStream)in);
                        InputStreamReader reader = new InputStreamReader(gzis);
                        BufferedReader br = new BufferedReader(reader);
                        FastqReader readerGZ = new FastqReader(br);
                        readerGZ.close();
                    } else {
                        FastqReader reader = new FastqReader(new BufferedReader(new InputStreamReader((InputStream)in)));
                        reader.close();
                    }
                    in.close();
                    this.detectPairs(mapPairs, file);
                }
                catch (Exception e1) {
                    ++invalid;
                }
            }
            ++n2;
        }
        Set keys = mapPairs.keySet();
        for (String key : keys) {
            List values = (List)mapPairs.get(key);
            if (values.size() == 2) {
                ++this.amountPE;
                continue;
            }
            ++this.amountSE;
        }
        if (this.amountBams > 0 && this.amountBams == fileList.length) {
            outType = "bam";
        } else if (this.amountSE > 0 && this.amountSE == fileList.length) {
            outType = "se";
        } else if (this.amountPE > 0 && fileList.length != 0 && this.amountPE == fileList.length / 2) {
            outType = "pe";
        }
        log.info((Object)("Bams: " + this.amountBams + " FASTQ-SE: " + this.amountSE + " FASTQ-PE: " + this.amountPE + " Invalid:" + invalid));
        return outType;
    }

    private void detectPairs(HashMap<String, List<String>> mapPairs, FileStatus file) {
        try {
            BufferedReader reader;
            FileSystem fileSystem = FileSystem.get((Configuration)HdfsUtil.getConfiguration());
            FSDataInputStream in = fileSystem.open(file.getPath());
            if (file.getPath().getName().endsWith(".gz")) {
                GZIPInputStream gzis = new GZIPInputStream((InputStream)in);
                InputStreamReader stream = new InputStreamReader(gzis);
                reader = new BufferedReader(stream);
            } else {
                reader = new BufferedReader(new InputStreamReader((InputStream)in));
            }
            String line = reader.readLine();
            String[] keySplits = line.split(" ");
            String key = line.charAt(line.length() - 2) == '/' ? keySplits[1].substring(0, keySplits[1].length() - 2) : keySplits[0];
            List<String> values = mapPairs.get(key);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(file.getPath().toString());
            mapPairs.put(key, values);
            in.close();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean importFiles(WorkflowContext context) {
        for (String input : context.getInputs()) {
            String address = context.get(input).trim();
            if (!ImporterFactory.needsImport(address)) continue;
            context.beginTask("Importing files...");
            String[] urlList = address.split(";")[0].split("\\s+");
            String username = "";
            if (address.split(";").length > 1) {
                username = address.split(";")[1];
            }
            String password = "";
            if (address.split(";").length > 2) {
                password = address.split(";")[2];
            }
            String[] stringArray = urlList;
            int n = urlList.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    String url2;
                    block8: {
                        url2 = stringArray[n2];
                        String url = String.valueOf(url2) + ";" + username + ";" + password;
                        String target = HdfsUtil.path(context.getHdfsTemp(), "importer", input);
                        try {
                            context.updateTask("Import " + url2 + "...", 3);
                            IImporter importer = ImporterFactory.createImporter(url, target);
                            if (importer == null) break block8;
                            boolean successful = importer.importFiles(".bam|.fq|.fastq|.gz");
                            if (successful) {
                                context.setInput(input, target);
                                break block9;
                            }
                            context.updateTask("Import " + url2 + " failed: " + importer.getErrorMessage(), 1);
                            return false;
                        }
                        catch (Exception e) {
                            context.updateTask("Import File(s) " + url2 + " failed: " + e.toString(), 1);
                            e.printStackTrace();
                            return false;
                        }
                    }
                    context.updateTask("Import " + url2 + " failed: Protocol not supported", 1);
                    return false;
                }
                ++n2;
            }
            context.updateTask("File Import successful. ", 0);
        }
        return true;
    }
}

