/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.validate;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.importer.FileItem;
import genepi.hadoop.importer.IImporter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ImporterBamHttp
implements IImporter {
    public static final int REFERENCE_LENGTH = 16569;
    private String url;
    private String path;
    private String error;

    public ImporterBamHttp(String url, String path) {
        this.url = url.split(";")[0];
        this.path = path;
    }

    public long getFileSize() {
        try {
            URL webUrl = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)webUrl.openConnection();
            return conn.getContentLength();
        }
        catch (MalformedURLException e) {
            this.error = e.getMessage();
            return -1L;
        }
        catch (IOException e) {
            this.error = e.getMessage();
            return -1L;
        }
    }

    @Override
    public boolean importFiles() {
        return this.importFiles(null);
    }

    @Override
    public boolean importFiles(String extension) {
        Configuration conf = HdfsUtil.getConfiguration();
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            return this.importIntoHdfs(this.url, fileSystem, this.path);
        }
        catch (IOException e) {
            this.error = e.getMessage();
            e.printStackTrace();
            return false;
        }
    }

    public boolean importIntoHdfs(String weburl, FileSystem fileSystem, String path) throws IOException {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(SamInputResource.of(new URL(weburl)).index(new URL(String.valueOf(weburl) + ".bai")));
        String[] tiles = weburl.split("/");
        String name = tiles[tiles.length - 1];
        String target = HdfsUtil.path(path, name);
        SAMFileHeader header = reader.getFileHeader();
        SAMSequenceDictionary seqDictionary = header.getSequenceDictionary();
        String referenceName = null;
        for (SAMSequenceRecord record : seqDictionary.getSequences()) {
            if (record.getSequenceLength() != 16569) continue;
            referenceName = record.getSequenceName();
        }
        if (referenceName == null) {
            reader.close();
            this.error = "No mitochondrial contig found in " + weburl + ".";
            return false;
        }
        FSDataOutputStream out = fileSystem.create(new Path(target));
        SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(reader.getFileHeader(), true, (OutputStream)out);
        SAMRecordIterator reads = reader.query(referenceName, 0, 0, false);
        int good = 0;
        int bad = 0;
        int written = 0;
        SAMRecord read = null;
        while (reads.hasNext()) {
            try {
                read = (SAMRecord)reads.next();
                ++good;
            }
            catch (Exception e) {
                ++bad;
            }
            writer.addAlignment(read);
            ++written;
        }
        writer.close();
        reader.close();
        System.out.println("Bad reads: " + bad);
        System.out.println("Good reads: " + good);
        System.out.println("Written reads: " + written);
        return true;
    }

    @Override
    public List<FileItem> getFiles() {
        Vector<FileItem> items = new Vector<FileItem>();
        FileItem file = new FileItem();
        file.setText(FilenameUtils.getName(this.url));
        file.setPath("/");
        file.setId("/");
        file.setSize(FileUtils.byteCountToDisplaySize(this.getFileSize()));
        items.add(file);
        return items;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

