/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.util;

import genepi.mut.objects.VariantLine;
import genepi.mut.objects.VariantResult;
import genepi.mut.util.StatUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class VariantCaller {
    public static int VARIANT = 1;
    public static int LOW_LEVEL_VARIANT = 2;
    public static int DELETION = 4;
    public static int INSERTION = 5;

    public static boolean isFinalVariant(VariantLine line) {
        if (line.getVariantType() == VARIANT || line.getVariantType() == LOW_LEVEL_VARIANT) {
            return true;
        }
        return line.getVariantType() == DELETION;
    }

    public static VariantResult determineVariants(VariantLine line) {
        if (!line.isInsertion()) {
            if (line.getBayesBase() != '-' && line.getBayesProbability() > 0.8 && line.getBayesBase() != line.getRef() && line.getCovFWD() + line.getCovREV() >= 2) {
                int type = VARIANT;
                if (line.getBayesBase() == 'D') {
                    type = DELETION;
                }
                return VariantCaller.addHomoplasmyResult(line, type);
            }
        } else if (line.getTopBaseFWD() == line.getTopBaseREV() && line.getTopBaseFWD() != line.getRef() && line.getCovFWD() + line.getCovREV() / 2 >= 70) {
            int type = INSERTION;
            return VariantCaller.addHomoplasmyResult(line, type);
        }
        return null;
    }

    public static VariantResult determineLowLevelVariant(VariantLine line, double minorBasePercentsFWD, double minorBasePercentsREV, double llrFwd, double llrRev, double level, char minor) {
        int type = 0;
        try {
            if (VariantCaller.checkCoverage(line)) {
                if (VariantCaller.checkAlleleCoverage(line, minorBasePercentsFWD, minorBasePercentsREV) && (minorBasePercentsFWD >= level || minorBasePercentsREV >= level) && (llrFwd >= 5.0 || llrRev >= 5.0) && VariantCaller.calcStrandBias(line, minorBasePercentsFWD, minorBasePercentsREV) <= 1.0) {
                    type = LOW_LEVEL_VARIANT;
                    return VariantCaller.addVariantResult(line, type);
                }
            } else {
                line.setMessage("Position coverage not sufficient. No model can be applied");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return VariantCaller.addVariantResult(line, type);
    }

    private static VariantResult addVariantResult(VariantLine line, int type) {
        VariantResult output = new VariantResult();
        output.setId(line.getId());
        if (line.getInsPosition() != null) {
            output.setPosition(line.getInsPosition());
        } else {
            output.setPosition(String.valueOf(line.getPosition()));
        }
        output.setTop(line.getTopBaseFWD());
        output.setMinor(line.getMinorBaseFWD());
        output.setRef(line.getRef());
        output.setCovFWD(line.getCovFWD());
        output.setCovREV(line.getCovREV());
        output.setType(type);
        return output;
    }

    private static VariantResult addHomoplasmyResult(VariantLine line, int type) {
        VariantResult output = new VariantResult();
        output.setId(line.getId());
        if (line.getInsPosition() != null) {
            output.setPosition(line.getInsPosition());
        } else {
            output.setPosition(String.valueOf(line.getPosition()));
        }
        if (type == 1) {
            output.setTop(line.getBayesBase());
            output.setLevel(VariantCaller.calcLevel(line, line.getBayesPercentageFWD(), line.getBayesPercentageREV()));
        } else {
            output.setTop(line.getTopBaseFWD());
            output.setLevel(VariantCaller.calcVariantLevel(line, line.getMinorBasePercentsFWD(), line.getMinorBasePercentsREV()));
        }
        output.setMinor('-');
        output.setRef(line.getRef());
        output.setCovFWD(line.getCovFWD());
        output.setCovREV(line.getCovREV());
        output.setType(type);
        return output;
    }

    public static double calcVariantLevel(VariantLine line, double minorPercentFWD, double minorPercentREV) {
        double rev;
        double fwd;
        if (line.getTopBaseFWD() == line.getRef()) {
            fwd = minorPercentFWD * (double)line.getCovFWD();
            rev = minorPercentREV * (double)line.getCovREV();
        } else {
            fwd = line.getTopBasePercentsFWD() * (double)line.getCovFWD();
            rev = line.getTopBasePercentsREV() * (double)line.getCovREV();
        }
        return (fwd + rev) / (double)(line.getCovFWD() + line.getCovREV());
    }

    public static double calcLevel(VariantLine line, double percentFWD, double percentREV) {
        double fwd = percentFWD * (double)line.getCovFWD();
        double rev = percentREV * (double)line.getCovREV();
        return (fwd + rev) / (double)(line.getCovFWD() + line.getCovREV());
    }

    private static boolean checkAlleleCoverage(VariantLine line, double minorPercentFWD, double minorPercentREV) {
        int coverage = 2;
        if (line.getTopBasePercentsREV() * (double)line.getCovREV() <= (double)coverage || line.getTopBasePercentsFWD() * (double)line.getCovFWD() <= (double)coverage) {
            return false;
        }
        return !(minorPercentREV * (double)line.getCovREV() <= (double)coverage) && !(line.getTopBasePercentsFWD() * (double)line.getCovFWD() <= (double)coverage);
    }

    private static boolean checkCoverage(VariantLine line) {
        return line.getCovREV() >= 10 && line.getCovFWD() >= 10;
    }

    public static double getMinorPercentageFwd(VariantLine line, char minor) {
        double minorFWD = 0.0;
        if (minor == 'A') {
            minorFWD = line.getaPercentageFWD();
        }
        if (minor == 'C') {
            minorFWD = line.getcPercentageFWD();
        }
        if (minor == 'G') {
            minorFWD = line.getgPercentageFWD();
        }
        if (minor == 'T') {
            minorFWD = line.gettPercentageFWD();
        }
        if (minor == 'D') {
            minorFWD = line.getdPercentageFWD();
        }
        return minorFWD;
    }

    public static double getMinorPercentageRev(VariantLine line, char minor) {
        double minorREV = 0.0;
        if (minor == 'A') {
            minorREV = line.getaPercentageREV();
        }
        if (minor == 'C') {
            minorREV = line.getcPercentageREV();
        }
        if (minor == 'G') {
            minorREV = line.getgPercentageREV();
        }
        if (minor == 'T') {
            minorREV = line.gettPercentageREV();
        }
        if (minor == 'D') {
            minorREV = line.getdPercentageREV();
        }
        return minorREV;
    }

    public static double determineLlrFwd(VariantLine line, char minor) {
        double llrFwd = 0.0;
        if (minor == 'A') {
            llrFwd = line.getLlrAFWD();
        }
        if (minor == 'C') {
            llrFwd = line.getLlrCFWD();
        }
        if (minor == 'G') {
            llrFwd = line.getLlrGFWD();
        }
        if (minor == 'T') {
            llrFwd = line.getLlrTFWD();
        }
        if (minor == 'D') {
            llrFwd = line.getLlrDFWD();
        }
        return llrFwd;
    }

    public static double determineLlrRev(VariantLine line, char minor) {
        double llrRev = 0.0;
        if (minor == 'A') {
            llrRev = line.getLlrAREV();
        }
        if (minor == 'C') {
            llrRev = line.getLlrCREV();
        }
        if (minor == 'G') {
            llrRev = line.getLlrGREV();
        }
        if (minor == 'T') {
            llrRev = line.getLlrTREV();
        }
        if (minor == 'D') {
            llrRev = line.getLlrDREV();
        }
        return llrRev;
    }

    private static double calcStrandBias(VariantLine line, double minorPercentFWD, double minorPercentREV) {
        double a = line.getTopBasePercentsFWD() * (double)line.getCovFWD();
        double c = line.getTopBasePercentsREV() * (double)line.getCovREV();
        double b = minorPercentFWD * (double)line.getCovFWD();
        double d = minorPercentREV * (double)line.getCovREV();
        double bias = Math.abs(b / (a + b) - d / (c + d)) / ((b + d) / (a + b + c + d));
        return bias;
    }

    private static void calcConfidence(VariantLine line) {
        if (line.getCovFWD() * line.getCovREV() / 2 < 40) {
            VariantCaller.generateWilsonInterval(line);
        } else {
            VariantCaller.generateAgrestiInterval(line);
        }
    }

    private static void generateAgrestiInterval(VariantLine line) {
        double covBaseFWD = line.getMinorBasePercentsFWD() * (double)line.getCovFWD();
        double covBaseREV = line.getMinorBasePercentsREV() * (double)line.getCovREV();
        double lowFWD = StatUtil.CIAC_LOW(covBaseFWD, line.getCovFWD());
        double upFWD = StatUtil.CIAC_UP(covBaseFWD, line.getCovFWD());
        line.setCIAC_LOW_FWD(lowFWD);
        line.setCIAC_UP_FWD(upFWD);
        double lowREV = StatUtil.CIAC_LOW(covBaseREV, line.getCovREV());
        double upREV = StatUtil.CIAC_UP(covBaseREV, line.getCovREV());
        line.setCIAC_LOW_REV(lowREV);
        line.setCIAC_UP_REV(upREV);
    }

    private static void generateWilsonInterval(VariantLine line) {
        double p1 = line.getMinorBasePercentsFWD() * (double)line.getCovFWD() / (double)line.getCovFWD();
        double p2 = line.getMinorBasePercentsREV() * (double)line.getCovREV() / (double)line.getCovREV();
        double lowFWD = StatUtil.CIW_LOW(p1, line.getCovFWD());
        double upFWD = StatUtil.CIW_UP(p1, line.getCovFWD());
        line.setCIW_LOW_FWD(lowFWD);
        line.setCIW_UP_FWD(upFWD);
        double lowREV = StatUtil.CIW_LOW(p2, line.getCovREV());
        double upREV = StatUtil.CIW_UP(p2, line.getCovREV());
        line.setCIW_LOW_REV(lowREV);
        line.setCIW_UP_REV(upREV);
    }

    public static String writeVariant(VariantResult result) throws IOException {
        Locale.setDefault(new Locale("en", "US"));
        NumberFormat df = DecimalFormat.getInstance(Locale.US);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(3);
        df.setGroupingUsed(false);
        StringBuilder build = new StringBuilder();
        build.append(String.valueOf(result.getId()) + "\t");
        build.append(String.valueOf(result.getPosition()) + "\t");
        build.append(String.valueOf(result.getRef()) + "\t");
        build.append(String.valueOf(VariantCaller.getVariantBase(result)) + "\t");
        build.append(String.valueOf(df.format(result.getLevel())) + "\t");
        build.append(String.valueOf(result.getTop()) + "\t");
        build.append(String.valueOf(df.format(result.getLevelTop())) + "\t");
        build.append(String.valueOf(result.getMinor()) + "\t");
        build.append(String.valueOf(df.format(result.getLevelMinor())) + "\t");
        build.append(String.valueOf(result.getCovFWD() + result.getCovREV()) + "\t");
        build.append(String.valueOf(result.getCovFWD()) + "\t");
        build.append(String.valueOf(result.getCovREV()) + "\t");
        build.append(result.getType());
        return build.toString();
    }

    private static char getVariantBase(VariantResult line) {
        if (line.getTop() == line.getRef()) {
            return line.getMinor();
        }
        return line.getTop();
    }
}

