/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.util;

import genepi.mut.util.ReferenceUtil;
import genepi.mut.util.VcfWriter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.ArrayUtils;

public class HaplogroupSimulator {
    static HashMap<String, String> haplogroups = new HashMap();
    static Vector<String> haplogroupsSet = new Vector();
    static HashSet<String> includedHg = new HashSet();

    public static String generateProfiles(String id, String profile1, String profile2, int noise) {
        char minor;
        char major;
        String variantBase;
        char ref;
        int pos;
        int noiseFactor1 = (int)(Math.random() * (double)noise);
        int noiseFactor2 = noise - noiseFactor1;
        profile1 = HaplogroupSimulator.shuffleHg(profile1, noiseFactor1);
        StringTokenizer stprofile1 = new StringTokenizer(profile1);
        HashSet<String> set1 = new HashSet<String>();
        while (stprofile1.hasMoreElements()) {
            set1.add(stprofile1.nextToken());
        }
        HashSet<String> set2 = new HashSet<String>();
        profile2 = HaplogroupSimulator.shuffleHg(profile2, noiseFactor2);
        StringTokenizer stprofile2 = new StringTokenizer(profile2);
        while (stprofile2.hasMoreElements()) {
            set2.add(stprofile2.nextToken());
        }
        StringBuilder builder = new StringBuilder();
        String refString = ReferenceUtil.readInReference("test-data/mtdna/reference/rCRS.fasta");
        for (String variant : set1) {
            double level;
            if (variant.contains("d") || variant.contains(".") || variant.contains("!")) continue;
            pos = Integer.valueOf(variant.substring(0, variant.length() - 1));
            ref = refString.charAt(pos - 1);
            variantBase = variant.substring(variant.length() - 1);
            id = id.replace("  ", " ").replace(" ", "+");
            major = variantBase.charAt(0);
            minor = ref;
            if (set2.contains(variant)) {
                level = 1.0;
                builder.append(String.valueOf(id) + "\t" + pos + "\t" + ref + "\t" + variantBase + "\t" + major + "\t" + minor + "\t1" + "\t" + level + "\n");
                continue;
            }
            level = 0.8;
            builder.append(String.valueOf(id) + "\t" + pos + "\t" + ref + "\t" + variantBase + "\t" + major + "\t" + minor + "\t2" + "\t" + level + "\n");
        }
        for (String variant : set2) {
            if (variant.contains("d") || variant.contains(".") || variant.contains("!")) continue;
            pos = Integer.valueOf(variant.substring(0, variant.length() - 1));
            ref = refString.charAt(pos - 1);
            variantBase = variant.substring(variant.length() - 1);
            major = ref;
            minor = variantBase.charAt(0);
            if (set1.contains(variant)) continue;
            builder.append(String.valueOf(id.replace("  ", " ")) + "\t" + pos + "\t" + ref + "\t" + variantBase + "\t" + major + "\t" + minor + "\t2" + "\t0.2" + "\n");
        }
        return builder.toString();
    }

    private static String generateMixtures(String filter, int size, int noise, boolean createContamination) {
        StringBuilder build = new StringBuilder();
        int countMixtures = 0;
        int phylotreeSize = haplogroupsSet.size();
        int j = 0;
        while (j < phylotreeSize) {
            int k = (int)(Math.random() * (double)phylotreeSize);
            if (countMixtures >= size) break;
            ++countMixtures;
            if (createContamination && j == k) {
                ++size;
            } else {
                String uniqueHg;
                if (!createContamination) {
                    k = j;
                }
                if (includedHg.contains(uniqueHg = String.valueOf(j) + "_" + k)) {
                    ++size;
                } else {
                    String mixture;
                    String id;
                    String profile2;
                    String profile1;
                    includedHg.add(uniqueHg);
                    if (filter.equals("*")) {
                        profile1 = haplogroups.get(haplogroupsSet.get(j));
                        profile2 = haplogroups.get(haplogroupsSet.get(k));
                        id = String.valueOf(haplogroupsSet.get(j)) + "_" + haplogroupsSet.get(k);
                        mixture = HaplogroupSimulator.generateProfiles(id, profile1, profile2, noise);
                        build.append(mixture);
                    } else if (haplogroupsSet.get(j).toString().startsWith(filter) && haplogroupsSet.get(k).toString().startsWith(filter)) {
                        profile1 = haplogroups.get(haplogroupsSet.get(j));
                        profile2 = haplogroups.get(haplogroupsSet.get(k));
                        id = String.valueOf(haplogroupsSet.get(j)) + "_" + haplogroupsSet.get(k);
                        mixture = HaplogroupSimulator.generateProfiles(id, profile1, profile2, noise);
                        build.append(mixture);
                    }
                }
            }
            ++j;
        }
        return build.toString();
    }

    private static String shuffleHg(String inputProfile, int noise) {
        int j;
        int k = (int)(Math.random() * (double)noise);
        Object[] splits = inputProfile.split(" ");
        int i = 0;
        while (i < k) {
            j = (int)(Math.random() * (double)splits.length);
            if (j < splits.length) {
                splits = (String[])ArrayUtils.remove(splits, j);
            }
            ++i;
        }
        inputProfile = String.join((CharSequence)" ", (CharSequence[])splits);
        i = 0;
        while (i < noise - k) {
            j = (int)(Math.random() * (double)haplogroupsSet.size());
            String profileHg = haplogroups.get(haplogroupsSet.get(j));
            String[] splitsHg = profileHg.split(" ");
            int variantPos = (int)(Math.random() * (double)splitsHg.length);
            inputProfile = String.valueOf(inputProfile) + " " + splitsHg[variantPos];
            ++i;
        }
        return inputProfile;
    }

    private static void loadHaplogroups() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("test-data/phylotree17.hsd"));
            String line = br.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                st.nextToken();
                st.nextToken();
                String hg = st.nextToken();
                if (!hg.equals("H2a2a1")) {
                    StringBuffer profile = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        profile.append(String.valueOf(st.nextToken()) + " ");
                    }
                    haplogroups.put(hg, profile.toString());
                    haplogroupsSet.add(hg);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            HaplogroupSimulator.loadHaplogroups();
            int samples = 500000;
            int noise = 0;
            while (noise <= 32) {
                FileWriter writer = new FileWriter("test-data/simulator.txt");
                String header = "ID\tPos\tRef\tVariant\tMajorBase\tMinorBase\tType\tVariantLevel\n";
                writer.append(header);
                boolean createCont = true;
                String mixture = HaplogroupSimulator.generateMixtures("*", samples / 2, noise, createCont);
                writer.append(mixture);
                includedHg = new HashSet();
                mixture = "";
                createCont = false;
                mixture = HaplogroupSimulator.generateMixtures("*", samples / 2, noise, createCont);
                writer.append(mixture);
                writer.close();
                VcfWriter vcfWwriter = new VcfWriter();
                vcfWwriter.createVCF("test-data/simulator.txt", "test-data/" + noise + ".vcf.gz", "test-data/mtdna/mixtures/reference/rCRS.fasta", "chrM", 16569, "simulator noise:" + noise);
                System.out.println(".");
                noise += 4;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("done");
    }
}

