/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.util;

import genepi.mut.objects.Sample;
import genepi.mut.objects.Variant;
import genepi.mut.util.MutationServerReader;
import genepi.mut.util.ReferenceUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FastaWriter {
    public void createFasta(String in, String out, String reference) {
        MutationServerReader reader = new MutationServerReader(in);
        double level = 0.5;
        try {
            String contents = ReferenceUtil.readInReference(reference);
            FileWriter writer = new FileWriter(new File(out));
            StringBuilder build = new StringBuilder();
            HashMap<String, Sample> samples = reader.parse();
            for (Sample sam : samples.values()) {
                build.setLength(0);
                build.append(">" + sam.getId() + "\n");
                int i = 0;
                String[] stringArray = contents.split("");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList<Variant> vars;
                    String ref = stringArray[n2];
                    if ((vars = sam.getVariants(++i)) == null) {
                        build.append(ref);
                    } else {
                        int type1 = 0;
                        int type5 = 0;
                        boolean complex = false;
                        boolean multiInsertion = false;
                        for (Variant var : vars) {
                            if (var.getType() >= 1 && var.getType() <= 4 && var.getLevel() > level) {
                                ++type1;
                            }
                            if (var.getType() != 5) continue;
                            ++type5;
                        }
                        if (type1 >= 1 && type5 >= 1) {
                            complex = true;
                        } else if (type5 > 1) {
                            multiInsertion = true;
                        }
                        if (!complex && !multiInsertion) {
                            Variant var;
                            var = vars.get(0);
                            if (var.getVariant() != 'D' || !(var.getLevel() > level)) {
                                if (var.getType() == 2 && var.getLevel() >= level) {
                                    build.append(var.getVariant());
                                } else if (var.getType() == 5) {
                                    build.append(String.valueOf(ref) + var.getVariant());
                                } else if (var.getType() == 1) {
                                    build.append(var.getVariant());
                                } else {
                                    build.append(ref);
                                }
                            }
                        } else {
                            if (multiInsertion && !complex) {
                                StringBuilder insertionBuilder = new StringBuilder();
                                for (Variant var : vars) {
                                    if (var.getType() != 5) continue;
                                    insertionBuilder.append(var.getVariant());
                                }
                                String insertion = insertionBuilder.toString();
                                build.append(String.valueOf(ref) + insertion);
                            }
                            if (complex) {
                                StringBuilder complexBuilder = new StringBuilder();
                                String variant = ref;
                                for (Variant var : vars) {
                                    if (var.getType() == 5) {
                                        complexBuilder.append(var.getVariant());
                                        continue;
                                    }
                                    if (var.getType() != 1 && (var.getType() != 2 || !(var.getLevel() >= level) || var.getVariant() == 'D')) continue;
                                    variant = String.valueOf(var.getVariant());
                                }
                                String insertion = complexBuilder.toString();
                                build.append(String.valueOf(variant) + insertion);
                            }
                        }
                    }
                    ++n2;
                }
                writer.write(String.valueOf(build.toString()) + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

