/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tools;

import genepi.mut.App;
import genepi.mut.objects.BayesFrequencies;
import genepi.mut.tasks.MergeTask;
import genepi.mut.tasks.VariantCallingTask;
import genepi.mut.util.FastaWriter;
import genepi.mut.util.VcfWriter;
import htsjdk.samtools.util.StopWatch;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.Task;
import lukfor.progress.tasks.TaskFailureStrategy;
import picocli.CommandLine;

@CommandLine.Command(name="call", version={"v2.0.0-rc7"}, description={"Call homoplasmic and heteroplasmic positions."})
public class VariantCallingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"BAM/CRAM files"})
    List<String> input;
    @CommandLine.Option(names={"--output"}, description={"\"Output (txt or vcf)"}, required=true)
    String output;
    @CommandLine.Option(names={"--reference"}, description={"Reference"}, required=true)
    String reference;
    @CommandLine.Option(names={"--threads"}, description={"Number of threads"}, required=false)
    int threads = 1;
    @CommandLine.Option(names={"--level"}, description={"Minimum Heteroplasmy Level"}, required=false)
    double level = 0.01;
    @CommandLine.Option(names={"--baseQ"}, description={"Minimum Base Quality"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    int baseQ = 20;
    @CommandLine.Option(names={"--mapQ"}, description={"Minimum Map Quality"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    int mapQ = 20;
    @CommandLine.Option(names={"--alignQ"}, description={"Minimum Align Quality"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    int alignQ = 30;
    @CommandLine.Option(names={"--baq"}, description={"Enable BAQ"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean baq = false;
    @CommandLine.Option(names={"--no-freq"}, description={"Use Frequency File"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean noFreq = false;
    @CommandLine.Option(names={"--deletions"}, description={"Call deletions (beta)"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean deletions = false;
    @CommandLine.Option(names={"--insertions"}, description={"Call insertions (beta)"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean insertions = false;
    @CommandLine.Option(names={"--write-raw"}, description={"Write raw file"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean writeRaw = false;
    @CommandLine.Option(names={"--write-fasta"}, description={"Write fasta file"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean writeFasta = false;
    @CommandLine.Option(names={"--contig-name"}, description={"Specifify mtDNA contig name"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    String contig;
    @CommandLine.Option(names={"--mode"}, description={"Specifify mutserve mode"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    String mode = "mtdna";
    @CommandLine.Option(names={"--no-ansi"}, description={"Disable ANSI support"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean noAnsi = false;
    @CommandLine.Option(names={"--version"}, versionHelp=true)
    boolean showVersion;
    @CommandLine.Option(names={"--help"}, usageHelp=true)
    boolean showHelp;

    @Override
    public Integer call() {
        if (this.input.size() == 1 && new File(this.input.get(0)).isDirectory()) {
            int count = 0;
            File[] fileArray = new File(this.input.get(0)).listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith("bam") || f.getName().endsWith("cram")) {
                    this.input.add(f.getAbsolutePath());
                    ++count;
                }
                ++n2;
            }
            System.out.println(String.valueOf(count) + " files added.");
            this.input.remove(0);
        }
        if (this.input == null || this.input.isEmpty()) {
            System.out.println();
            System.out.println("Please provide at least one indexed CRAM or BAM file.");
            System.out.println();
            System.exit(-1);
        }
        HashMap<String, Double> freqFile = null;
        if (!this.noFreq) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("1000g.frq");
            freqFile = BayesFrequencies.instance(new DataInputStream(in));
        }
        if (this.noAnsi) {
            TaskService.setAnsiSupport(false);
        }
        String prefix = this.output;
        if (this.output.contains(".")) {
            prefix = this.output.substring(0, this.output.indexOf(46));
        }
        String variantPath = String.valueOf(prefix) + ".txt";
        String rawPath = null;
        if (this.writeRaw) {
            rawPath = String.valueOf(prefix) + "_raw.txt";
        }
        StopWatch watch = new StopWatch();
        watch.start();
        Vector<VariantCallingTask> tasks = new Vector<VariantCallingTask>();
        int index = 0;
        for (String name : this.input) {
            String varName = String.valueOf(variantPath) + ".tmp." + index;
            String rawName = null;
            if (rawPath != null) {
                rawName = String.valueOf(rawPath) + ".tmp." + index;
            }
            VariantCallingTask vc = new VariantCallingTask();
            vc.setInput(name);
            vc.setVarName(varName);
            vc.setRawName(rawName);
            vc.setFreqFile(freqFile);
            vc.setLevel(this.level);
            vc.setBaseQ(this.baseQ);
            vc.setMapQ(this.mapQ);
            vc.setAlignQ(this.alignQ);
            vc.setBaq(this.baq);
            vc.setDeletions(this.deletions);
            vc.setInsertions(this.insertions);
            vc.setReference(this.reference);
            vc.setMode(this.mode);
            vc.setContig(this.contig);
            tasks.add(vc);
            ++index;
        }
        TaskService.setFailureStrategy(TaskFailureStrategy.CANCEL_TASKS);
        TaskService.setThreads(this.threads);
        List<Task> taskList = TaskService.monitor(App.STYLE_LONG_TASK).run(tasks);
        for (Task task : taskList) {
            if (task.getStatus().isSuccess()) continue;
            System.out.println(task.getStatus().getThrowable().toString());
            System.out.println("Variant Calling failed. Mutserve terminated.");
            System.exit(-1);
        }
        MergeTask mergeTask = new MergeTask();
        mergeTask.setRawPath(rawPath);
        mergeTask.setInputs(tasks);
        mergeTask.setVariantPath(variantPath);
        TaskService.monitor(App.STYLE_SHORT_TASK).run(mergeTask);
        if (this.output.endsWith("vcf.gz") || this.output.endsWith("vcf")) {
            VcfWriter vcfWriter = new VcfWriter();
            vcfWriter.createVCF(variantPath, this.output, this.reference, "chrM", 16569, "v2.0.0-rc7;" + App.COMMAND);
        }
        if (this.writeFasta) {
            FastaWriter fastaWriter = new FastaWriter();
            fastaWriter.createFasta(variantPath, String.valueOf(prefix) + ".fasta", this.reference);
        }
        System.out.println();
        System.out.println("Execution Time: " + this.formatTime(watch.getElapsedTimeSecs()));
        System.out.println();
        watch.stop();
        return 0;
    }

    public String formatTime(long timeInSeconds) {
        return String.format("%d min, %d sec", timeInSeconds / 60L, timeInSeconds % 60L);
    }
}

