/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tools;

import genepi.base.Tool;
import genepi.io.table.reader.CsvTableReader;
import genepi.mut.tools.CalcPrecision;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class GenerateGoldStandard
extends Tool {
    NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
    DecimalFormat df = (DecimalFormat)this.nf;

    public GenerateGoldStandard(String[] args) {
        super(args);
    }

    @Override
    public void createParameters() {
        this.addParameter("file1", "major component file");
        this.addParameter("file2", "minor component file");
        this.addParameter("level", "mixture-level", 4);
        this.addParameter("output", "output file for performance step");
    }

    @Override
    public void init() {
        System.out.println("Generate Gold-Standards for Mixture-Model");
    }

    @Override
    public int run() {
        String pos = "Pos";
        String sampleId = "ID";
        String variantlevel = "VariantLevel";
        DecimalFormat df3 = new DecimalFormat("#.####");
        String inputMajor = (String)this.getValue("file1");
        String inputMinor = (String)this.getValue("file2");
        double level = (Double)this.getValue("level");
        String outputGoldfile = (String)this.getValue("output");
        CsvTableReader variantMajor = new CsvTableReader(inputMajor, '\t');
        TreeMap<Integer, Double> goldMap = new TreeMap<Integer, Double>();
        while (variantMajor.next()) {
            int posSample = variantMajor.getInteger("Pos");
            double variantlevSample = variantMajor.getDouble("VariantLevel");
            goldMap.put(posSample, variantlevSample * (1.0 - level));
        }
        CsvTableReader variantMinor = new CsvTableReader(inputMinor, '\t');
        while (variantMinor.next()) {
            int posSample = variantMinor.getInteger("Pos");
            double variantlevSample = variantMinor.getDouble("VariantLevel");
            if (goldMap.containsKey(posSample)) {
                goldMap.put(posSample, (Double)goldMap.get(posSample) + variantlevSample * level);
                continue;
            }
            goldMap.put(posSample, variantlevSample * level);
        }
        try {
            FileWriter writer = new FileWriter(new File(outputGoldfile));
            StringBuilder build = new StringBuilder();
            build.append("Pos\tVariantLevel\n");
            Iterator it = goldMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                int hpos = (Integer)pair.getKey();
                build.append(pair.getKey() + "\t" + df3.format(pair.getValue()) + "\n");
                it.remove();
            }
            writer.write(build.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] args) {
        String file1 = "test-data/mtdna/mixtures/HG01500_HG00183/HG01500.txt";
        String file2 = "test-data/mtdna/mixtures/HG01500_HG00183/HG00183.txt";
        String gold = "test-data/mtdna/mixtures/HG01500_HG00183/out/HG01500_HG00183.gold.txt";
        String fileMixture50 = "test-data/mtdna/mixtures/HG01500_HG00183/HG01500_HG00183.txt";
        String length = "16569";
        String mixtureLevel = "0.5";
        String detectionLevel = "0.01";
        GenerateGoldStandard gs = new GenerateGoldStandard(new String[]{"--file1", file1, "--file2", file2, "--output", gold, "--level", mixtureLevel});
        gs.start();
        CalcPrecision precison = new CalcPrecision(new String[]{"--gold", gold, "--in", fileMixture50, "--length", length, "--level", detectionLevel});
        precison.start();
    }
}

