/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tools;

import genepi.base.Tool;
import genepi.io.table.reader.CsvTableReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TreeSet;

public class CalcPrecisionLPA
extends Tool {
    NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
    DecimalFormat df = (DecimalFormat)this.nf;

    public CalcPrecisionLPA(String[] args) {
        super(args);
    }

    @Override
    public void createParameters() {
        this.addParameter("gold", "expected positions");
        this.addParameter("in", "input csv file");
    }

    @Override
    public void init() {
        System.out.println("Precision Calculator");
    }

    @Override
    public int run() {
        TreeSet<Integer> allPos = new TreeSet<Integer>();
        TreeSet<Integer> sangerPos = new TreeSet<Integer>();
        TreeSet<Integer> falsePositives = new TreeSet<Integer>();
        TreeSet<Integer> both = new TreeSet<Integer>();
        String in = (String)this.getValue("in");
        String gold = (String)this.getValue("gold");
        CsvTableReader idReader = new CsvTableReader(in, '\t');
        TreeSet<String> ids = new TreeSet<String>();
        while (idReader.next()) {
            ids.add(idReader.getString("ID"));
        }
        idReader.close();
        for (String id : ids) {
            CsvTableReader goldReader = new CsvTableReader(gold, '\t');
            while (goldReader.next()) {
                sangerPos.add(goldReader.getInteger("POS"));
                allPos.add(goldReader.getInteger("POS"));
            }
            CsvTableReader variantReader = new CsvTableReader(in, '\t');
            falsePositives.clear();
            both.clear();
            int truePositiveCount = 0;
            int falsePositiveCount = 0;
            int trueNegativeCount = 0;
            int falseNegativeCount = 0;
            int foundBySanger = 0;
            while (variantReader.next()) {
                String idSample = variantReader.getString("ID");
                int posSample = variantReader.getInteger("POS");
                if (!id.equals(idSample)) continue;
                int position = posSample;
                if (sangerPos.contains(position)) {
                    sangerPos.remove(position);
                    ++truePositiveCount;
                    both.add(position);
                    continue;
                }
                falsePositives.add(position);
                ++falsePositiveCount;
            }
            int j = 1;
            while (j <= 5104) {
                if (!falsePositives.contains(j) && !both.contains(j)) {
                    if (!allPos.contains(j)) {
                        ++trueNegativeCount;
                    } else {
                        ++falseNegativeCount;
                    }
                }
                ++j;
            }
            variantReader.close();
            foundBySanger = sangerPos.size();
            double sens2 = (double)truePositiveCount / (double)(truePositiveCount + falseNegativeCount) * 100.0;
            double spec2 = (double)trueNegativeCount / (double)(falsePositiveCount + trueNegativeCount) * 100.0;
            double prec2 = (double)truePositiveCount / (double)(truePositiveCount + falsePositiveCount) * 100.0;
            this.df.setMinimumFractionDigits(2);
            this.df.setMaximumFractionDigits(3);
            String sens = this.df.format(sens2);
            String spec = this.df.format(spec2);
            String prec = this.df.format(prec2);
            System.out.println(String.valueOf(id) + "\t" + prec + "\t" + sens + "\t" + spec);
        }
        return 0;
    }

    public static void main(String[] args) {
        String goldPlasmid12 = "test-data/dna/plasmids/plasmid12/gold/plasmid12_major.txt";
        String goldPlasmid13 = "test-data/dna/plasmids/plasmid13/gold/plasmid13_minor.txt";
        String goldPlasmid12Del = "test-data/dna/plasmids/plasmid12/gold/plasmid12_major_del.txt";
        String goldPlasmid13Del = "test-data/dna/plasmids/plasmid13/gold/plasmid13_minor_del.txt";
        System.out.println("PLASMID 12");
        System.out.println(" ");
        CalcPrecisionLPA mutserver = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid12, "--in", "test-data/dna/plasmids/plasmid12/results/plasmid12-mutserver.txt"});
        mutserver.start();
        System.out.println("");
        System.out.println("FREEBAYES");
        CalcPrecisionLPA freebayes = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid12, "--in", "test-data/dna/plasmids/plasmid12/results/plasmid12-freebayes.txt"});
        freebayes.start();
        System.out.println("");
        System.out.println("GATK");
        CalcPrecisionLPA gatk = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid12, "--in", "test-data/dna/plasmids/plasmid12/results/plasmid12-gatk.txt"});
        gatk.start();
        System.out.println("");
        System.out.println("LOFREQ");
        CalcPrecisionLPA lofreq = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid12, "--in", "test-data/dna/plasmids/plasmid12/results/plasmid12-lofreq.txt"});
        lofreq.start();
        System.out.println("");
        System.out.println("");
        System.out.println("PLASMID 13");
        System.out.println("");
        System.out.println("MUTATION SERVER");
        mutserver = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid13, "--in", "test-data/dna/plasmids/plasmid13/results/plasmid13-mutserver.txt"});
        mutserver.start();
        System.out.println("");
        System.out.println("FREEBAYES");
        freebayes = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid13, "--in", "test-data/dna/plasmids/plasmid13/results/plasmid13-freebayes.txt"});
        freebayes.start();
        System.out.println("");
        System.out.println("GATK");
        gatk = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid13, "--in", "test-data/dna/plasmids/plasmid13/results/plasmid13-gatk.txt"});
        gatk.start();
        System.out.println("");
        System.out.println("LOFREQ");
        lofreq = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid13, "--in", "test-data/dna/plasmids/plasmid13/results/plasmid13-lofreq.txt"});
        lofreq.start();
        System.out.println("");
        System.out.println("PLASMID 12 INDEL");
        System.out.println("");
        System.out.println("MUTATION SERVER");
        mutserver = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid12Del, "--in", "test-data/dna/plasmids/plasmid12/results/plasmid12-mutserver-del.txt"});
        mutserver.start();
        System.out.println("");
        System.out.println("PLASMID 13 INDEL");
        System.out.println("");
        System.out.println("MUTATION SERVER");
        mutserver = new CalcPrecisionLPA(new String[]{"--gold", goldPlasmid13Del, "--in", "test-data/dna/plasmids/plasmid13/results/plasmid13-mutserver-del.txt"});
        mutserver.start();
        System.out.println("");
        System.out.println("*****************************************************");
        mutserver = new CalcPrecisionLPA(new String[]{"--gold", "test-data/dna/plasmids/mixtures/gold/gold.txt", "--in", "test-data/dna/plasmids/mixtures/results/variants_plasmid_5104_NOBAQ.txt"});
        mutserver.start();
        System.out.println("*****************************************************");
        mutserver = new CalcPrecisionLPA(new String[]{"--gold", "test-data/dna/plasmids/mixtures/gold/gold.txt", "--in", "test-data/dna/plasmids/mixtures/results/variants_plasmid_5104_BAQ.txt"});
        mutserver.start();
    }
}

