/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tools;

import genepi.base.Tool;
import genepi.io.table.reader.CsvTableReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TreeSet;

public class CalcPrecision
extends Tool {
    NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
    DecimalFormat df = (DecimalFormat)this.nf;

    public CalcPrecision(String[] args) {
        super(args);
    }

    @Override
    public void createParameters() {
        this.addParameter("gold", "expected positions");
        this.addParameter("in", "input csv file");
        this.addParameter("length", "length of genome/locus", 1);
        this.addParameter("level", "heteroplasmy level applied", 4);
    }

    @Override
    public void init() {
        System.out.println("Precision Calculator");
    }

    @Override
    public int run() {
        String pos = "Pos";
        String sampleId = "ID";
        String variantlevel = "VariantLevel";
        TreeSet<Integer> allPos = new TreeSet<Integer>();
        TreeSet<Integer> goldPos = new TreeSet<Integer>();
        TreeSet<Integer> falsePositives = new TreeSet<Integer>();
        TreeSet<Integer> falseNegatives = new TreeSet<Integer>();
        TreeSet<Integer> both = new TreeSet<Integer>();
        String in = (String)this.getValue("in");
        String gold = (String)this.getValue("gold");
        int length = (Integer)this.getValue("length");
        double level = (Double)this.getValue("level");
        CsvTableReader idReader = new CsvTableReader(in, '\t');
        FileWriter writePerformance = null;
        try {
            writePerformance = new FileWriter(String.valueOf(in) + "_perform.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TreeSet<String> ids = new TreeSet<String>();
        while (idReader.next()) {
            ids.add(idReader.getString("ID"));
        }
        idReader.close();
        System.out.println("SampleID\tFound\tTotal\tFalsePosN\tFalsePosSNPs\tFalseNeg\tFalseNegSNP\tPrecision\tSensitivity\tSpecificity\tIgnored\tIgnoredSNPs");
        try {
            writePerformance.write("SampleID\tFound\tTotal\tFalsePos\tFalsePosSNPs\tFalseNeg\tFalseNegSNP\tPrecision\tSensitivity\tSpecificity\tIgnored\tIgnoredSNPs\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String id : ids) {
            CsvTableReader goldReader = new CsvTableReader(gold, '\t');
            while (goldReader.next()) {
                if (!(goldReader.getDouble("VariantLevel") >= level)) continue;
                goldPos.add(goldReader.getInteger("Pos"));
                allPos.add(goldReader.getInteger("Pos"));
            }
            CsvTableReader variantReader = new CsvTableReader(in, '\t');
            falsePositives.clear();
            falseNegatives.clear();
            both.clear();
            int truePositiveCount = 0;
            int falsePositiveCount = 0;
            int trueNegativeCount = 0;
            int falseNegativeCount = 0;
            String level2low = "";
            int level2lowCount = 0;
            while (variantReader.next()) {
                String idSample = variantReader.getString("ID");
                int posSample = variantReader.getInteger("Pos");
                double variantlevSample = variantReader.getDouble("VariantLevel");
                if (!id.equals(idSample)) continue;
                int position = posSample;
                if (variantlevSample >= level) {
                    if (goldPos.contains(position)) {
                        goldPos.remove(position);
                        ++truePositiveCount;
                        both.add(position);
                        continue;
                    }
                    falsePositives.add(position);
                    ++falsePositiveCount;
                    continue;
                }
                level2low = String.valueOf(level2low) + position + "(" + variantlevSample + ") ";
                ++level2lowCount;
            }
            int j = 1;
            while (j <= length) {
                if (!falsePositives.contains(j) && !both.contains(j)) {
                    if (!allPos.contains(j)) {
                        ++trueNegativeCount;
                    } else {
                        ++falseNegativeCount;
                        falseNegatives.add(j);
                    }
                }
                ++j;
            }
            variantReader.close();
            double sens2 = (double)truePositiveCount / (double)(truePositiveCount + falseNegativeCount) * 100.0;
            double spec2 = (double)trueNegativeCount / (double)(falsePositiveCount + trueNegativeCount) * 100.0;
            double prec2 = (double)truePositiveCount / (double)(truePositiveCount + falsePositiveCount) * 100.0;
            this.df.setMinimumFractionDigits(2);
            this.df.setMaximumFractionDigits(3);
            String sens = this.df.format(sens2);
            String spec = this.df.format(spec2);
            String prec = this.df.format(prec2);
            System.out.println(String.valueOf(id) + "\t" + truePositiveCount + "\t " + (truePositiveCount + falseNegativeCount) + "\t" + falsePositiveCount + "\t" + " " + "\t" + falseNegativeCount + "\t" + " " + "\t" + prec + "\t" + sens + "\t" + spec + "\t" + level2lowCount + " [" + " " + "]");
            try {
                writePerformance.write(String.valueOf(id) + "\t" + truePositiveCount + "\t " + (truePositiveCount + falseNegativeCount) + "\t" + falsePositiveCount + "\t" + ((Object)falsePositives).toString() + "\t" + falseNegativeCount + "\t" + ((Object)falseNegatives).toString() + "\t" + prec + "\t" + sens + "\t" + spec + "\t" + level2lowCount + "\t[" + level2low + "]\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            writePerformance.flush();
            writePerformance.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] args) {
        String gold = "test-data/mtdna/raw-results/sanger.txt";
        String in = "test-data/tmp/file.txt";
        String length = "16569";
        CalcPrecision precison = new CalcPrecision(new String[]{"--gold", gold, "--in", in, "--length", length});
        precison.start();
    }
}

