/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tools;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import lukfor.tables.Table;
import lukfor.tables.columns.IBuildValueFunction;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.Row;
import picocli.CommandLine;

@CommandLine.Command(name="annotate", description={"Annotate your mutserve variant file."})
public class AnnotationCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--input"}, description={"Input"}, required=true)
    private String input;
    @CommandLine.Option(names={"--output"}, description={"Output"}, required=true)
    private String output;
    @CommandLine.Option(names={"--annotation"}, description={"Annotation File"}, required=true)
    private String annotation;

    @Override
    public Integer call() throws Exception {
        Table.disableLog();
        File inputFile = new File(this.input);
        if (!inputFile.exists()) {
            System.out.println("Input file '" + inputFile.getAbsolutePath() + "' not found.");
            return 1;
        }
        File annotationFile = new File(this.annotation);
        if (!annotationFile.exists()) {
            System.out.println("Annotation file '" + annotationFile.getAbsolutePath() + "' not found.");
            return 1;
        }
        Table inputTable = TableBuilder.fromCsvFile(this.input).withColumnTypeDetection(false).withSeparator('\t').load();
        if (inputTable.getColumn("Pos") == null) {
            System.out.println("Missing column 'Pos' in input file '" + inputFile.getAbsolutePath() + "'.");
            return 1;
        }
        if (inputTable.getColumn("Variant") == null) {
            System.out.println("Missing column 'Variant' in input file '" + inputFile.getAbsolutePath() + "'.");
            return 1;
        }
        inputTable.getColumns().append(new StringColumn("Mutation"), new IBuildValueFunction(){

            @Override
            public String buildValue(Row row) throws IOException {
                return String.valueOf(row.getString("Pos")) + row.getString("Variant");
            }
        });
        Table annotationTable = TableBuilder.fromCsvFile(this.annotation).withColumnTypeDetection(false).withSeparator('\t').load();
        if (annotationTable.getColumn("Mutation") == null) {
            System.out.println("Missing column 'Mutation' in annotation file '" + annotationFile.getAbsolutePath() + "'.");
            return 1;
        }
        inputTable.merge(annotationTable, "Mutation");
        TableWriter.writeToCsv(inputTable, this.output, '\t');
        System.out.println("Results written to file '" + this.output + "'.");
        return 0;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

