/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tasks;

import genepi.io.text.LineWriter;
import genepi.mut.objects.BasePosition;
import genepi.mut.objects.VariantLine;
import genepi.mut.objects.VariantResult;
import genepi.mut.pileup.BamAnalyser;
import genepi.mut.util.VariantCaller;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class VariantCallingTask
implements ITaskRunnable {
    private String input;
    private String varName;
    private String rawName;
    private HashMap<String, Double> freqFile;
    private double level;
    private int baseQ = 20;
    private int mapQ = 20;
    private int alignQ = 30;
    boolean baq = true;
    boolean deletions = false;
    boolean insertions = false;
    String reference;
    String mode = "mtdna";
    String contig;

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(ITaskMonitor monitor) throws Exception {
        reader = null;
        name = null;
        if (this.input.startsWith("http://") || this.input.startsWith("ftp://")) {
            reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(SamInputResource.of(new URL(this.input)));
            name = new URL(this.input).getFile();
        } else {
            reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(SamInputResource.of(new File(this.input)));
            name = new File(this.input).getName();
        }
        monitor.begin(name);
        header = reader.getFileHeader();
        seqDictionary = header.getSequenceDictionary();
        if (this.contig == null) {
            for (SAMSequenceRecord record : seqDictionary.getSequences()) {
                if (record.getSequenceLength() != 16569) continue;
                this.contig = record.getSequenceName();
            }
        }
        analyser = new BamAnalyser(name, this.reference, this.baseQ, this.mapQ, this.alignQ, this.baq, this.mode);
        positions = analyser.getCounts();
        writerRaw = null;
        if (this.rawName != null) {
            rawFile = new File(this.rawName);
            rawFile.deleteOnExit();
            writerRaw = new LineWriter(rawFile.getAbsolutePath());
        }
        varFile = new File(this.varName);
        varFile.deleteOnExit();
        writerVar = new LineWriter(varFile.getAbsolutePath());
        reference = analyser.getReferenceString();
        index = 1;
        reads = null;
        try {
            reads = reader.query(this.contig, 0, 0, false);
            if (true) ** GOTO lbl49
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            throw new Exception(e.getMessage());
        }
        do {
            if (monitor.isCanceled()) {
                return;
            }
            record = (SAMRecord)reads.next();
            analyser.analyseRead(record, this.deletions, this.insertions);
            recordStart = record.getStart();
            while (index < recordStart) {
                if (positions.containsKey(index) && index <= reference.length()) {
                    this.callVariant(writerRaw, writerVar, name, this.level, index, positions.get(index), reference, this.freqFile);
                }
                positions.remove(index);
                ++index;
            }
lbl49:
            // 2 sources

        } while (reads.hasNext());
        while (index <= reference.length()) {
            if (positions.containsKey(index) && index <= reference.length()) {
                this.callVariant(writerRaw, writerVar, name, this.level, index, positions.get(index), reference, this.freqFile);
            }
            positions.remove(index);
            ++index;
        }
        positions = null;
        reader.close();
        monitor.done();
        writerVar.write("");
        writerVar.close();
        if (writerRaw != null) {
            writerRaw.close();
        }
    }

    private void callVariant(LineWriter writerRaw, LineWriter writerVar, String id, double level, int pos, BasePosition basePosition, String reference, HashMap<String, Double> freqFile) throws IOException {
        VariantResult varResult;
        basePosition.setId(id);
        basePosition.setPos(pos);
        VariantLine line = new VariantLine();
        char ref = reference.charAt(pos - 1);
        line.setRef(ref);
        line.parseLine(basePosition, level, freqFile);
        boolean isHeteroplasmy = false;
        for (char base : line.getMinors()) {
            double llrRev;
            double llrFwd;
            double minorPercentageRev;
            double minorPercentageFwd = VariantCaller.getMinorPercentageFwd(line, base);
            VariantResult varResult2 = VariantCaller.determineLowLevelVariant(line, minorPercentageFwd, minorPercentageRev = VariantCaller.getMinorPercentageRev(line, base), llrFwd = VariantCaller.determineLlrFwd(line, base), llrRev = VariantCaller.determineLlrRev(line, base), level, base);
            if (varResult2.getType() != VariantCaller.LOW_LEVEL_VARIANT) continue;
            isHeteroplasmy = true;
            varResult2.setMinor(base);
            double hetLevel = VariantCaller.calcVariantLevel(line, minorPercentageFwd, minorPercentageRev);
            double levelTop = VariantCaller.calcLevel(line, line.getTopBasePercentsFWD(), line.getTopBasePercentsREV());
            double levelMinor = VariantCaller.calcLevel(line, minorPercentageFwd, minorPercentageRev);
            varResult2.setLevelTop(levelTop);
            varResult2.setLevelMinor(levelMinor);
            varResult2.setLevel(hetLevel);
            String res = VariantCaller.writeVariant(varResult2);
            writerVar.write(res);
        }
        if (!isHeteroplasmy && (varResult = VariantCaller.determineVariants(line)) != null) {
            String res = VariantCaller.writeVariant(varResult);
            writerVar.write(res);
        }
        if (writerRaw != null) {
            String raw = line.toRawString();
            writerRaw.write(raw);
        }
    }

    public double getLevel() {
        return this.level;
    }

    public void setLevel(double level) {
        this.level = level;
    }

    public int getBaseQ() {
        return this.baseQ;
    }

    public void setBaseQ(int baseQ) {
        this.baseQ = baseQ;
    }

    public double getMapQ() {
        return this.mapQ;
    }

    public void setMapQ(int mapQ) {
        this.mapQ = mapQ;
    }

    public double getAlignQ() {
        return this.alignQ;
    }

    public void setAlignQ(int alignQ) {
        this.alignQ = alignQ;
    }

    public boolean isBaq() {
        return this.baq;
    }

    public void setBaq(boolean baq) {
        this.baq = baq;
    }

    public boolean isDeletions() {
        return this.deletions;
    }

    public void setDeletions(boolean deletions) {
        this.deletions = deletions;
    }

    public boolean isInsertions() {
        return this.insertions;
    }

    public void setInsertions(boolean insertions) {
        this.insertions = insertions;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public HashMap<String, Double> getFreqFile() {
        return this.freqFile;
    }

    public void setFreqFile(HashMap<String, Double> freqFile) {
        this.freqFile = freqFile;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getRawName() {
        return this.rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }

    public String getContig() {
        return this.contig;
    }

    public void setContig(String contig) {
        this.contig = contig;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }
}

