/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.tasks;

import genepi.io.text.LineWriter;
import genepi.mut.tasks.VariantCallingTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;
import org.apache.commons.io.IOUtils;

public class MergeTask
implements ITaskRunnable {
    private File[] variantInputs;
    private File[] rawInputs;
    private String rawPath;
    private String variantPath;

    public void setInputs(List<VariantCallingTask> tasks) {
        VariantCallingTask task;
        this.variantInputs = new File[tasks.size()];
        this.rawInputs = new File[tasks.size()];
        int i = 0;
        while (i < this.variantInputs.length) {
            task = tasks.get(i);
            this.variantInputs[i] = new File(task.getVarName());
            ++i;
        }
        if (this.rawPath != null) {
            i = 0;
            while (i < this.rawInputs.length) {
                task = tasks.get(i);
                this.rawInputs[i] = new File(task.getRawName());
                ++i;
            }
        }
    }

    @Override
    public void run(ITaskMonitor monitor) throws Exception {
        try {
            monitor.begin("Merge output files");
            assert (this.variantInputs != null);
            assert (this.variantInputs.length > 0);
            new File(this.variantPath).delete();
            LineWriter writerVar = new LineWriter(this.variantPath);
            writerVar.write("ID\tPos\tRef\tVariant\tVariantLevel\tMajorBase\tMajorLevel\tMinorBase\tMinorLevel\tCoverage\tCoverageFWD\tCoverageREV\tType\n");
            writerVar.close();
            MergeTask.appendFiles(new File(this.variantPath), this.variantInputs);
            if (this.rawPath != null) {
                new File(this.rawPath).delete();
                LineWriter writerRaw = new LineWriter(this.rawPath);
                writerRaw.write("SAMPLE\tPOS\tREF\tTOP-FWD\tMINOR-FWD\tTOP-REV\tMINOR-REV\tCOV-FWD\tCOV-REV\tCOV-TOTAL\tTYPE\tLEVEL\t%A\t%C\t%G\t%T\t%D\t%N\t%a\t%c\t%g\t%t\t%d\t%n\tTOP-FWD-PERCENT\tTOP-REV-PERCENT\tMINOR-FWD-PERCENT\tMINOR-REV-PERCENT\tLLRFWD\tLLRREV\tLLRAFWD\tLLRCFWD\tLLRGFWD\tLLRTFWD\tLLRAREV\tLLRCREV\tLLRGREV\tLLRTREV\tLLRDFWD\tLLRDREV\tMINORS\n");
                writerRaw.close();
                MergeTask.appendFiles(new File(this.rawPath), this.rawInputs);
            }
            monitor.done();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendFiles(File destination, File[] sources) throws IOException {
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(destination, true));
            File[] fileArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                File source = fileArray[n2];
                MergeTask.appendFile(output, source);
                source.delete();
                ++n2;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
    }

    private static void appendFile(OutputStream output, File source) throws IOException {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(source));
            IOUtils.copy((InputStream)input, output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    public String getVariantPath() {
        return this.variantPath;
    }

    public void setVariantPath(String variantPath) {
        this.variantPath = variantPath;
    }
}

