/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.stats;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.writer.CsvTableWriter;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class CreateStatistics {
    private String input;
    private String output;

    public CreateStatistics(String input, String output) {
        this.input = input;
        this.output = output;
    }

    public boolean createSampleStatistics() {
        File file = new File(this.input);
        CsvTableReader reader = new CsvTableReader(file.getAbsolutePath(), '\t');
        CsvTableWriter writer = new CsvTableWriter(this.output, ',', true);
        writer.setColumns(new String[]{"SampleID", "Mean-Coverage", "SD-Coverage", "Min-Coverage", "Max-Coverage"});
        String sample = null;
        ArrayList<Double> positions = new ArrayList<Double>();
        while (reader.next()) {
            if (!reader.getString(0).equals(sample) && sample != null) {
                DescriptiveStatistics statistics = this.calcStats(positions);
                writer.setString(0, sample);
                writer.setDouble(1, statistics.getMean());
                writer.setDouble(2, statistics.getStandardDeviation());
                writer.setDouble(3, statistics.getMin());
                writer.setDouble(4, statistics.getMax());
                writer.next();
                positions = new ArrayList();
            }
            double posCov = Double.valueOf(reader.getRow()[reader.getColumnIndex("COV-FWD")]) + Double.valueOf(reader.getRow()[reader.getColumnIndex("COV-REV")]);
            positions.add(posCov);
            sample = reader.getString(0);
        }
        DescriptiveStatistics statistics = this.calcStats(positions);
        writer.setString(0, sample);
        writer.setDouble(1, statistics.getMean());
        writer.setDouble(2, statistics.getStandardDeviation());
        writer.setDouble(3, statistics.getMin());
        writer.setDouble(4, statistics.getMax());
        writer.next();
        reader.close();
        writer.close();
        return true;
    }

    private DescriptiveStatistics calcStats(ArrayList<Double> positions) {
        Double[] statArray = new Double[positions.size()];
        statArray = positions.toArray(statArray);
        DescriptiveStatistics statistics = new DescriptiveStatistics(ArrayUtils.toPrimitive(statArray));
        return statistics;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

