/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.sort;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.common.WorkflowContext;
import genepi.mut.objects.Extracter;
import genepi.mut.sort.SortJob;
import genepi.mut.util.HadoopJobStep;
import genepi.mut.util.ReferenceUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SortStep
extends HadoopJobStep {
    @Override
    public boolean run(WorkflowContext context) {
        try {
            boolean result = true;
            String input = context.get("bwaOut");
            String output = context.get("outputBam");
            String inType = context.get("inType");
            String archive = context.get("archive");
            if (inType.equals("se") || inType.equals("pe")) {
                List<String> folders = HdfsUtil.getDirectories(input);
                String[] inputs = new String[folders.size()];
                int i = 0;
                while (i < folders.size()) {
                    inputs[i] = folders.get(i);
                    ++i;
                }
                String folder = archive.substring(0, archive.lastIndexOf("/") + 1);
                Extracter.extract(archive, folder);
                String ref = ReferenceUtil.findFileinDir(new File(folder), "fasta");
                String reference = ReferenceUtil.readInReference(ref);
                SortJob sort = new SortJob("sort-reads");
                sort.setInput(inputs);
                sort.setRefLength(String.valueOf(reference.length()));
                sort.setOutput(output);
                result = this.executeHadoopJob(sort, context);
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

