/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.sort;

import genepi.hadoop.HdfsUtil;
import genepi.io.FileUtil;
import genepi.mut.objects.ReadKey;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class SortReducer
extends Reducer<ReadKey, Text, Text, Text> {
    private String output;
    SAMFileHeader header;
    String reflength;
    String length;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        HdfsUtil.setDefaultConfiguration(context.getConfiguration());
        this.output = context.getConfiguration().get("OUTPUT");
        this.header = new SAMFileHeader();
        this.length = context.getConfiguration().get("LN");
    }

    protected void reduce(ReadKey key, Iterable<Text> values, Reducer.Context context) {
        if (this.header.getSequence(key.getSequence()) == null) {
            this.header.addSequence(new SAMSequenceRecord(key.getSequence(), Integer.valueOf(this.length)));
        }
        String name = String.valueOf(key.getSample()) + "_" + key.getSequence() + ".bam";
        name = name.replaceAll(":", "_");
        SAMFileWriter bamWriter = new SAMFileWriterFactory().makeBAMWriter(this.header, true, new File(name));
        SAMLineParser parser = new SAMLineParser(this.header);
        int i = 0;
        for (Text value : values) {
            ++i;
            bamWriter.addAlignment(parser.parseLine(value.toString()));
        }
        bamWriter.close();
        HdfsUtil.put(name, HdfsUtil.path(this.output, name));
        FileUtil.deleteFile(name);
    }
}

