/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.sort;

import genepi.hadoop.HdfsUtil;
import genepi.mut.objects.ReadKey;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class SortMap
extends Mapper<Object, Text, ReadKey, Text> {
    private ReadKey outKey = new ReadKey();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        HdfsUtil.setDefaultConfiguration(context.getConfiguration());
    }

    public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        if (!value.toString().trim().equals("")) {
            String[] tilesValue = value.toString().split("\t", 2);
            String sample = tilesValue[0].replaceAll(".fastq", "").replaceAll(".fq", "");
            String[] tiles = tilesValue[1].split("\t");
            String readName = tiles[0].trim();
            String contig = tiles[2].trim();
            String start = tiles[3].trim();
            this.outKey.setSample(sample);
            this.outKey.setPosition(Integer.valueOf(start).intValue());
            this.outKey.setSequence(contig);
            this.outKey.setReadName(readName);
            context.write((Object)this.outKey, (Object)new Text(tilesValue[1]));
        }
    }
}

