/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;

public class ReadBamTest {
    public static void main(String[] args) {
        SamReader reader = SamReaderFactory.makeDefault().open(new File("test-data/mtdna/bam/input/HG00096.mapped.ILLUMINA.bwa.GBR.low_coverage.20101123.bam"));
        for (SAMRecord samRecord : reader) {
            if (!samRecord.getReadName().equals("SRR062635.20477607")) continue;
            Integer currentReferencePos = samRecord.getAlignmentStart();
            int currentPos = 0;
            for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                Integer cigarElementLength = cigarElement.getLength();
                if (cigarElement.getOperator() == CigarOperator.D) {
                    Integer cigarElementStart = currentReferencePos;
                    int i = 0;
                    while (i < cigarElementLength) {
                        ++i;
                    }
                    if (currentPos > 0) {
                        currentPos -= cigarElement.getLength();
                    }
                }
                if (cigarElement.getOperator() == CigarOperator.I) {
                    int i = 0;
                    while (i < cigarElementLength) {
                        char insBase = samRecord.getReadString().charAt(currentPos + i);
                        byte quality = samRecord.getBaseQualities()[currentPos + i];
                        ++i;
                    }
                    currentPos += cigarElement.getLength();
                }
                if (!cigarElement.getOperator().consumesReferenceBases() && cigarElement.getOperator() != CigarOperator.SOFT_CLIP) continue;
                currentReferencePos = currentReferencePos + cigarElement.getLength();
                currentPos += cigarElement.getLength();
            }
            System.exit(0);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

