/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import genepi.base.Tool;
import genepi.io.text.LineWriter;
import genepi.mut.objects.BasePosition;
import genepi.mut.objects.BayesFrequencies;
import genepi.mut.objects.VariantLine;
import genepi.mut.objects.VariantResult;
import genepi.mut.pileup.BamAnalyser;
import genepi.mut.util.FastaWriter;
import genepi.mut.util.VariantCaller;
import genepi.mut.util.VcfWriter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

public class PileupToolLocal
extends Tool {
    String version = "v1.3.4";
    String mode = "mtdna";
    String command;

    public PileupToolLocal(String[] args) {
        super(args);
        this.command = Arrays.toString(args);
        System.out.println("Command " + this.command);
    }

    @Override
    public void createParameters() {
        this.addParameter("input", "input cram/bam file or folder", 2);
        this.addParameter("output", "output file", 2);
        this.addOptionalParameter("level", "detection level", 2);
        this.addParameter("reference", "reference as fasta", 2);
        this.addOptionalParameter("baseQ", "base quality", 2);
        this.addOptionalParameter("mapQ", "mapping quality", 2);
        this.addOptionalParameter("alignQ", "alignment quality", 2);
        this.addFlag("noBaq", "turn off BAQ");
        this.addFlag("noFreq", "turn off 1000G frequency file");
        this.addFlag("deletions", "Call deletions");
        this.addFlag("insertions", "Call insertions (beta)");
        this.addFlag("writeFasta", "Write fasta");
    }

    @Override
    public void init() {
        System.out.println("mtDNA Low-frequency Variant Detection " + this.version);
        System.out.println("Division of Genetic Epidemiology - Medical University of Innsbruck");
        System.out.println("(c) Sebastian Schoenherr, Hansi Weissensteiner, Lukas Forer");
        System.out.println("");
    }

    @Override
    public int run() {
        File[] files;
        String input = (String)this.getValue("input");
        String output = (String)this.getValue("output");
        boolean baq = !this.isFlagSet("noBaq");
        boolean freq = !this.isFlagSet("noFreq");
        boolean deletions = this.isFlagSet("deletions");
        boolean insertions = this.isFlagSet("insertions");
        boolean writeFasta = this.isFlagSet("writeFasta");
        double level = this.getValue("level") == null ? 0.01 : Double.parseDouble((String)this.getValue("level"));
        int baseQ = this.getValue("baseQ") == null ? 20 : Integer.parseInt((String)this.getValue("baseQ"));
        int mapQ = this.getValue("mapQ") == null ? 20 : Integer.parseInt((String)this.getValue("mapQ"));
        int alignQ = this.getValue("alignQ") == null ? 30 : Integer.parseInt((String)this.getValue("alignQ"));
        String refPath = (String)this.getValue("reference");
        LineWriter writerRaw = null;
        LineWriter writerVar = null;
        File folderIn = new File(input);
        if (folderIn.exists()) {
            if (folderIn.isFile()) {
                files = new File[]{new File(folderIn.getAbsolutePath())};
                if (!files[0].getName().toLowerCase().endsWith(".cram") && !files[0].getName().toLowerCase().endsWith(".bam")) {
                    System.out.println("Please upload a CRAM/BAM file");
                    return 1;
                }
            } else {
                files = folderIn.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".bam") || name.toLowerCase().endsWith(".cram");
                    }
                });
            }
        } else {
            System.out.println("Please check input path!");
            return 1;
        }
        if (files.length > 0) {
            File out = new File(output);
            if (out.isDirectory()) {
                System.out.println("Error. Please specify an output file not a directory");
                return 1;
            }
            String prefix = output;
            if (output.contains(".")) {
                prefix = output.substring(0, output.indexOf(46));
            }
            String varFile = String.valueOf(prefix) + ".txt";
            String rawFile = String.valueOf(prefix) + "_raw.txt";
            try {
                writerVar = new LineWriter(new File(varFile).getAbsolutePath());
                writerVar.write("ID\tPos\tRef\tVariant\tVariantLevel\tMajorBase\tMajorLevel\tMinorBase\tMinorLevel\tCoverage\tCoverageFWD\tCoverageREV\tType");
                writerRaw = new LineWriter(new File(rawFile).getAbsolutePath());
                writerRaw.write("SAMPLE\tPOS\tREF\tTOP-FWD\tMINOR-FWD\tTOP-REV\tMINOR-REV\tCOV-FWD\tCOV-REV\tCOV-TOTAL\tTYPE\tLEVEL\t%A\t%C\t%G\t%T\t%D\t%N\t%a\t%c\t%g\t%t\t%d\t%n\tTOP-FWD-PERCENT\tTOP-REV-PERCENT\tMINOR-FWD-PERCENT\tMINOR-REV-PERCENT\tLLRFWD\tLLRREV\tLLRAFWD\tLLRCFWD\tLLRGFWD\tLLRTFWD\tLLRAREV\tLLRCREV\tLLRGREV\tLLRTREV\tLLRDFWD\tLLRDREV\tMINORS");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            long start = System.currentTimeMillis();
            System.out.println("Parameters:");
            System.out.println("Input: " + new File(input).getAbsolutePath());
            System.out.println("Output: " + new File(output).getAbsolutePath());
            System.out.println("Detection limit: " + level);
            System.out.println("Base Quality: " + baseQ);
            System.out.println("Map Quality: " + mapQ);
            System.out.println("Alignment Quality: " + alignQ);
            System.out.println("BAQ: " + baq);
            System.out.println("1000G Frequency File: " + freq);
            System.out.println("Deletions: " + deletions);
            System.out.println("Insertions: " + insertions);
            System.out.println("Fasta: " + writeFasta);
            System.out.println("");
            HashMap<String, Double> freqFile = null;
            if (freq) {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("1000g.frq");
                freqFile = BayesFrequencies.instance(new DataInputStream(in));
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                BamAnalyser analyser = new BamAnalyser(file.getName(), refPath, baseQ, mapQ, alignQ, baq, this.mode);
                System.out.println("Processing: " + file.getName());
                try {
                    this.analyseReads(file, analyser, deletions, insertions);
                    this.determineVariants(analyser, writerRaw, writerVar, level, freqFile, file.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1;
                }
                ++n2;
            }
            try {
                writerVar.close();
                if (writerRaw != null) {
                    writerRaw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (output.endsWith("vcf.gz") || output.endsWith("vcf")) {
                VcfWriter writer = new VcfWriter();
                writer.createVCF(varFile, output, refPath, "chrM", 16569, String.valueOf(this.version) + ";" + this.command);
            }
            if (writeFasta) {
                FastaWriter writer2 = new FastaWriter();
                writer2.createFasta(varFile, String.valueOf(prefix) + ".fasta", refPath);
            }
            System.out.println("Time: " + (System.currentTimeMillis() - start) / 1000L + " sec");
            return 0;
        }
        System.out.println("No files found.");
        return 0;
    }

    private void analyseReads(File file, BamAnalyser analyser, boolean deletions, boolean insertions) throws Exception {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(file);
        for (SAMRecord record : reader) {
            analyser.analyseRead(record, deletions, insertions);
        }
        reader.close();
    }

    private void determineVariants(BamAnalyser analyser, LineWriter writerRaw, LineWriter writerVariants, double level, HashMap<String, Double> freqFile, String filename) throws IOException {
        HashMap<Integer, BasePosition> counts = analyser.getCounts();
        String reference = analyser.getReferenceString();
        for (Integer key : counts.keySet()) {
            VariantResult varResult;
            boolean insertion = false;
            int pos = key;
            if (pos <= 0 || pos > reference.length()) continue;
            char ref = 'N';
            BasePosition basePos = counts.get(key);
            basePos.setId(filename);
            basePos.setPos(pos);
            VariantLine line = new VariantLine();
            ref = reference.charAt(pos - 1);
            line.setRef(ref);
            line.parseLine(basePos, level, freqFile);
            boolean isHeteroplasmy = false;
            for (char base : line.getMinors()) {
                double llrRev;
                double llrFwd;
                double minorPercentageRev;
                double minorPercentageFwd = VariantCaller.getMinorPercentageFwd(line, base);
                VariantResult varResult2 = VariantCaller.determineLowLevelVariant(line, minorPercentageFwd, minorPercentageRev = VariantCaller.getMinorPercentageRev(line, base), llrFwd = VariantCaller.determineLlrFwd(line, base), llrRev = VariantCaller.determineLlrRev(line, base), level, base);
                if (varResult2.getType() != VariantCaller.LOW_LEVEL_VARIANT) continue;
                isHeteroplasmy = true;
                varResult2.setMinor(base);
                double hetLevel = VariantCaller.calcVariantLevel(line, minorPercentageFwd, minorPercentageRev);
                double levelTop = VariantCaller.calcLevel(line, line.getTopBasePercentsFWD(), line.getTopBasePercentsREV());
                double levelMinor = VariantCaller.calcLevel(line, minorPercentageFwd, minorPercentageRev);
                varResult2.setLevelTop(levelTop);
                varResult2.setLevelMinor(levelMinor);
                varResult2.setLevel(hetLevel);
                String res = VariantCaller.writeVariant(varResult2);
                writerVariants.write(res);
            }
            if (!isHeteroplasmy && (varResult = VariantCaller.determineVariants(line)) != null) {
                String res = VariantCaller.writeVariant(varResult);
                writerVariants.write(res);
            }
            if (writerRaw == null) continue;
            String raw = line.toRawString();
            writerRaw.write(raw);
        }
    }

    public static void main(String[] args) {
        String input = "test-data/mtdna/bam/input/small.bam";
        String output = "/home/seb/Desktop/test_old.txt";
        String ref = "test-data/mtdna/reference/rCRS.fasta";
        PileupToolLocal pileup = new PileupToolLocal(new String[]{"--input", input, "--reference", ref, "--output", output, "--level", "0.01", "--noBaq", "--noFreq"});
        pileup.start();
    }
}

