/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import genepi.hadoop.CacheStore;
import genepi.hadoop.HdfsUtil;
import genepi.hadoop.io.HdfsLineWriter;
import genepi.mut.objects.BasePosition;
import genepi.mut.objects.BasePositionHadoop;
import genepi.mut.objects.VariantLine;
import genepi.mut.objects.VariantResult;
import genepi.mut.util.ReferenceUtil;
import genepi.mut.util.VariantCaller;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PileupReducer
extends Reducer<Text, BasePositionHadoop, Text, Text> {
    private BasePosition basePos = new BasePosition();
    String reference;
    String freqFile;
    String hdfsVariants;
    HdfsLineWriter writer;
    double level;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        HdfsUtil.setDefaultConfiguration(context.getConfiguration());
        CacheStore cache = new CacheStore(context.getConfiguration());
        File referencePath = new File(cache.getArchive("reference"));
        String fastaPath = ReferenceUtil.findFileinDir(referencePath, ".fasta");
        this.freqFile = ReferenceUtil.findFileinDir(referencePath, ".frq");
        this.reference = ReferenceUtil.readInReference(fastaPath);
        this.level = context.getConfiguration().getDouble("level", 0.01);
        this.hdfsVariants = context.getConfiguration().get("variantsHdfs");
        HdfsUtil.create(String.valueOf(this.hdfsVariants) + "/" + context.getTaskAttemptID());
        this.writer = new HdfsLineWriter(String.valueOf(this.hdfsVariants) + "/" + context.getTaskAttemptID());
    }

    protected void reduce(Text key, Iterable<BasePositionHadoop> values, Reducer.Context context) throws IOException, InterruptedException {
        int pos;
        this.basePos.clear();
        ArrayList<Byte> combinedAFor = new ArrayList<Byte>();
        ArrayList<Byte> combinedCFor = new ArrayList<Byte>();
        ArrayList<Byte> combinedGFor = new ArrayList<Byte>();
        ArrayList<Byte> combinedTFor = new ArrayList<Byte>();
        ArrayList<Byte> combinedDFor = new ArrayList<Byte>();
        ArrayList<Byte> combinedARev = new ArrayList<Byte>();
        ArrayList<Byte> combinedCRev = new ArrayList<Byte>();
        ArrayList<Byte> combinedGRev = new ArrayList<Byte>();
        ArrayList<Byte> combinedTRev = new ArrayList<Byte>();
        ArrayList<Byte> combinedDRev = new ArrayList<Byte>();
        for (BasePositionHadoop valueHadoop : values) {
            BasePosition value = valueHadoop.getBasePosition();
            this.basePos.add(value);
            combinedAFor.addAll(value.getaForQ());
            combinedCFor.addAll(value.getcForQ());
            combinedGFor.addAll(value.getgForQ());
            combinedTFor.addAll(value.gettForQ());
            combinedDFor.addAll(value.getdForQ());
            combinedARev.addAll(value.getaRevQ());
            combinedCRev.addAll(value.getcRevQ());
            combinedGRev.addAll(value.getgRevQ());
            combinedTRev.addAll(value.gettRevQ());
            combinedDRev.addAll(value.getdRevQ());
        }
        this.basePos.setaForQ(combinedAFor);
        this.basePos.setcForQ(combinedCFor);
        this.basePos.setgForQ(combinedGFor);
        this.basePos.settForQ(combinedTFor);
        this.basePos.setdForQ(combinedDFor);
        this.basePos.setaRevQ(combinedARev);
        this.basePos.setcRevQ(combinedCRev);
        this.basePos.setgRevQ(combinedGRev);
        this.basePos.settRevQ(combinedTRev);
        this.basePos.setdRevQ(combinedDRev);
        this.basePos.setId(key.toString().split(":")[0]);
        String positionKey = key.toString().split(":")[1];
        boolean insertion = false;
        if (positionKey.contains(".")) {
            pos = Integer.valueOf(positionKey.split("\\.")[0]);
            insertion = true;
        } else {
            pos = Integer.valueOf(positionKey);
        }
        this.basePos.setPos(pos);
        if (pos > 0 && pos <= this.reference.length()) {
            VariantResult varResult;
            char ref = 'N';
            VariantLine line = new VariantLine();
            if (!insertion) {
                ref = this.reference.charAt(pos - 1);
            } else {
                ref = '-';
                line.setInsPosition(positionKey);
                line.setInsertion(true);
            }
            line.setRef(ref);
            line.parseLine(this.basePos, this.level, null);
            boolean isHeteroplasmy = false;
            for (char base : line.getMinors()) {
                double llrRev;
                double llrFwd;
                double minorREV;
                double minorFWD = VariantCaller.getMinorPercentageFwd(line, base);
                VariantResult varResult2 = VariantCaller.determineLowLevelVariant(line, minorFWD, minorREV = VariantCaller.getMinorPercentageRev(line, base), llrFwd = VariantCaller.determineLlrFwd(line, base), llrRev = VariantCaller.determineLlrRev(line, base), this.level, base);
                if (varResult2.getType() != VariantCaller.LOW_LEVEL_VARIANT) continue;
                isHeteroplasmy = true;
                varResult2.setMinor(base);
                double hetLevel = VariantCaller.calcVariantLevel(line, minorFWD, minorREV);
                double levelTop = VariantCaller.calcLevel(line, line.getTopBasePercentsFWD(), line.getTopBasePercentsREV());
                double levelMinor = VariantCaller.calcLevel(line, minorFWD, minorREV);
                varResult2.setLevelTop(levelTop);
                varResult2.setLevelMinor(levelMinor);
                varResult2.setLevel(hetLevel);
                String res = VariantCaller.writeVariant(varResult2);
                this.writer.write(res);
            }
            if (!isHeteroplasmy && (varResult = VariantCaller.determineVariants(line)) != null) {
                String res = VariantCaller.writeVariant(varResult);
                this.writer.write(res);
            }
            context.write(null, (Object)new Text(line.toRawString()));
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.writer.close();
    }
}

