/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import genepi.hadoop.CacheStore;
import genepi.hadoop.PreferenceStore;
import genepi.mut.objects.BasePosition;
import genepi.mut.objects.BasePositionHadoop;
import genepi.mut.pileup.BamAnalyser;
import genepi.mut.util.ReferenceUtil;
import htsjdk.samtools.SAMRecord;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class PileupMapper
extends Mapper<LongWritable, SAMRecordWritable, Text, BasePositionHadoop> {
    BamAnalyser analyser;
    String filename;
    int mapQual;
    int alignQual;
    int minCoverage;
    boolean deletions;
    boolean insertions;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.filename = context.getInputSplit().getClass().equals(FileVirtualSplit.class) ? ((FileVirtualSplit)context.getInputSplit()).getPath().getName().replace(".bam", "") : ((FileSplit)context.getInputSplit()).getPath().getName().replace(".bam", "").replace(".sam", "").replace(".cram", "");
        this.filename = this.filename.replaceAll("\\W+", "_");
        CacheStore cache = new CacheStore(context.getConfiguration());
        PreferenceStore store = new PreferenceStore(context.getConfiguration());
        String version = store.getString("server.version");
        int baseQual = context.getConfiguration().getInt("baseQual", 20);
        this.mapQual = context.getConfiguration().getInt("mapQual", 20);
        this.alignQual = context.getConfiguration().getInt("alignQual", 30);
        boolean baq = context.getConfiguration().getBoolean("baq", true);
        String refAsArchive = cache.getArchive("reference");
        File referencePath = new File(refAsArchive);
        String fastaPath = ReferenceUtil.findFileinDir(referencePath, ".fasta");
        this.analyser = new BamAnalyser(this.filename, fastaPath, baseQual, this.mapQual, this.alignQual, baq, version);
        this.deletions = context.getConfiguration().getBoolean("deletions", false);
        this.insertions = context.getConfiguration().getBoolean("insertions", false);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        BasePositionHadoop baseHadoop = new BasePositionHadoop();
        HashMap<Integer, BasePosition> counts = this.analyser.getCounts();
        Text outKey = new Text();
        for (int key : counts.keySet()) {
            BasePosition basePos = counts.get(key);
            outKey.set(String.valueOf(key));
            baseHadoop.setBasePosition(basePos);
            context.write((Object)outKey, (Object)baseHadoop);
        }
    }

    public void map(LongWritable key, SAMRecordWritable value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.countStats(context, value.get());
            this.analyser.analyseRead(value.get(), this.deletions, this.insertions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void countStats(Mapper.Context context, SAMRecord samRecord) throws Exception {
        context.getCounter("mtdna", "OVERALL-READS").increment(1L);
        if (samRecord.getMappingQuality() < this.mapQual) {
            context.getCounter("mtdna", "FILTERED").increment(1L);
            context.getCounter("mtdna", "BAD-MAPPING").increment(1L);
            return;
        }
        if (samRecord.getReadUnmappedFlag()) {
            context.getCounter("mtdna", "FILTERED").increment(1L);
            context.getCounter("mtdna", "UNMAPPED").increment(1L);
            return;
        }
        if (samRecord.getDuplicateReadFlag()) {
            context.getCounter("mtdna", "FILTERED").increment(1L);
            context.getCounter("mtdna", "DUPLICATE").increment(1L);
            return;
        }
        if (samRecord.getReadLength() <= 25) {
            context.getCounter("mtdna", "FILTERED").increment(1L);
            context.getCounter("mtdna", "SHORT-READ").increment(1L);
            return;
        }
        if (ReferenceUtil.getTagFromSamRecord(samRecord.getAttributes(), "AS") < this.alignQual) {
            context.getCounter("mtdna", "FILTERED").increment(1L);
            context.getCounter("mtdna", "BAD-ALIGNMENT").increment(1L);
            return;
        }
        context.getCounter("mtdna", "UNFILTERED").increment(1L);
    }

    static enum Counters {
        GOOD_MAPPING,
        BAD_MAPPING,
        BAD_QUALITY,
        GOOD_QUALITY,
        BAD_ALIGNMENT_SCORE,
        WRONG_REF,
        INVALID_READ,
        INVALID_FLAGS;

    }
}

