/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import genepi.hadoop.CacheStore;
import genepi.hadoop.HadoopJob;
import genepi.hadoop.HdfsUtil;
import genepi.mut.objects.BasePositionHadoop;
import genepi.mut.pileup.PileupCombiner;
import genepi.mut.pileup.PileupMapper;
import genepi.mut.pileup.PileupReducer;
import java.io.File;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;

public class PileupJob
extends HadoopJob {
    private String refArchive;
    private String folder;
    private String pathRawLocal;
    private String pathVariantsHDFS;
    private String pathVariantsLocal;
    private long overall;
    private long goodQual;
    private long goodMapping;
    private long badQual;
    private long badALigment;
    private long shortRead;
    private long dupl;
    private long unmapped;
    private long badMapping;
    private long wrongRef;
    private long filtered;
    private long unfiltered;
    private long fwdRead;
    private long revRead;

    public PileupJob(String name) {
        super(name);
        this.set("mapred.map.tasks.speculative.execution", false);
        this.set("mapred.reduce.tasks.speculative.execution", false);
        this.set("mapreduce.map.java.opts", "-Xmx4000M");
        this.set("mapred.child.java.opts", "-Xmx4000M");
        this.set("hadoopbam.samheaderreader.validation-stringency", "LENIENT");
    }

    @Override
    public void setupJob(Job job) {
        job.setInputFormatClass(AnySAMInputFormat.class);
        job.setMapperClass(PileupMapper.class);
        job.setCombinerClass(PileupCombiner.class);
        job.setReducerClass(PileupReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(BasePositionHadoop.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(TextOutputFormat.class);
    }

    @Override
    protected void setupDistributedCache(CacheStore cache) {
        String hdfsPathRef = HdfsUtil.path("/tmp/mutation-server-data", this.refArchive.substring(this.refArchive.lastIndexOf("/") + 1));
        if (!HdfsUtil.exists(hdfsPathRef)) {
            HdfsUtil.put(this.refArchive, hdfsPathRef);
        }
        this.log.info((Object)("Reference path is: " + hdfsPathRef));
        cache.addArchive("reference", hdfsPathRef);
    }

    @Override
    public void cleanupJob(Job job) {
        try {
            HdfsUtil.mergeFolderBinary(this.pathRawLocal, super.getOutput(), "SAMPLE\tPOS\tREF\tTOP-FWD\tMINOR-FWD\tTOP-REV\tMINOR-REV\tCOV-FWD\tCOV-REV\tCOV-TOTAL\tTYPE\tLEVEL\t%A\t%C\t%G\t%T\t%D\t%N\t%a\t%c\t%g\t%t\t%d\t%n\tTOP-FWD-PERCENT\tTOP-REV-PERCENT\tMINOR-FWD-PERCENT\tMINOR-REV-PERCENT\tLLRFWD\tLLRREV\tLLRAFWD\tLLRCFWD\tLLRGFWD\tLLRTFWD\tLLRAREV\tLLRCREV\tLLRGREV\tLLRTREV\tLLRDFWD\tLLRDREV\tMINORS");
            HdfsUtil.mergeFolderBinary(this.pathVariantsLocal, this.pathVariantsHDFS, "ID\tPos\tRef\tVariant\tVariantLevel\tMajorBase\tMajorLevel\tMinorBase\tMinorLevel\tCoverage\tCoverageFWD\tCoverageREV\tType");
            CounterGroup counters = (CounterGroup)job.getCounters().getGroup("mtdna");
            this.overall = counters.findCounter("OVERALL-READS").getValue();
            this.goodQual = counters.findCounter("GOOD-QUAL").getValue();
            this.badQual = counters.findCounter("BAD-QUAL").getValue();
            this.badALigment = counters.findCounter("BAD-ALIGNMENT").getValue();
            this.shortRead = counters.findCounter("SHORT-READ").getValue();
            this.dupl = counters.findCounter("DUPLICATE").getValue();
            this.unmapped = counters.findCounter("UNMAPPED").getValue();
            this.badMapping = counters.findCounter("BAD-MAPPING").getValue();
            this.wrongRef = counters.findCounter("WRONG-REF").getValue();
            this.goodMapping = counters.findCounter("GOOD-MAPPING").getValue();
            this.filtered = counters.findCounter("FILTERED").getValue();
            this.unfiltered = counters.findCounter("UNFILTERED").getValue();
            this.fwdRead = counters.findCounter("FWD-READ").getValue();
            this.revRead = counters.findCounter("REV-READ").getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOutput(String output) {
        super.setOutput(output);
    }

    public void setRawLocal(String localPath) {
        this.pathRawLocal = localPath;
    }

    public void setVariantsPathHdfs(String hdfsPath) {
        this.set("variantsHdfs", hdfsPath);
        this.pathVariantsHDFS = hdfsPath;
    }

    public void setVariantsPathLocal(String localPath) {
        this.pathVariantsLocal = localPath;
    }

    public void setMappingQuality(String mapQual) {
        this.set("mapQual", mapQual);
    }

    public void setMinCoverage(String minCoverage) {
        this.set("minCoverage", minCoverage);
    }

    public void setBaseQuality(String baseQual) {
        this.set("baseQual", baseQual);
    }

    public void setAlignmentQuality(String alignQual) {
        this.set("alignQual", alignQual);
    }

    public void setBAQ(boolean baq) {
        this.set("baq", baq);
    }

    public void setLevel(String level) {
        this.set("level", level);
    }

    public void setDeletions(boolean del) {
        this.set("deletions", del);
    }

    public void setInsertions(boolean ins) {
        this.set("insertions", ins);
    }

    public void setArchive(String refArchive) {
        this.refArchive = refArchive;
    }

    public long getGoodQual() {
        return this.goodQual;
    }

    public long getBadQual() {
        return this.badQual;
    }

    public long getBadALigment() {
        return this.badALigment;
    }

    public void setBadALigment(long badALigment) {
        this.badALigment = badALigment;
    }

    public long getShortRead() {
        return this.shortRead;
    }

    public long getFiltered() {
        return this.filtered;
    }

    public void setFiltered(long filtered) {
        this.filtered = filtered;
    }

    public long getUnfiltered() {
        return this.unfiltered;
    }

    public void setUnfiltered(long unfiltered) {
        this.unfiltered = unfiltered;
    }

    public void setShortRead(long shortRead) {
        this.shortRead = shortRead;
    }

    public long getDupl() {
        return this.dupl;
    }

    public void setDupl(long dupl) {
        this.dupl = dupl;
    }

    public long getUnmapped() {
        return this.unmapped;
    }

    public void setUnmapped(long unmapped) {
        this.unmapped = unmapped;
    }

    public long getBadMapping() {
        return this.badMapping;
    }

    public void setBadMapping(long badMapping) {
        this.badMapping = badMapping;
    }

    public long getWrongRef() {
        return this.wrongRef;
    }

    public void setWrongRef(long wrongRef) {
        this.wrongRef = wrongRef;
    }

    public void setGoodQual(long goodQual) {
        this.goodQual = goodQual;
    }

    public void setBadQual(long badQual) {
        this.badQual = badQual;
    }

    public long getOverall() {
        return this.overall;
    }

    public void setOverall(long overall) {
        this.overall = overall;
    }

    public void setGoodMapping(long goodMapping) {
        this.goodMapping = goodMapping;
    }

    private String getFolder(Class<PileupJob> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }

    public long getFwdRead() {
        return this.fwdRead;
    }

    public void setFwdRead(long fwdRead) {
        this.fwdRead = fwdRead;
    }

    public long getRevRead() {
        return this.revRead;
    }

    public void setRevRead(long revRead) {
        this.revRead = revRead;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }
}

