/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.pileup;

import genepi.mut.objects.BasePosition;
import genepi.mut.util.BaqAlt;
import genepi.mut.util.ReferenceUtil;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndexCreator;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import org.broadinstitute.gatk.utils.baq.BAQ;

public class BamAnalyser {
    public static final String headerRaw = "SAMPLE\tPOS\tREF\tTOP-FWD\tMINOR-FWD\tTOP-REV\tMINOR-REV\tCOV-FWD\tCOV-REV\tCOV-TOTAL\tTYPE\tLEVEL\t%A\t%C\t%G\t%T\t%D\t%N\t%a\t%c\t%g\t%t\t%d\t%n\tTOP-FWD-PERCENT\tTOP-REV-PERCENT\tMINOR-FWD-PERCENT\tMINOR-REV-PERCENT\tLLRFWD\tLLRREV\tLLRAFWD\tLLRCFWD\tLLRGFWD\tLLRTFWD\tLLRAREV\tLLRCREV\tLLRGREV\tLLRTREV\tLLRDFWD\tLLRDREV\tMINORS";
    public static final String headerVariants = "ID\tPos\tRef\tVariant\tVariantLevel\tMajorBase\tMajorLevel\tMinorBase\tMinorLevel\tCoverage\tCoverageFWD\tCoverageREV\tType";
    HashMap<Integer, BasePosition> counts;
    IndexedFastaSequenceFile refReader;
    String filename;
    String referenceString;
    BaqAlt baqHMMAltered;
    BAQ baqHMM;
    String version = "mtdna";
    int baseQual;
    int mapQual;
    int alignQual;
    boolean baq;

    public BamAnalyser(String file, String fastaPath) {
        this(file, fastaPath, 20, 20, 30, true, "mtdna");
    }

    public BamAnalyser(String filename, String fastaPath, int baseQual, int mapQual, int alignQual, boolean baq, String version) {
        Path path = new File(fastaPath).toPath();
        try {
            if (!new File(String.valueOf(fastaPath) + ".fai").exists()) {
                FastaSequenceIndex fg = FastaSequenceIndexCreator.buildFromFasta(path);
                fg.write(new File(String.valueOf(fastaPath) + ".fai").toPath());
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.referenceString = ReferenceUtil.readInReference(fastaPath);
        this.refReader = new IndexedFastaSequenceFile(new File(fastaPath), new FastaSequenceIndex(new File(String.valueOf(fastaPath) + ".fai")));
        this.counts = new HashMap();
        this.baseQual = baseQual;
        this.mapQual = mapQual;
        this.alignQual = alignQual;
        this.filename = filename;
        this.baq = baq;
        this.version = version;
        if (version.equalsIgnoreCase(versionEnum.MTDNA.name())) {
            this.baqHMMAltered = new BaqAlt(1.0E-4, 0.01, 7, 0, true);
        } else {
            this.baqHMM = new BAQ(1.0E-4, 0.01, 7, 0, true);
        }
    }

    public HashMap<Integer, BasePosition> getCounts() {
        return this.counts;
    }

    public void setCounts(HashMap<Integer, BasePosition> counts) {
        this.counts = counts;
    }

    public void analyseRead(SAMRecord samRecord, boolean deletions, boolean insertions) throws Exception {
        if (samRecord.getMappingQuality() < this.mapQual) {
            return;
        }
        if (samRecord.getReadUnmappedFlag()) {
            return;
        }
        if (samRecord.getDuplicateReadFlag()) {
            return;
        }
        if (samRecord.getReadLength() <= 25) {
            return;
        }
        if (ReferenceUtil.getTagFromSamRecord(samRecord.getAttributes(), "AS") < this.alignQual) {
            return;
        }
        if (this.baq) {
            if (this.version.equalsIgnoreCase(versionEnum.MTDNA.name())) {
                this.baqHMMAltered.baqRead(samRecord, this.refReader, BaqAlt.CalculationMode.CALCULATE_AS_NECESSARY, BaqAlt.QualityMode.OVERWRITE_QUALS);
            } else {
                this.baqHMM.baqRead(samRecord, this.refReader, BAQ.CalculationMode.CALCULATE_AS_NECESSARY, BAQ.QualityMode.OVERWRITE_QUALS);
            }
        }
        String readString = samRecord.getReadString();
        int i = 0;
        while (i < readString.length()) {
            int currentPos = samRecord.getReferencePositionAtReadPosition(i + 1);
            if (currentPos > 0 && samRecord.getBaseQualities()[i] >= this.baseQual) {
                int key = currentPos;
                BasePosition basePos = this.counts.get(key);
                if (basePos == null) {
                    basePos = new BasePosition();
                    this.counts.put(key, basePos);
                }
                char base = readString.charAt(i);
                if ((samRecord.getFlags() & 0x10) == 16) {
                    switch (base) {
                        case 'A': {
                            basePos.addaRev(1);
                            basePos.addaRevQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'C': {
                            basePos.addcRev(1);
                            basePos.addcRevQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'G': {
                            basePos.addgRev(1);
                            basePos.addgRevQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'T': {
                            basePos.addtRev(1);
                            basePos.addtRevQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'N': {
                            basePos.addnRev(1);
                            break;
                        }
                    }
                } else {
                    switch (base) {
                        case 'A': {
                            basePos.addaFor(1);
                            basePos.addaForQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'C': {
                            basePos.addcFor(1);
                            basePos.addcForQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'G': {
                            basePos.addgFor(1);
                            basePos.addgForQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'T': {
                            basePos.addtFor(1);
                            basePos.addtForQ(samRecord.getBaseQualities()[i]);
                            break;
                        }
                        case 'N': {
                            basePos.addnFor(1);
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        if (deletions || insertions) {
            Integer currentReferencePos = samRecord.getAlignmentStart();
            int sequencePos = 0;
            for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                Integer cigarElementLength = cigarElement.getLength();
                if (deletions && cigarElement.getOperator() == CigarOperator.D) {
                    Integer cigarElementStart = currentReferencePos;
                    Integer cigarElementEnd = currentReferencePos + cigarElementLength;
                    while (cigarElementStart < cigarElementEnd) {
                        int key = cigarElementStart;
                        BasePosition basePos = this.counts.get(key);
                        if (basePos == null) {
                            basePos = new BasePosition();
                            this.counts.put(key, basePos);
                        }
                        if ((samRecord.getFlags() & 0x10) == 16) {
                            basePos.adddRev(1);
                            basePos.adddRevQ((byte)40);
                        } else {
                            basePos.adddFor(1);
                            basePos.adddForQ((byte)40);
                        }
                        cigarElementStart = cigarElementStart + 1;
                    }
                }
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    currentReferencePos = currentReferencePos + cigarElement.getLength();
                }
                if (!cigarElement.getOperator().consumesReadBases()) continue;
                sequencePos += cigarElement.getLength();
            }
        }
    }

    public String getReferenceString() {
        return this.referenceString;
    }

    public void setReferenceString(String referenceString) {
        this.referenceString = referenceString;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    static enum versionEnum {
        MTDNA,
        GENOME;

    }
}

