/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.objects;

import genepi.io.table.reader.CsvTableReader;
import genepi.mut.objects.BasePosition;
import genepi.mut.objects.LlrObject;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;

public class VariantLine
implements Comparable<VariantLine> {
    private String id;
    private int position;
    private char ref;
    private int covFWD;
    private int covREV;
    private double llrFWD;
    private double llrREV;
    private char topBaseFWD;
    private char topBaseREV;
    private char minorBaseFWD;
    private char minorBaseREV;
    private ArrayList<Character> minors;
    private double aPercentageFWD;
    private double cPercentageFWD;
    private double gPercentageFWD;
    private double tPercentageFWD;
    private double nPercentageFWD;
    private double dPercentageFWD;
    private double aPercentageREV;
    private double cPercentageREV;
    private double gPercentageREV;
    private double tPercentageREV;
    private double nPercentageREV;
    private double dPercentageREV;
    private double llrAFWD;
    private double llrCFWD;
    private double llrGFWD;
    private double llrTFWD;
    private char bayesBase;
    private double bayesProbability;
    private double bayesPercentageFWD;
    private double bayesPercentageREV;
    private String insPosition;
    private double llrAREV;
    private double llrCREV;
    private double llrGREV;
    private double llrTREV;
    private double llrDFWD;
    private double llrDREV;
    private double topBasePercentsFWD;
    private double minorBasePercentsFWD;
    private double topBasePercentsREV;
    private double minorBasePercentsREV;
    private String message;
    private int type = 0;
    private double varLevel = 0.0;
    private boolean fwdOK = false;
    private boolean revOK = false;
    private boolean isInsertion = false;
    private boolean isVariant = false;
    private boolean oneSideVariant = false;
    private boolean isDeletion = false;
    private boolean isRevVariant = false;
    private double CIW_LOW_FWD;
    private double CIW_UP_FWD;
    private double CIW_LOW_REV;
    private double CIW_UP_REV;
    private double CIAC_LOW_FWD;
    private double CIAC_UP_FWD;
    private double CIAC_LOW_REV;
    private double CIAC_UP_REV;
    NumberFormat df;

    public VariantLine() {
        Locale.setDefault(new Locale("en", "US"));
        this.df = DecimalFormat.getInstance(Locale.US);
        this.df.setMinimumFractionDigits(2);
        this.df.setMaximumFractionDigits(4);
        this.df.setGroupingUsed(false);
    }

    public void parseLineFromFile(CsvTableReader cloudgeneReader) {
        this.setId(cloudgeneReader.getString("SAMPLE"));
        this.setPosition(cloudgeneReader.getInteger("POS"));
        this.setRef(cloudgeneReader.getString("REF").charAt(0));
        this.setLlrFWD(cloudgeneReader.getDouble("LLRFWD"));
        this.setLlrREV(cloudgeneReader.getDouble("LLRREV"));
        this.setCovFWD(cloudgeneReader.getInteger("COV-FWD"));
        this.setCovREV(cloudgeneReader.getInteger("COV-REV"));
        this.setLlrAFWD(cloudgeneReader.getDouble("LLRAFWD"));
        this.setLlrCFWD(cloudgeneReader.getDouble("LLRCFWD"));
        this.setLlrGFWD(cloudgeneReader.getDouble("LLRGFWD"));
        this.setLlrTFWD(cloudgeneReader.getDouble("LLRTFWD"));
        this.setLlrAREV(cloudgeneReader.getDouble("LLRAREV"));
        this.setLlrCREV(cloudgeneReader.getDouble("LLRCREV"));
        this.setLlrGREV(cloudgeneReader.getDouble("LLRGREV"));
        this.setLlrTREV(cloudgeneReader.getDouble("LLRTREV"));
        this.setLlrDFWD(cloudgeneReader.getDouble("LLRDFWD"));
        this.setLlrDREV(cloudgeneReader.getDouble("LLRDREV"));
        this.setaPercentageFWD(cloudgeneReader.getDouble("%A"));
        this.setcPercentageFWD(cloudgeneReader.getDouble("%C"));
        this.setgPercentageFWD(cloudgeneReader.getDouble("%G"));
        this.settPercentageFWD(cloudgeneReader.getDouble("%T"));
        this.setdPercentageFWD(cloudgeneReader.getDouble("%D"));
        this.setaPercentageREV(cloudgeneReader.getDouble("%a"));
        this.setcPercentageREV(cloudgeneReader.getDouble("%c"));
        this.setgPercentageREV(cloudgeneReader.getDouble("%g"));
        this.settPercentageREV(cloudgeneReader.getDouble("%t"));
        this.setdPercentageREV(cloudgeneReader.getDouble("%d"));
        this.setTopBasePercentsFWD(cloudgeneReader.getDouble("TOP-FWD-PERCENT"));
        this.setMinorBasePercentsFWD(cloudgeneReader.getDouble("MINOR-FWD-PERCENT"));
        this.setTopBasePercentsREV(cloudgeneReader.getDouble("TOP-REV-PERCENT"));
        this.setMinorBasePercentsREV(cloudgeneReader.getDouble("MINOR-REV-PERCENT"));
        this.setTopBaseFWD(cloudgeneReader.getString("TOP-FWD").charAt(0));
        this.setTopBaseREV(cloudgeneReader.getString("TOP-REV").charAt(0));
        this.setMinorBaseFWD(cloudgeneReader.getString("MINOR-FWD").charAt(0));
        this.setMinorBaseREV(cloudgeneReader.getString("MINOR-REV").charAt(0));
    }

    public void parseLine(BasePosition base, double level, HashMap<String, Double> frequencies) throws IOException {
        double aFWDPercents = 0.0;
        double cFWDPercents = 0.0;
        double gFWDPercents = 0.0;
        double tFWDPercents = 0.0;
        double nFWDPercents = 0.0;
        double dFWDPercents = 0.0;
        double aREVPercents = 0.0;
        double cREVPercents = 0.0;
        double gREVPercents = 0.0;
        double tREVPercents = 0.0;
        double nREVPercents = 0.0;
        double dREVPercents = 0.0;
        String id = base.getId();
        int pos = base.getPos();
        this.setId(id);
        this.setPosition(pos);
        int aFWD = base.getaFor();
        int cFWD = base.getcFor();
        int gFWD = base.getgFor();
        int tFWD = base.gettFor();
        int aREV = base.getaRev();
        int cREV = base.getcRev();
        int gREV = base.getgRev();
        int tREV = base.gettRev();
        int dFWD = base.getdFor();
        int dREV = base.getdRev();
        int nFWD = base.getnFor();
        int nREV = base.getnRev();
        int totalFWD = aFWD + cFWD + gFWD + tFWD + dFWD;
        int totalREV = aREV + cREV + gREV + tREV + dREV;
        this.setCovFWD(totalFWD);
        this.setCovREV(totalREV);
        if (totalFWD > 0) {
            aFWDPercents = (double)aFWD / (double)totalFWD;
            cFWDPercents = (double)cFWD / (double)totalFWD;
            gFWDPercents = (double)gFWD / (double)totalFWD;
            tFWDPercents = (double)tFWD / (double)totalFWD;
            dFWDPercents = (double)dFWD / (double)totalFWD;
            nFWDPercents = (double)nFWD / (double)(totalFWD + nFWD);
        }
        if (totalREV > 0) {
            aREVPercents = (double)aREV / (double)totalREV;
            cREVPercents = (double)cREV / (double)totalREV;
            gREVPercents = (double)gREV / (double)totalREV;
            tREVPercents = (double)tREV / (double)totalREV;
            dREVPercents = (double)dREV / (double)totalREV;
            nREVPercents = (double)nREV / (double)(totalREV + nREV);
        }
        this.setaPercentageFWD(aFWDPercents);
        this.setcPercentageFWD(cFWDPercents);
        this.setgPercentageFWD(gFWDPercents);
        this.settPercentageFWD(tFWDPercents);
        this.setnPercentageFWD(nFWDPercents);
        this.setdPercentageFWD(dFWDPercents);
        this.setaPercentageREV(aREVPercents);
        this.setcPercentageREV(cREVPercents);
        this.setgPercentageREV(gREVPercents);
        this.settPercentageREV(tREVPercents);
        this.setnPercentageREV(nREVPercents);
        this.setdPercentageREV(dREVPercents);
        ArrayList<Integer> allelesFWD = new ArrayList<Integer>();
        allelesFWD.add(aFWD);
        allelesFWD.add(cFWD);
        allelesFWD.add(gFWD);
        allelesFWD.add(tFWD);
        allelesFWD.add(dFWD);
        Collections.sort(allelesFWD, Collections.reverseOrder());
        double topBasePercentsFWD = 0.0;
        double minorBasePercentsFWD = 0.0;
        if (totalFWD > 0) {
            topBasePercentsFWD = (double)((Integer)allelesFWD.get(0)).intValue() / (double)totalFWD;
            minorBasePercentsFWD = (double)((Integer)allelesFWD.get(1)).intValue() / (double)totalFWD;
        }
        ArrayList<Integer> allelesREV = new ArrayList<Integer>();
        allelesREV.add(aREV);
        allelesREV.add(cREV);
        allelesREV.add(gREV);
        allelesREV.add(tREV);
        allelesREV.add(dREV);
        Collections.sort(allelesREV, Collections.reverseOrder());
        double topBasePercentsREV = 0.0;
        double minorBasePercentsREV = 0.0;
        if (totalREV > 0) {
            topBasePercentsREV = (double)((Integer)allelesREV.get(0)).intValue() / (double)totalREV;
            minorBasePercentsREV = (double)((Integer)allelesREV.get(1)).intValue() / (double)totalREV;
        }
        this.setTopBasePercentsFWD(topBasePercentsFWD);
        this.setMinorBasePercentsFWD(minorBasePercentsFWD);
        this.setTopBasePercentsREV(topBasePercentsREV);
        this.setMinorBasePercentsREV(minorBasePercentsREV);
        char topBaseFWD = '-';
        char minorBaseFWD = '-';
        if (aFWD >= cFWD && aFWD >= gFWD && aFWD >= tFWD && aFWD >= dFWD && aFWD > 0) {
            topBaseFWD = 'A';
        } else if (cFWD >= aFWD && cFWD >= gFWD && cFWD >= tFWD && cFWD >= dFWD && cFWD > 0) {
            topBaseFWD = 'C';
        } else if (gFWD >= cFWD && gFWD >= aFWD && gFWD >= tFWD && gFWD >= dFWD && gFWD > 0) {
            topBaseFWD = 'G';
        } else if (tFWD >= cFWD && tFWD >= gFWD && tFWD >= aFWD && tFWD >= dFWD && tFWD > 0) {
            topBaseFWD = 'T';
        } else if (dFWD >= cFWD && dFWD >= gFWD && dFWD >= aFWD && dFWD >= tFWD && dFWD > 0) {
            topBaseFWD = 'D';
        }
        char topBaseREV = '-';
        char minorBaseREV = '-';
        if (aREV >= cREV && aREV >= gREV && aREV >= tREV && aREV >= dREV && aREV > 0) {
            topBaseREV = 'A';
        } else if (cREV >= aREV && cREV >= gREV && cREV >= tREV && cREV >= dREV && cREV > 0) {
            topBaseREV = 'C';
        } else if (gREV >= cREV && gREV >= aREV && gREV >= tREV && gREV >= dREV && gREV > 0) {
            topBaseREV = 'G';
        } else if (tREV >= cREV && tREV >= gREV && tREV >= aREV && tREV >= dREV && tREV > 0) {
            topBaseREV = 'T';
        } else if (dREV >= cREV && dREV >= gREV && dREV >= aREV && dREV >= tREV && dREV > 0) {
            topBaseREV = 'D';
        }
        this.setTopBaseFWD(topBaseFWD);
        this.setTopBaseREV(topBaseREV);
        minorBaseFWD = this.detectMinorFWD(minorBasePercentsFWD);
        this.setMinorBaseFWD(minorBaseFWD);
        minorBaseREV = this.detectMinorREV(minorBasePercentsREV);
        this.setMinorBaseREV(minorBaseREV);
        this.minors = new ArrayList();
        int i = 1;
        while (i <= 4) {
            char minorREV;
            double minorPercentFWD = (double)((Integer)allelesFWD.get(i)).intValue() / (double)totalFWD;
            double minorPercentREV = (double)((Integer)allelesREV.get(i)).intValue() / (double)totalREV;
            char minorFWD = this.detectMinorFWD(minorPercentFWD);
            if (this.checkBases(topBaseFWD, topBaseREV, minorFWD, minorREV = this.detectMinorREV(minorPercentREV)) && minorFWD != '-') {
                this.minors.add(Character.valueOf(minorFWD));
            }
            ++i;
        }
        this.calcBayes(base, frequencies);
        if (minorBasePercentsFWD >= level || minorBasePercentsREV >= level) {
            LlrObject llr = this.calcLlr(base, this.getMinorBaseFWD(), this.getMinorBaseREV());
            this.setLlrFWD(llr.getLlrFWD());
            this.setLlrREV(llr.getLlrREV());
        }
        if (this.getTopBaseFWD() != 'A' && ((double)aFWD / (double)totalFWD >= level || (double)aREV / (double)totalREV >= level)) {
            LlrObject llr = this.calcLlr(base, 'A');
            this.setLlrAFWD(llr.getLlrFWD());
            this.setLlrAREV(llr.getLlrREV());
        }
        if (this.getTopBaseFWD() != 'C' && ((double)cFWD / (double)totalFWD >= level || (double)cREV / (double)totalREV >= level)) {
            LlrObject llr = this.calcLlr(base, 'C');
            this.setLlrCFWD(llr.getLlrFWD());
            this.setLlrCREV(llr.getLlrREV());
        }
        if (this.getTopBaseFWD() != 'G' && ((double)gFWD / (double)totalFWD >= level || (double)gREV / (double)totalREV >= level)) {
            LlrObject llr = this.calcLlr(base, 'G');
            this.setLlrGFWD(llr.getLlrFWD());
            this.setLlrGREV(llr.getLlrREV());
        }
        if (this.getTopBaseFWD() != 'T' && ((double)tFWD / (double)totalFWD >= level || (double)tREV / (double)totalREV >= level)) {
            LlrObject llr = this.calcLlr(base, 'T');
            this.setLlrTFWD(llr.getLlrFWD());
            this.setLlrTREV(llr.getLlrREV());
        }
        if (this.getTopBaseFWD() != 'D' && ((double)dFWD / (double)totalFWD >= level || (double)dREV / (double)totalREV >= level)) {
            LlrObject llr = this.calcLlr(base, 'D');
            this.setLlrDFWD(llr.getLlrFWD());
            this.setLlrDREV(llr.getLlrREV());
        }
    }

    public String toRawString() {
        return String.valueOf(this.id) + "\t" + this.position + "\t" + this.ref + "\t" + this.topBaseFWD + "\t" + this.minorBaseFWD + "\t" + this.topBaseREV + "\t" + this.minorBaseREV + "\t" + this.covFWD + "\t" + this.covREV + "\t" + (this.covFWD + this.covREV) + "\t" + this.type + "\t" + this.varLevel + "\t" + this.aPercentageFWD + "\t" + this.cPercentageFWD + "\t" + this.gPercentageFWD + "\t" + this.tPercentageFWD + "\t" + this.dPercentageFWD + "\t" + this.nPercentageFWD + "\t" + this.aPercentageREV + "\t" + this.cPercentageREV + "\t" + this.gPercentageREV + "\t" + this.tPercentageREV + "\t" + this.dPercentageREV + "\t" + this.nPercentageREV + "\t" + this.topBasePercentsFWD + "\t" + this.topBasePercentsREV + "\t" + this.minorBasePercentsFWD + "\t" + this.minorBasePercentsREV + "\t" + this.llrFWD + "\t" + this.llrREV + "\t" + this.llrAFWD + "\t" + this.llrAREV + "\t" + this.llrCFWD + "\t" + this.llrCREV + "\t" + this.llrGFWD + "\t" + this.llrGREV + "\t" + this.llrTFWD + "\t" + this.llrTREV + "\t" + this.llrDFWD + "\t" + this.llrDREV + "\t" + this.minors;
    }

    private boolean checkBases(char topFWD, char topREV, char minorFWD, char minorREV) {
        return minorFWD == minorREV && topFWD == topREV || topFWD == minorREV && topREV == minorFWD && this.topBasePercentsFWD >= 0.4 && this.topBasePercentsFWD <= 0.6;
    }

    private char detectMinorFWD(double minorPercentage) {
        if (minorPercentage > 0.0 && minorPercentage <= 0.5) {
            if (minorPercentage == this.aPercentageFWD && this.topBaseFWD != 'A') {
                return 'A';
            }
            if (minorPercentage == this.cPercentageFWD && this.topBaseFWD != 'C') {
                return 'C';
            }
            if (minorPercentage == this.gPercentageFWD && this.topBaseFWD != 'G') {
                return 'G';
            }
            if (minorPercentage == this.tPercentageFWD && this.topBaseFWD != 'T') {
                return 'T';
            }
            if (minorPercentage == this.dPercentageFWD && this.topBaseFWD != 'D') {
                return 'D';
            }
        }
        return '-';
    }

    private char detectMinorREV(double minorPercentage) {
        if (minorPercentage > 0.0 && minorPercentage <= 0.5) {
            if (minorPercentage == this.aPercentageREV && this.topBaseREV != 'A') {
                return 'A';
            }
            if (minorPercentage == this.cPercentageREV && this.topBaseREV != 'C') {
                return 'C';
            }
            if (minorPercentage == this.gPercentageREV && this.topBaseREV != 'G') {
                return 'G';
            }
            if (minorPercentage == this.tPercentageREV && this.topBaseREV != 'T') {
                return 'T';
            }
            if (minorPercentage == this.dPercentageREV && this.topBaseREV != 'D') {
                return 'D';
            }
        }
        return '-';
    }

    private LlrObject calcLlr(BasePosition base, char minorBaseFWD) {
        return this.calcLlr(base, minorBaseFWD, minorBaseFWD);
    }

    private LlrObject calcLlr(BasePosition base, char minorBaseFWD, char minorBaseREV) {
        LlrObject llr = new LlrObject();
        double fm0FWD = this.calcFirst(base);
        double fm1FWD = this.calcFirst(base) + this.calcSecond(base, minorBaseFWD);
        double fm0REV = this.calcFirstRev(base);
        double fm1REV = this.calcFirstRev(base) + this.calcSecondR(base, minorBaseREV);
        llr.setLlrFWD(Math.abs(fm1FWD - fm0FWD));
        llr.setLlrREV(Math.abs(fm1REV - fm0REV));
        return llr;
    }

    public void calcBayes(BasePosition base, HashMap<String, Double> freq) {
        double qualScore;
        byte err;
        double probAFor = 1.0;
        double probCFor = 1.0;
        double probGFor = 1.0;
        double probTFor = 1.0;
        double probARev = 1.0;
        double probCRev = 1.0;
        double probGRev = 1.0;
        double probTRev = 1.0;
        double freqA = 0.001;
        double freqC = 0.001;
        double freqG = 0.001;
        double freqT = 0.001;
        String keyA = String.valueOf(base.getPos()) + "A";
        String keyC = String.valueOf(base.getPos()) + "C";
        String keyG = String.valueOf(base.getPos()) + "G";
        String keyT = String.valueOf(base.getPos()) + "T";
        if (freq != null) {
            if (freq.containsKey(keyA)) {
                freqA = freq.get(keyA);
            }
            if (freq.containsKey(keyC)) {
                freqC = freq.get(keyC);
            }
            if (freq.containsKey(keyG)) {
                freqG = freq.get(keyG);
            }
            if (freq.containsKey(keyT)) {
                freqT = freq.get(keyT);
            }
        }
        int i = 0;
        while (i < base.getaFor()) {
            err = base.getaForQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probAFor += Math.log10(1.0 - qualScore);
            probCFor += Math.log10(qualScore / 3.0);
            probGFor += Math.log10(qualScore / 3.0);
            probTFor += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.getcFor()) {
            err = base.getcForQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probCFor += Math.log10(1.0 - qualScore);
            probAFor += Math.log10(qualScore / 3.0);
            probGFor += Math.log10(qualScore / 3.0);
            probTFor += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.getgFor()) {
            err = base.getgForQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probGFor += Math.log10(1.0 - qualScore);
            probAFor += Math.log10(qualScore / 3.0);
            probCFor += Math.log10(qualScore / 3.0);
            probTFor += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.gettFor()) {
            err = base.gettForQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probTFor += Math.log10(1.0 - qualScore);
            probAFor += Math.log10(qualScore / 3.0);
            probCFor += Math.log10(qualScore / 3.0);
            probGFor += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.getaRev()) {
            err = base.getaRevQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probARev += Math.log10(1.0 - qualScore);
            probCRev += Math.log10(qualScore / 3.0);
            probGRev += Math.log10(qualScore / 3.0);
            probTRev += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.getcRev()) {
            err = base.getcRevQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probCRev += Math.log10(1.0 - qualScore);
            probARev += Math.log10(qualScore / 3.0);
            probGRev += Math.log10(qualScore / 3.0);
            probTRev += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.getgRev()) {
            err = base.getgRevQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probGRev += Math.log10(1.0 - qualScore);
            probARev += Math.log10(qualScore / 3.0);
            probCRev += Math.log10(qualScore / 3.0);
            probTRev += Math.log10(qualScore / 3.0);
            ++i;
        }
        i = 0;
        while (i < base.gettRev()) {
            err = base.gettRevQ().get(i);
            qualScore = Math.pow(10.0, -err / 10);
            probTRev += Math.log10(1.0 - qualScore);
            probARev += Math.log10(qualScore / 3.0);
            probCRev += Math.log10(qualScore / 3.0);
            probGRev += Math.log10(qualScore / 3.0);
            ++i;
        }
        double probA = probAFor + probARev + Math.log10(freqA);
        double probC = probCFor + probCRev + Math.log10(freqC);
        double probG = probGFor + probGRev + Math.log10(freqG);
        double probT = probTFor + probTRev + Math.log10(freqT);
        char finalBase = '-';
        double bayesProb = 0.0;
        bayesProb = Math.max(Math.max(probA, probC), Math.max(probG, probT));
        double d = bayesProb + Math.log10(Math.pow(Math.E, probA - bayesProb) + Math.pow(Math.E, probC - bayesProb) + Math.pow(Math.E, probG - bayesProb) + Math.pow(Math.E, probT - bayesProb));
        if (bayesProb == probA) {
            finalBase = 'A';
        } else if (bayesProb == probC) {
            finalBase = 'C';
        } else if (bayesProb == probG) {
            finalBase = 'G';
        } else if (bayesProb == probT) {
            finalBase = 'T';
        }
        if (finalBase == 'A') {
            this.bayesPercentageFWD = this.aPercentageFWD;
            this.bayesPercentageREV = this.aPercentageREV;
        }
        if (finalBase == 'C') {
            this.bayesPercentageFWD = this.cPercentageFWD;
            this.bayesPercentageREV = this.cPercentageREV;
        }
        if (finalBase == 'G') {
            this.bayesPercentageFWD = this.gPercentageFWD;
            this.bayesPercentageREV = this.gPercentageREV;
        }
        if (finalBase == 'T') {
            this.bayesPercentageFWD = this.tPercentageFWD;
            this.bayesPercentageREV = this.tPercentageREV;
        }
        this.setBayesProbability(Math.pow(10.0, bayesProb - d));
        this.setBayesBase(finalBase);
    }

    @Override
    public int compareTo(VariantLine o) {
        if (this.id.equals(o.getId())) {
            return this.position > o.getPosition() ? 1 : -1;
        }
        return this.id.compareTo(o.getId());
    }

    public double calcFirst(BasePosition base) {
        char major = this.getTopBaseFWD();
        double tmp = 0.0;
        double f = this.getTopBasePercentsFWD();
        switch (major) {
            case 'A': {
                int aFWD = base.getaFor();
                int i = 0;
                while (i < aFWD) {
                    int err = 20;
                    err = base.getaForQ().get(i).byteValue();
                    double p = Math.pow(10.0, -err / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'C': {
                int cFWD = base.getcFor();
                int i = 0;
                while (i < cFWD) {
                    Byte err = base.getcForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'G': {
                int gFWD = base.getgFor();
                int i = 0;
                while (i < gFWD) {
                    Byte err = base.getgForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'T': {
                int tFWD = base.gettFor();
                int i = 0;
                while (i < tFWD) {
                    Byte err = base.gettForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'D': {
                int dFWD = base.getdFor();
                int i = 0;
                while (i < dFWD) {
                    Byte err = base.getdForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
        }
        return tmp;
    }

    public double calcSecond(BasePosition base, char baseChar) {
        char minor = baseChar;
        double tmp = 0.0;
        double f = this.getTopBasePercentsFWD();
        switch (minor) {
            case 'A': {
                int aFWD = base.getaFor();
                int i = 0;
                while (i < aFWD) {
                    Byte err = base.getaForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'C': {
                int cFWD = base.getcFor();
                int i = 0;
                while (i < cFWD) {
                    Byte err = base.getcForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'G': {
                int gFWD = base.getgFor();
                int i = 0;
                while (i < gFWD) {
                    Byte err = base.getgForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'T': {
                int tFWD = base.gettFor();
                int i = 0;
                while (i < tFWD) {
                    Byte err = base.gettForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'D': {
                int dFWD = base.getdFor();
                int i = 0;
                while (i < dFWD) {
                    Byte err = base.getdForQ().get(i);
                    double p = Math.pow(10.0, -err.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
        }
        return tmp;
    }

    private double majorCalc(double tmp, double f, double p) {
        return tmp + Math.log((1.0 - f) * p + f * (1.0 - p));
    }

    private double minorCalc(double tmp, double f, double p) {
        return tmp + Math.log((1.0 - f) * (1.0 - p) + f * p);
    }

    public double calcFirstRev(BasePosition base) {
        char major = this.getTopBaseREV();
        double tmp = 0.0;
        double f = this.getTopBasePercentsREV();
        switch (major) {
            case 'A': {
                int aREV = base.getaRev();
                int i = 0;
                while (i < aREV) {
                    Byte quality = base.getaRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'C': {
                int cREV = base.getcRev();
                int i = 0;
                while (i < cREV) {
                    Byte quality = base.getcRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'G': {
                int gREV = base.getgRev();
                int i = 0;
                while (i < gREV) {
                    Byte quality = base.getgRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'T': {
                int tREV = base.gettRev();
                int i = 0;
                while (i < tREV) {
                    Byte quality = base.gettRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'D': {
                int dREV = base.getdRev();
                int i = 0;
                while (i < dREV) {
                    Byte quality = base.getdRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.majorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
        }
        return tmp;
    }

    public double calcSecondR(BasePosition base, char baseChar) {
        char minor = baseChar;
        double tmp = 0.0;
        double f = this.getTopBasePercentsREV();
        switch (minor) {
            case 'A': {
                int aREV = base.getaRev();
                int i = 0;
                while (i < aREV) {
                    Byte quality = base.getaRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'C': {
                int cREV = base.getcRev();
                int i = 0;
                while (i < cREV) {
                    Byte quality = base.getcRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'G': {
                int gREV = base.getgRev();
                int i = 0;
                while (i < gREV) {
                    Byte quality = base.getgRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'T': {
                int tREV = base.gettRev();
                int i = 0;
                while (i < tREV) {
                    Byte quality = base.gettRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
            case 'D': {
                int dREV = base.getdRev();
                int i = 0;
                while (i < dREV) {
                    Byte quality = base.getdRevQ().get(i);
                    double p = Math.pow(10.0, -quality.byteValue() / 10);
                    tmp = this.minorCalc(tmp, f, p);
                    ++i;
                }
                break;
            }
        }
        return tmp;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getnPercentageFWD() {
        return this.nPercentageFWD;
    }

    public void setnPercentageFWD(double nPercentageFWD) {
        this.nPercentageFWD = nPercentageFWD;
    }

    public double getaPercentageREV() {
        return this.aPercentageREV;
    }

    public void setaPercentageREV(double aPercentageREV) {
        this.aPercentageREV = aPercentageREV;
    }

    public double getcPercentageREV() {
        return this.cPercentageREV;
    }

    public void setcPercentageREV(double cPercentageREV) {
        this.cPercentageREV = cPercentageREV;
    }

    public double getgPercentageREV() {
        return this.gPercentageREV;
    }

    public void setgPercentageREV(double gPercentageREV) {
        this.gPercentageREV = gPercentageREV;
    }

    public double gettPercentageREV() {
        return this.tPercentageREV;
    }

    public void settPercentageREV(double tPercentageREV) {
        this.tPercentageREV = tPercentageREV;
    }

    public double getnPercentageREV() {
        return this.nPercentageREV;
    }

    public void setnPercentageREV(double nPercentageREV) {
        this.nPercentageREV = nPercentageREV;
    }

    public double getdPercentageFWD() {
        return this.dPercentageFWD;
    }

    public void setdPercentageFWD(double dPercentageFWD) {
        this.dPercentageFWD = dPercentageFWD;
    }

    public double getdPercentageREV() {
        return this.dPercentageREV;
    }

    public void setdPercentageREV(double dPercentageREV) {
        this.dPercentageREV = dPercentageREV;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public double getaPercentageFWD() {
        return this.aPercentageFWD;
    }

    public void setaPercentageFWD(double aPercentageFWD) {
        this.aPercentageFWD = aPercentageFWD;
    }

    public double getcPercentageFWD() {
        return this.cPercentageFWD;
    }

    public void setcPercentageFWD(double cPercentageFWD) {
        this.cPercentageFWD = cPercentageFWD;
    }

    public double getgPercentageFWD() {
        return this.gPercentageFWD;
    }

    public void setgPercentageFWD(double gPercentageFWD) {
        this.gPercentageFWD = gPercentageFWD;
    }

    public double gettPercentageFWD() {
        return this.tPercentageFWD;
    }

    public void settPercentageFWD(double tPercentageFWD) {
        this.tPercentageFWD = tPercentageFWD;
    }

    public int getCovFWD() {
        return this.covFWD;
    }

    public void setCovFWD(int covFWD) {
        this.covFWD = covFWD;
    }

    public int getCovREV() {
        return this.covREV;
    }

    public void setCovREV(int covREV) {
        this.covREV = covREV;
    }

    public double getTopBasePercentsFWD() {
        return this.topBasePercentsFWD;
    }

    public void setTopBasePercentsFWD(double topBasePercentsFWD) {
        this.topBasePercentsFWD = topBasePercentsFWD;
    }

    public double getMinorPercentsFWD() {
        return this.minorBasePercentsFWD;
    }

    public void setMinorBasePercentsFWD(double minorBasePercentsFWD) {
        this.minorBasePercentsFWD = minorBasePercentsFWD;
    }

    public double getTopBasePercentsREV() {
        return this.topBasePercentsREV;
    }

    public void setTopBasePercentsREV(double topBasePercentsREV) {
        this.topBasePercentsREV = topBasePercentsREV;
    }

    public char getTopBaseFWD() {
        return this.topBaseFWD;
    }

    public void setTopBaseFWD(char posFWD) {
        this.topBaseFWD = posFWD;
    }

    public char getTopBaseREV() {
        return this.topBaseREV;
    }

    public void setTopBaseREV(char posREV) {
        this.topBaseREV = posREV;
    }

    public boolean isVariant() {
        return this.isVariant;
    }

    public void setVariant(boolean isVariant) {
        this.isVariant = isVariant;
    }

    public int getVariantType() {
        return this.type;
    }

    public void setVariantType(int isHeteroplasmy) {
        this.type = isHeteroplasmy;
    }

    public char getMinorBaseFWD() {
        return this.minorBaseFWD;
    }

    public void setMinorBaseFWD(char minorBaseFWD) {
        this.minorBaseFWD = minorBaseFWD;
    }

    public char getMinorBaseREV() {
        return this.minorBaseREV;
    }

    public void setMinorBaseREV(char minorBaseREV) {
        this.minorBaseREV = minorBaseREV;
    }

    public double getVariantLevel() {
        return this.varLevel;
    }

    public void setVariantLevel(double hetLevelFWD) {
        this.varLevel = hetLevelFWD;
    }

    public double getMinorBasePercentsREV() {
        return this.minorBasePercentsREV;
    }

    public void setMinorBasePercentsREV(double minorBasePercentsREV) {
        this.minorBasePercentsREV = minorBasePercentsREV;
    }

    public double getMinorBasePercentsFWD() {
        return this.minorBasePercentsFWD;
    }

    public double getCIW_LOW_FWD() {
        return this.CIW_LOW_FWD;
    }

    public void setCIW_LOW_FWD(double cIW_LOW_FWD) {
        this.CIW_LOW_FWD = cIW_LOW_FWD;
    }

    public double getCIW_UP_FWD() {
        return this.CIW_UP_FWD;
    }

    public void setCIW_UP_FWD(double cIW_UP_FWD) {
        this.CIW_UP_FWD = cIW_UP_FWD;
    }

    public double getCIAC_LOW_REV() {
        return this.CIAC_LOW_REV;
    }

    public void setCIAC_LOW_REV(double cIAC_LOW_REV) {
        this.CIAC_LOW_REV = cIAC_LOW_REV;
    }

    public double getCIAC_UP_REV() {
        return this.CIAC_UP_REV;
    }

    public void setCIAC_UP_REV(double cIAC_UP_REV) {
        this.CIAC_UP_REV = cIAC_UP_REV;
    }

    public double getCIW_LOW_REV() {
        return this.CIW_LOW_REV;
    }

    public void setCIW_LOW_REV(double cIW_LOW_REV) {
        this.CIW_LOW_REV = cIW_LOW_REV;
    }

    public double getCIW_UP_REV() {
        return this.CIW_UP_REV;
    }

    public void setCIW_UP_REV(double cIW_UP_REV) {
        this.CIW_UP_REV = cIW_UP_REV;
    }

    public double getCIAC_LOW_FWD() {
        return this.CIAC_LOW_FWD;
    }

    public void setCIAC_LOW_FWD(double cIAC_LOW_FWD) {
        this.CIAC_LOW_FWD = cIAC_LOW_FWD;
    }

    public double getCIAC_UP_FWD() {
        return this.CIAC_UP_FWD;
    }

    public void setCIAC_UP_FWD(double cIAC_UP_FWD) {
        this.CIAC_UP_FWD = cIAC_UP_FWD;
    }

    public boolean isFwdOK() {
        return this.fwdOK;
    }

    public void setFwdOK(boolean fwdOK) {
        this.fwdOK = fwdOK;
    }

    public boolean isRevOK() {
        return this.revOK;
    }

    public void setRevOK(boolean revOK) {
        this.revOK = revOK;
    }

    public boolean isInsertion() {
        return this.isInsertion;
    }

    public void setInsertion(boolean isInsertion) {
        this.isInsertion = isInsertion;
    }

    public boolean isRevVariant() {
        return this.isRevVariant;
    }

    public void setRevVariant(boolean isRevVariant) {
        this.isRevVariant = isRevVariant;
    }

    public boolean isOneSideVariant() {
        return this.oneSideVariant;
    }

    public void setOneSideVariant(boolean oneSideVariant) {
        this.oneSideVariant = oneSideVariant;
    }

    public boolean isDeletion() {
        return this.isDeletion;
    }

    public void setDeletion(boolean isDeletion) {
        this.isDeletion = isDeletion;
    }

    public double getLlrFWD() {
        return this.llrFWD;
    }

    public void setLlrFWD(double llrFWD) {
        this.llrFWD = llrFWD;
    }

    public double getLlrREV() {
        return this.llrREV;
    }

    public void setLlrREV(double llrREV) {
        this.llrREV = llrREV;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public double getLlrAFWD() {
        return this.llrAFWD;
    }

    public void setLlrAFWD(double llrAFWD) {
        this.llrAFWD = llrAFWD;
    }

    public double getLlrCFWD() {
        return this.llrCFWD;
    }

    public void setLlrCFWD(double llrCFWD) {
        this.llrCFWD = llrCFWD;
    }

    public double getLlrGFWD() {
        return this.llrGFWD;
    }

    public void setLlrGFWD(double llrGFWD) {
        this.llrGFWD = llrGFWD;
    }

    public double getLlrTFWD() {
        return this.llrTFWD;
    }

    public void setLlrTFWD(double llrTFWD) {
        this.llrTFWD = llrTFWD;
    }

    public double getLlrAREV() {
        return this.llrAREV;
    }

    public void setLlrAREV(double llrAREV) {
        this.llrAREV = llrAREV;
    }

    public double getLlrCREV() {
        return this.llrCREV;
    }

    public void setLlrCREV(double llrCREV) {
        this.llrCREV = llrCREV;
    }

    public double getLlrGREV() {
        return this.llrGREV;
    }

    public void setLlrGREV(double llrGREV) {
        this.llrGREV = llrGREV;
    }

    public double getLlrTREV() {
        return this.llrTREV;
    }

    public void setLlrTREV(double llrTREV) {
        this.llrTREV = llrTREV;
    }

    public char getRef() {
        return this.ref;
    }

    public void setRef(char ref) {
        this.ref = ref;
    }

    public double getLlrDFWD() {
        return this.llrDFWD;
    }

    public void setLlrDFWD(double llrDFWD) {
        this.llrDFWD = llrDFWD;
    }

    public double getLlrDREV() {
        return this.llrDREV;
    }

    public void setLlrDREV(double llrDREV) {
        this.llrDREV = llrDREV;
    }

    public String getInsPosition() {
        return this.insPosition;
    }

    public void setInsPosition(String insPosition) {
        this.insPosition = insPosition;
    }

    public ArrayList<Character> getMinors() {
        return this.minors;
    }

    public void setMinors(ArrayList<Character> minors) {
        this.minors = minors;
    }

    public char getBayesBase() {
        return this.bayesBase;
    }

    public void setBayesBase(char bayesBase) {
        this.bayesBase = bayesBase;
    }

    public double getBayesProbability() {
        return this.bayesProbability;
    }

    public void setBayesProbability(double bayesProbability) {
        this.bayesProbability = bayesProbability;
    }

    public double getBayesPercentageFWD() {
        return this.bayesPercentageFWD;
    }

    public void setBayesPercentageFWD(double bayesPercentageFWD) {
        this.bayesPercentageFWD = bayesPercentageFWD;
    }

    public double getBayesPercentageREV() {
        return this.bayesPercentageREV;
    }

    public void setBayesPercentageREV(double bayesPercentageREV) {
        this.bayesPercentageREV = bayesPercentageREV;
    }
}

