/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.objects;

import genepi.mut.objects.Variant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;

public class Sample {
    private String id;
    private TreeMap<Integer, ArrayList<Variant>> variants = new TreeMap();
    private int amountHomoplasmies;
    private int amountVariants;
    private int amountHeteroplasmies;
    boolean chip;
    private String range;
    private float sumCoverage = 0.0f;
    private float sumHeteroplasmyLevel = 0.0f;

    public Set<Integer> getKeys() {
        return this.variants.keySet();
    }

    public Collection<ArrayList<Variant>> getVariants() {
        return this.variants.values();
    }

    public ArrayList<Variant> getVariants(int pos) {
        return this.variants.get(pos);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addVariant(Variant var) {
        ArrayList<Variant> list = this.variants.get(var.getPos());
        if (list == null) {
            list = new ArrayList();
        }
        list.add(var);
        this.variants.put(var.getPos(), list);
        this.updateCount(var.getType());
        if (var.getType() == 2) {
            this.updateHetLevels(var.getLevel());
        }
        this.sumCoverage(var.getCoverage());
    }

    private void updateCount(int type) {
        ++this.amountVariants;
        if (type == 1) {
            ++this.amountHomoplasmies;
        }
        if (type == 2) {
            ++this.amountHeteroplasmies;
        }
    }

    private void sumCoverage(int coverage) {
        this.sumCoverage += (float)coverage;
    }

    private void updateHetLevels(double level) {
        this.sumHeteroplasmyLevel = (float)((double)this.sumHeteroplasmyLevel + level);
    }

    public int getAmountHomoplasmies() {
        return this.amountHomoplasmies;
    }

    public void setAmountHomoplasmies(int amountHomoplasmies) {
        this.amountHomoplasmies = amountHomoplasmies;
    }

    public int getAmountVariants() {
        return this.amountVariants;
    }

    public void setAmountVariants(int amountVariants) {
        this.amountVariants = amountVariants;
    }

    public int getAmountHeteroplasmies() {
        return this.amountHeteroplasmies;
    }

    public void setAmountHeteroplasmies(int amountHeteroplasmies) {
        this.amountHeteroplasmies = amountHeteroplasmies;
    }

    public float getSumCoverage() {
        return this.sumCoverage;
    }

    public void setSumCoverage(float totalCoverage) {
        this.sumCoverage = totalCoverage;
    }

    public float getSumHeteroplasmyLevel() {
        return this.sumHeteroplasmyLevel;
    }

    public void setSumHeteroplasmyLevel(float countHeteroplasmyLevel) {
        this.sumHeteroplasmyLevel = countHeteroplasmyLevel;
    }

    public boolean isChip() {
        return this.chip;
    }

    public void setChip(boolean chip) {
        this.chip = chip;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }
}

