/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.align.single;

import com.github.lindenb.jbwa.jni.AlnRgn;
import com.github.lindenb.jbwa.jni.BwaIndex;
import com.github.lindenb.jbwa.jni.BwaMem;
import com.github.lindenb.jbwa.jni.ShortRead;
import genepi.hadoop.CacheStore;
import genepi.io.FileUtil;
import genepi.mut.util.ReferenceUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class SingleAlignerMap
extends Mapper<Object, SequencedFragment, Text, Text> {
    BwaIndex index;
    BwaMem mem;
    int length;
    String filename;
    private Text outValue = new Text();
    private SAMFileHeader header = new SAMFileHeader();
    private SAMLineParser parser = null;
    StringBuilder samRecordBuilder = new StringBuilder();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        CacheStore cache = new CacheStore(context.getConfiguration());
        String jbwaLibLocation = cache.getArchive("jbwaLib");
        String jbwaLib = FileUtil.path(jbwaLibLocation, "libbwajni.so");
        String referencePath = cache.getArchive("reference");
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        this.filename = fileSplit.getPath().getName();
        System.load(jbwaLib);
        File reference = new File(referencePath);
        String refString = ReferenceUtil.findFileinDir(reference, ".fasta");
        this.length = ReferenceUtil.readInReference(refString).length();
        if (refString != null) {
            this.index = new BwaIndex(new File(refString));
            this.mem = new BwaMem(this.index);
        } else {
            System.exit(-1);
        }
        this.header = new SAMFileHeader();
        this.parser = new SAMLineParser(this.header);
    }

    public void map(Object key, SequencedFragment value, Mapper.Context context) throws IOException, InterruptedException {
        String seq = value.getSequence().toString();
        String qual = value.getQuality().toString();
        ShortRead read = new ShortRead(key.toString(), seq.getBytes(), qual.getBytes());
        AlnRgn[] alnRgnArray = this.mem.align(read);
        int n = alnRgnArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                byte[] temp;
                AlnRgn alignedRead;
                block11: {
                    block10: {
                        alignedRead = alnRgnArray[n2];
                        if (this.header.getSequence(alignedRead.getChrom()) == null) {
                            this.header.addSequence(new SAMSequenceRecord(alignedRead.getChrom(), this.length));
                        }
                        this.samRecordBuilder.setLength(0);
                        if (alignedRead.getAs() < 30) break block9;
                        this.samRecordBuilder.append(key.toString());
                        this.samRecordBuilder.append("\t");
                        if (alignedRead.getStrand() != '-') break block10;
                        if (alignedRead.getSecondary() >= 0) break block9;
                        this.samRecordBuilder.append(16);
                        break block11;
                    }
                    if (alignedRead.getSecondary() >= 0) break block9;
                    this.samRecordBuilder.append(0);
                }
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append(alignedRead.getChrom());
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append(alignedRead.getPos());
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append(alignedRead.getMQual());
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append(alignedRead.getCigar());
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append("*\t0\t0\t");
                if (alignedRead.getStrand() == '-') {
                    temp = value.getSequence().toString().getBytes();
                    SequenceUtil.reverseComplement(temp);
                    this.samRecordBuilder.append(new String(temp));
                } else {
                    this.samRecordBuilder.append(value.getSequence());
                }
                this.samRecordBuilder.append("\t");
                if (alignedRead.getStrand() == '-') {
                    temp = value.getQuality().toString().getBytes();
                    SequenceUtil.reverseQualities(temp);
                    this.samRecordBuilder.append(new String(temp));
                } else {
                    this.samRecordBuilder.append(value.getQuality());
                }
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append("NM:i:" + alignedRead.getNm());
                this.samRecordBuilder.append("\t");
                this.samRecordBuilder.append("AS:i:" + alignedRead.getAs());
                SAMRecord samRecord = this.parser.parseLine(this.samRecordBuilder.toString());
                this.outValue.set(String.valueOf(this.filename) + "\t" + samRecord.getSAMString());
                context.write(null, (Object)this.outValue);
            }
            ++n2;
        }
    }

    static enum Counters {
        BAD_MAPPING,
        BAD_QUALITY,
        GOOD_QUALITY;

    }
}

