/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.align.single;

import genepi.hadoop.CacheStore;
import genepi.hadoop.HadoopJob;
import genepi.hadoop.HdfsUtil;
import genepi.io.FileUtil;
import genepi.mut.align.single.SingleAlignerMap;
import genepi.mut.objects.BasePosition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.FastqInputFormat;

public class SingleAlignerJob
extends HadoopJob {
    protected static final Log log = LogFactory.getLog(SingleAlignerJob.class);
    private String reference;
    private String refArchive;
    private String folder;

    public SingleAlignerJob(String name) {
        super(name);
        this.set("mapred.map.tasks.speculative.execution", false);
        this.set("mapred.reduce.tasks.speculative.execution", false);
    }

    @Override
    public void setupJob(Job job) {
        job.setJarByClass(BAMRecordReader.class);
        job.setInputFormatClass(FastqInputFormat.class);
        job.setMapperClass(SingleAlignerMap.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(BasePosition.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(TextOutputFormat.class);
    }

    @Override
    protected void setupDistributedCache(CacheStore cache) {
        String hdfsPathRef;
        String hdfsPath = HdfsUtil.path("/tmp/mutation-server-data", "jbwa-native.tar");
        if (!HdfsUtil.exists(hdfsPath)) {
            String jbwa = FileUtil.path(this.folder, "jbwa-native.tar");
            HdfsUtil.put(jbwa, hdfsPath);
        }
        if (!HdfsUtil.exists(hdfsPathRef = HdfsUtil.path("/tmp/mutation-server-data", this.refArchive.substring(this.refArchive.lastIndexOf("/") + 1)))) {
            HdfsUtil.put(this.refArchive, hdfsPathRef);
        }
        log.info((Object)("Archive path is: " + hdfsPath));
        log.info((Object)("Reference path is: " + hdfsPathRef));
        cache.addArchive("jbwaLib", hdfsPath);
        cache.addArchive("reference", hdfsPathRef);
    }

    @Override
    public void setOutput(String output) {
        super.setOutput(output);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReferenceArchive(String refArchive) {
        this.refArchive = refArchive;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }
}

