/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.align.paired;

import com.github.lindenb.jbwa.jni.BwaIndex;
import com.github.lindenb.jbwa.jni.BwaMem;
import com.github.lindenb.jbwa.jni.ShortRead;
import genepi.hadoop.CacheStore;
import genepi.io.FileUtil;
import genepi.mut.objects.SingleRead;
import genepi.mut.util.ReferenceUtil;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PairedAlignerReducer
extends Reducer<Text, SingleRead, Text, Text> {
    SingleRead first = new SingleRead();
    SingleRead second = new SingleRead();
    BwaIndex index;
    BwaMem mem;
    List<ShortRead> L1;
    List<ShortRead> L2;
    Text out;
    String[] result;
    String ref;
    int countReads;
    int trimBasesStart;
    int trimBasesEnd;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        String refString = null;
        this.L1 = new ArrayList<ShortRead>();
        this.L2 = new ArrayList<ShortRead>();
        this.out = new Text();
        this.countReads = 0;
        CacheStore cache = new CacheStore(context.getConfiguration());
        String jbwaLibLocation = cache.getArchive("jbwaLib");
        String jbwaLib = FileUtil.path(jbwaLibLocation, "libbwajni.so");
        String referencePath = cache.getArchive("reference");
        this.trimBasesStart = context.getConfiguration().getInt("trimReadsStart", 0);
        this.trimBasesEnd = context.getConfiguration().getInt("trimReadsEnd", 0);
        this.ref = context.getConfiguration().get("reference");
        System.load(jbwaLib);
        File reference = new File(referencePath);
        refString = ReferenceUtil.findFileinDir(reference, ".fasta");
        this.index = new BwaIndex(new File(refString));
        this.mem = new BwaMem(this.index);
    }

    protected void reduce(Text key, Iterable<SingleRead> values, Reducer.Context context) throws IOException, InterruptedException {
        int i = 0;
        for (SingleRead value : values) {
            ++i;
            if (value.getReadNumber() == 1) {
                this.first = new SingleRead();
                this.first.setReadLength(value.getReadLength());
                this.first.setName(value.getName());
                this.first.setBases(value.getBases());
                this.first.setQual(value.getQualities());
                this.first.setFilename(value.getFilename());
                continue;
            }
            this.second = new SingleRead();
            this.second.setReadLength(value.getReadLength());
            this.second.setName(value.getName());
            this.second.setBases(value.getBases());
            this.second.setQual(value.getQualities());
            this.second.setFilename(value.getFilename());
        }
        if (i == 2) {
            this.countReads += 2;
            this.L1.add(this.first);
            this.L2.add(this.second);
            if (this.countReads % 99010 == 0) {
                System.out.println(this.L1.size());
                System.out.println(this.L2.size());
                System.out.println("count is " + this.countReads);
                this.align(context);
            }
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        if (this.L1.size() > 0) {
            System.out.println("last call");
            System.out.println("align directly");
            this.align(context);
        } else {
            System.out.println("nothing to align in cleanup");
        }
        this.index.close();
        this.mem.dispose();
    }

    private void align(Reducer.Context context) throws IOException, InterruptedException {
        this.result = this.mem.align(this.L1, this.L2);
        int i = 0;
        while (i < this.result.length) {
            String[] tiles;
            String read = this.result[i];
            String sample = ((SingleRead)this.L1.get(i / 2)).getFilename();
            read = read.replaceAll("\\t+$", "");
            read = read.replaceAll("\\s+$", "");
            String[] stringArray = tiles = read.split("\t+\n");
            int n = tiles.length;
            int n2 = 0;
            while (n2 < n) {
                SAMLineParser parser = new SAMLineParser(new DefaultSAMRecordFactory(), ValidationStringency.SILENT, new SAMFileHeader(), null, null);
                String tile = stringArray[n2];
                SAMRecord samRecord = parser.parseLine(tile);
                if (samRecord.getIntegerAttribute("AS") >= 30) {
                    this.out.clear();
                    this.out.set(tile);
                    context.write((Object)new Text(sample), (Object)this.out);
                }
                ++n2;
            }
            ++i;
        }
        this.L1.clear();
        this.L2.clear();
    }

    static enum Counters {
        NOPAIR,
        NEWFLAG;

    }
}

