/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.align.paired;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import genepi.mut.objects.SingleRead;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class PairedAlignerMap
extends Mapper<Text, SequencedFragment, Text, SingleRead> {
    String fileID;
    int chunkLength;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        this.fileID = fileSplit.getPath().getName();
        this.chunkLength = context.getConfiguration().getInt("chunkLength", 0);
    }

    public void map(Text key, SequencedFragment value, Mapper.Context context) throws IOException, InterruptedException {
        String seq = value.getSequence().toString();
        String qual = value.getQuality().toString();
        int readNumber = value.getRead();
        Text outKey = new Text();
        if (this.chunkLength == 0) {
            this.chunkLength = seq.length();
        }
        Iterable seqs = Splitter.fixedLength((int)this.chunkLength).split((CharSequence)seq);
        Iterable quals = Splitter.fixedLength((int)this.chunkLength).split((CharSequence)qual);
        String[] qualArray = (String[])Iterables.toArray((Iterable)quals, String.class);
        int unique = 0;
        for (String subSeq : seqs) {
            SingleRead read = new SingleRead();
            if (key.toString().charAt(key.getLength() - 2) == '/') {
                outKey.set(String.valueOf(Text.decode((byte[])key.getBytes(), (int)0, (int)(key.getLength() - 1))) + "_" + unique);
            } else {
                String _key = this.generateFastqKey(value, unique);
                outKey.set(_key);
            }
            read.setReadLength(subSeq.length());
            read.setName(outKey.toString());
            read.setBases(subSeq.getBytes());
            read.setQual(qualArray[unique].getBytes());
            read.setFilename(this.fileID);
            read.setReadNumber(readNumber);
            context.write((Object)outKey, (Object)read);
            ++unique;
        }
    }

    protected String generateFastqKey(SequencedFragment read, int unique) {
        StringBuilder builder = new StringBuilder();
        builder.append(read.getInstrument() == null ? "" : read.getInstrument());
        builder.append(":").append(read.getRunNumber() == null ? "" : read.getRunNumber());
        builder.append(":").append(read.getFlowcellId() == null ? "" : read.getFlowcellId());
        builder.append(":").append(read.getLane());
        builder.append(":").append(read.getTile());
        builder.append(":").append(read.getXpos());
        builder.append(":").append(read.getYpos());
        builder.append(":").append(unique);
        return builder.toString();
    }
}

