/*
 * Decompiled with CFR 0.152.
 */
package genepi.mut.align;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.common.WorkflowContext;
import genepi.mut.align.paired.PairedAlignerJob;
import genepi.mut.align.single.SingleAlignerJob;
import genepi.mut.util.HadoopJobStep;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AlignStep
extends HadoopJobStep {
    public static final String REF_DIRECTORY = "/tmp/mutation-server-data";
    HashMap<String, List<String>> mapPairs = new HashMap();
    protected static final Log log = LogFactory.getLog(AlignStep.class);

    @Override
    public boolean run(WorkflowContext context) {
        boolean successful = false;
        String input = context.get("input");
        String inType = context.get("inType");
        String output = context.get("bwaOut");
        String archive = context.get("archive");
        if (inType.equals("se")) {
            SingleAlignerJob job = new SingleAlignerJob("Align SingleEnd");
            job.setReferenceArchive(archive);
            job.setInput(input);
            job.setOutput(String.valueOf(output) + "/0");
            job.setFolder(this.getFolder(AlignStep.class));
            job.setJarByClass(AlignStep.class);
            successful = this.executeHadoopJob(job, context);
        } else if (inType.equals("pe")) {
            String chunkLength = context.get("chunkLength");
            this.generatePEPairs(input);
            int round = 0;
            log.info((Object)("Found pairs: " + this.mapPairs.size()));
            Set<String> keys = this.mapPairs.keySet();
            for (String key : keys) {
                List<String> values = this.mapPairs.get(key);
                if (values.size() == 2) {
                    log.info((Object)("executing alignment for key " + key + " [" + round + "]"));
                    String roundOutput = String.valueOf(output) + "/" + round;
                    PairedAlignerJob job = new PairedAlignerJob("Align PairedEnd:" + round);
                    job.setInput(values.get(0), values.get(1));
                    job.setOutput(roundOutput);
                    job.setReferenceArchive(archive);
                    job.setChunkLength(chunkLength);
                    job.setFolder(this.getFolder(AlignStep.class));
                    job.setJarByClass(AlignStep.class);
                    successful = this.executeHadoopJob(job, context);
                    ++round;
                    continue;
                }
                successful = false;
                log.error((Object)"Pair is missing");
            }
        }
        return successful;
    }

    private void generatePEPairs(String input) {
        try {
            FileStatus[] fileList;
            FileSystem fileSystem = FileSystem.get((Configuration)HdfsUtil.getConfiguration());
            FileStatus[] fileStatusArray = fileList = fileSystem.listStatus(new Path(input));
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                BufferedReader reader;
                FileStatus file = fileStatusArray[n2];
                FSDataInputStream in = fileSystem.open(file.getPath());
                if (file.getPath().getName().endsWith(".gz")) {
                    GZIPInputStream gzis = new GZIPInputStream((InputStream)in);
                    InputStreamReader stream = new InputStreamReader(gzis);
                    reader = new BufferedReader(stream);
                } else {
                    reader = new BufferedReader(new InputStreamReader((InputStream)in));
                }
                String line = reader.readLine();
                String[] keySplits = line.split(" ");
                String key = line.charAt(line.length() - 2) == '/' ? keySplits[1].substring(0, keySplits[1].length() - 2) : keySplits[0];
                List<String> values = this.mapPairs.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(file.getPath().toString());
                this.mapPairs.put(key, values);
                reader.close();
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static enum DATA_TYPE {
        PAIRED_FASTQ,
        SINGLE_FASTQ,
        BAM;

    }
}

