/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.plink;

import java.io.IOException;

public class Sample {
    private String id;
    private byte[] alleles;
    private String family;
    private String father;
    private String mother;
    private int sex;
    private float phenotype;
    private boolean noPhenotype = false;

    public Sample(String line) throws IOException {
        System.out.println(line);
        String[] tiles = line.split("\\s{1}(?!\\s)");
        if (tiles.length < 6) {
            throw new IOException("Expected: at last 6 columns. Found: " + tiles.length + " columns.");
        }
        this.family = tiles[0];
        this.id = tiles[1];
        this.father = tiles[2];
        this.mother = tiles[3];
        try {
            this.sex = Integer.parseInt(tiles[4]);
        }
        catch (Exception e) {
            throw new IOException("Sex is not an integer: " + tiles[4] + ".");
        }
        int offset = 0;
        if ((tiles.length - 6) % 2 == 0) {
            offset = 6;
            this.noPhenotype = false;
        } else {
            offset = 5;
            this.noPhenotype = true;
        }
        String firstAllele = tiles[offset];
        boolean separated = firstAllele.length() == 1;
        this.alleles = separated ? new byte[tiles.length - offset] : new byte[2 * (tiles.length - offset) + 2];
        int count = 0;
        for (int i = 0; i < tiles.length - offset; ++i) {
            char allele = tiles[i + offset].charAt(0);
            this.alleles[count] = 0;
            switch (allele) {
                case '0': 
                case 'D': 
                case 'I': 
                case 'N': 
                case 'd': 
                case 'i': 
                case 'n': {
                    this.alleles[count] = 0;
                    break;
                }
                case '1': 
                case 'A': 
                case 'a': {
                    this.alleles[count] = 1;
                    break;
                }
                case '2': 
                case 'C': 
                case 'c': {
                    this.alleles[count] = 2;
                    break;
                }
                case '3': 
                case 'G': 
                case 'g': {
                    this.alleles[count] = 3;
                    break;
                }
                case '4': 
                case 'T': 
                case 't': {
                    this.alleles[count] = 4;
                    break;
                }
                default: {
                    throw new IOException("Genotype coding is invalid: " + allele + ".");
                }
            }
            ++count;
            if (separated) continue;
            char alleleB = tiles[i + offset].charAt(2);
            this.alleles[count] = 0;
            switch (alleleB) {
                case '0': 
                case 'D': 
                case 'I': 
                case 'N': 
                case 'd': 
                case 'i': 
                case 'n': {
                    this.alleles[count] = 0;
                    break;
                }
                case '1': 
                case 'A': 
                case 'a': {
                    this.alleles[count] = 1;
                    break;
                }
                case '2': 
                case 'C': 
                case 'c': {
                    this.alleles[count] = 2;
                    break;
                }
                case '3': 
                case 'G': 
                case 'g': {
                    this.alleles[count] = 3;
                    break;
                }
                case '4': 
                case 'T': 
                case 't': {
                    this.alleles[count] = 4;
                    break;
                }
                default: {
                    throw new IOException("Genotype coding is invalid: " + allele + ".");
                }
            }
            ++count;
        }
    }

    public Sample(Sample sample, byte[] alleles) {
        this.family = sample.family;
        this.id = sample.id;
        this.father = sample.father;
        this.mother = sample.mother;
        this.sex = sample.sex;
        this.phenotype = sample.phenotype;
        this.alleles = alleles;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public byte[] getAlleles() {
        return this.alleles;
    }

    public void setAlleles(byte[] alleles) {
        this.alleles = alleles;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFather() {
        return this.father;
    }

    public void setFather(String father) {
        this.father = father;
    }

    public String getMother() {
        return this.mother;
    }

    public void setMother(String mother) {
        this.mother = mother;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public float getPhenotype() {
        return this.phenotype;
    }

    public void setPhenotype(float phenotype) {
        this.phenotype = phenotype;
    }

    public String toString() {
        return this.id + " (" + this.family + ") " + this.sex + " " + this.alleles.length / 2 + " snps " + this.alleles[this.alleles.length - 1];
    }

    public int getNoAlleles() {
        return this.alleles.length;
    }

    public int getNoSnps() {
        return this.alleles.length / 2;
    }

    public boolean hasNoPhenotype() {
        return this.noPhenotype;
    }
}

