/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.legend;

import genepi.io.FileUtil;
import genepi.io.legend.LegendEntry;
import genepi.io.text.AbstractLineReader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LegendFileReader
extends AbstractLineReader<String> {
    private Map<Integer, Integer> index = new HashMap<Integer, Integer>();
    private Set<Integer> duplicates = new HashSet<Integer>();
    private String line;
    private int oldOffset = 0;
    private BufferedReader myIn;
    private LegendEntry entry = new LegendEntry();
    private String population;
    private int idCol = -1;
    private int posCol = -1;
    private int a0Col = -1;
    private int a1Col = -1;
    private int popCol = -1;
    private int oldPosition = 0;
    private String oldLine = null;

    public LegendFileReader(DataInputStream inputStream) throws IOException {
        super(inputStream);
    }

    public LegendFileReader(String filename, String population) throws IOException {
        super(filename);
        this.population = population;
    }

    public void createIndex() throws IOException {
        int offset = 0;
        int oldPosition = -1;
        while (this.next()) {
            String[] tiles;
            String line = this.get();
            if (!line.startsWith("id")) {
                tiles = line.split(" ", 3);
                int position = Integer.parseInt(tiles[this.posCol]);
                if (this.index.containsKey(position)) {
                    this.duplicates.add(position);
                }
                this.index.put(position, offset);
                if (oldPosition > position) {
                    throw new IOException("Legend File is not sorted.");
                }
                oldPosition = position;
            } else {
                tiles = line.split(" ");
                int i = 0;
                for (String tile : tiles) {
                    if (tile.equals("id")) {
                        this.idCol = i;
                    }
                    if (tile.equals("position")) {
                        this.posCol = i;
                    }
                    if (tile.equals("a0")) {
                        this.a0Col = i;
                    }
                    if (tile.equals("a1")) {
                        this.a1Col = i;
                    }
                    if (tile.equals(this.population + ".aaf")) {
                        this.popCol = i;
                    }
                    ++i;
                }
            }
            offset += line.length() + 1;
        }
        this.close();
    }

    @Override
    public String get() {
        return this.line;
    }

    public void initSearch() throws IOException {
        FileInputStream inputStream = new FileInputStream(this.getFilename());
        InputStream in2 = FileUtil.decompressStream(inputStream);
        this.myIn = new BufferedReader(new InputStreamReader(in2));
    }

    public LegendEntry findByPosition(int position) throws IOException {
        String line = this.findLineByPosition(position);
        if (line != null) {
            String[] tiles = line.split(" ");
            this.entry.setRsId(tiles[this.idCol]);
            this.entry.setAlleleA(tiles[this.a0Col].charAt(0));
            this.entry.setAlleleB(tiles[this.a1Col].charAt(0));
            this.entry.setType("-");
            float aaf = 0.0f;
            if (this.popCol != -1) {
                aaf = Float.parseFloat(tiles[this.popCol]);
            }
            this.entry.setFrequencyA(1.0f - aaf);
            this.entry.setFrequencyB(aaf);
            return this.entry;
        }
        return null;
    }

    public String findLineByPosition(int position) throws IOException {
        Integer offset = this.index.get(position);
        if (offset != null) {
            if (this.oldPosition != position) {
                try {
                    this.myIn.skip(offset - this.oldOffset);
                    String line = this.myIn.readLine();
                    this.oldOffset = offset + line.length() + 1;
                    this.oldLine = line;
                    this.oldPosition = position;
                    return line;
                }
                catch (Exception e) {
                    throw new IOException("Problem reading position '" + position + "' [Old position: " + this.oldPosition + ", OldOffset" + this.oldOffset + ", New Offset" + offset + "]");
                }
            }
            return this.oldLine;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return null;
    }

    @Override
    protected void parseLine(String arg0) throws Exception {
        this.line = arg0;
    }
}

